/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.util.Arrays;
import prefuse.util.ArrayLib;
import prefuse.visual.VisualItem;
import prefuse.visual.sort.ItemSorter;

public class RenderingQueue {
    public ItemSorter sort = new ItemSorter();
    public VisualItem[] ritems = new VisualItem[256];
    public int[] rscores = new int[256];
    public int rsize = 0;
    public VisualItem[] pitems = new VisualItem[256];
    public int[] pscores = new int[256];
    public int psize = 0;
    public boolean psorted = false;
    static transient VisualItem[] a;
    static transient int[] b;

    public void clear() {
        Arrays.fill(this.ritems, 0, this.rsize, null);
        Arrays.fill(this.pitems, 0, this.psize, null);
        this.rsize = 0;
        this.psize = 0;
    }

    public void clean() {
        this.clear();
        this.ritems = new VisualItem[256];
        this.rscores = new int[256];
        this.pitems = new VisualItem[256];
        this.pscores = new int[256];
        a = null;
        b = null;
    }

    public void addToRenderQueue(VisualItem visualItem) {
        if (this.ritems.length == this.rsize) {
            int n2 = 3 * this.ritems.length / 2 + 1;
            VisualItem[] visualItemArray = new VisualItem[n2];
            int[] nArray = new int[n2];
            System.arraycopy(this.ritems, 0, visualItemArray, 0, this.rsize);
            System.arraycopy(this.rscores, 0, nArray, 0, this.rsize);
            this.ritems = visualItemArray;
            this.rscores = nArray;
        }
        this.ritems[this.rsize] = visualItem;
        this.rscores[this.rsize++] = this.sort != null ? this.sort.score(visualItem) : 0;
    }

    public void addToPickingQueue(VisualItem visualItem) {
        if (this.pitems.length == this.psize) {
            int n2 = 3 * this.pitems.length / 2 + 1;
            VisualItem[] visualItemArray = new VisualItem[n2];
            int[] nArray = new int[n2];
            System.arraycopy(this.pitems, 0, visualItemArray, 0, this.psize);
            System.arraycopy(this.pscores, 0, nArray, 0, this.psize);
            this.pitems = visualItemArray;
            this.pscores = nArray;
        }
        this.pitems[this.psize] = visualItem;
        this.pscores[this.psize++] = this.sort != null ? this.sort.score(visualItem) : 0;
        this.psorted = false;
    }

    public void sortRenderQueue() {
        this.a(this.ritems, this.rscores, this.rsize);
    }

    public void sortPickingQueue() {
        this.a(this.pitems, this.pscores, this.psize);
        this.psorted = true;
    }

    private void a(VisualItem[] visualItemArray, int[] nArray, int n2) {
        if (this.sort == null) {
            return;
        }
        if (a == null || a.length < n2) {
            a = new VisualItem[visualItemArray.length];
            b = new int[nArray.length];
        }
        ArrayLib.sort(nArray, visualItemArray, b, a, 0, n2);
    }
}

