/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;

public class CircularWallForce
extends AbstractForce {
    private static String[] a;
    public static final float DEFAULT_GRAV_CONSTANT = -0.1f;
    public static final float DEFAULT_MIN_GRAV_CONSTANT = -1.0f;
    public static final float DEFAULT_MAX_GRAV_CONSTANT = 1.0f;
    public static final int GRAVITATIONAL_CONST = 0;
    private float b;
    private float c;
    private float d;

    public CircularWallForce(float f2, float f3, float f4, float f5) {
        this.params = new float[]{f2};
        this.minValues = new float[]{-1.0f};
        this.maxValues = new float[]{1.0f};
        this.b = f3;
        this.c = f4;
        this.d = f5;
    }

    public CircularWallForce(float f2, float f3, float f4) {
        this(-0.1f, f2, f3, f4);
    }

    @Override
    public boolean isItemForce() {
        return true;
    }

    @Override
    protected String[] getParameterNames() {
        return a;
    }

    @Override
    public void getForce(ForceItem forceItem) {
        float[] fArray = forceItem.location;
        float f2 = this.b - fArray[0];
        float f3 = this.c - fArray[1];
        float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
        float f5 = this.d - f4;
        float f6 = f5 > 0.0f ? -1.0f : 1.0f;
        float f7 = f6 * this.params[0] * forceItem.mass / (f5 * f5);
        if ((double)f4 == 0.0) {
            f2 = ((float)Math.random() - 0.5f) / 50.0f;
            f3 = ((float)Math.random() - 0.5f) / 50.0f;
            f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
        }
        forceItem.force[0] = forceItem.force[0] + f7 * f2 / f4;
        forceItem.force[1] = forceItem.force[1] + f7 * f3 / f4;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                stringArray = new String[1];
                char[] cArray3 = "#\u0003p\u0000J\u0010\u0010e\u001fL\n\u0010}5L\n\u0002e\u0017M\u0010".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 100;
                            break;
                        }
                        case 1: {
                            n7 = 113;
                            break;
                        }
                        case 2: {
                            n7 = 17;
                            break;
                        }
                        case 3: {
                            n7 = 118;
                            break;
                        }
                        default: {
                            n7 = 35;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[0] = new String(cArray).intern();
        a = stringArray;
    }
}

