/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import java.util.Iterator;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.Integrator;

public class EulerIntegrator
implements Integrator {
    @Override
    public void integrate(ForceSimulator forceSimulator, long l2) {
        int n2 = ForceItem.a;
        float f2 = forceSimulator.getSpeedLimit();
        Iterator iterator = forceSimulator.getItems();
        while (iterator.hasNext()) {
            ForceItem forceItem = (ForceItem)iterator.next();
            forceItem.location[0] = forceItem.location[0] + (float)l2 * forceItem.velocity[0];
            forceItem.location[1] = forceItem.location[1] + (float)l2 * forceItem.velocity[1];
            float f3 = (float)l2 / 0.5f;
            forceItem.velocity[0] = forceItem.velocity[0] + f3 * forceItem.force[0];
            forceItem.velocity[1] = forceItem.velocity[1] + f3 * forceItem.force[1];
            float f4 = forceItem.velocity[0];
            float f5 = forceItem.velocity[1];
            float f6 = (float)Math.sqrt(f4 * f4 + f5 * f5);
            if (f6 > 2.0f) {
                forceItem.velocity[0] = 2.0f * f4 / f6;
                forceItem.velocity[1] = 2.0f * f5 / f6;
            }
            if (n2 == 0) continue;
        }
    }
}

