/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import java.awt.geom.Line2D;
import prefuse.data.expression.AbstractExpression;
import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;

public class WallForce
extends AbstractForce {
    private static String[] a;
    public static final float DEFAULT_GRAV_CONSTANT = -0.1f;
    public static final float DEFAULT_MIN_GRAV_CONSTANT = -1.0f;
    public static final float DEFAULT_MAX_GRAV_CONSTANT = 1.0f;
    public static final int GRAVITATIONAL_CONST = 0;
    private float b;
    private float c;
    private float d;
    private float e;
    private float f;
    private float g;

    public WallForce(float f2, float f3, float f4, float f5, float f6) {
        this.params = new float[]{f2};
        this.minValues = new float[]{-1.0f};
        this.maxValues = new float[]{1.0f};
        this.b = f3;
        this.c = f4;
        this.d = f5;
        this.e = f6;
        this.f = f5 - f3;
        this.g = f6 - f4;
        float f7 = (float)Math.sqrt(this.f * this.f + this.g * this.g);
        if ((double)this.f != 0.0) {
            this.f /= f7;
        }
        if ((double)this.g != 0.0) {
            this.g /= f7;
        }
    }

    public WallForce(float f2, float f3, float f4, float f5) {
        this(-0.1f, f2, f3, f4, f5);
    }

    @Override
    public boolean isItemForce() {
        return true;
    }

    @Override
    protected String[] getParameterNames() {
        return a;
    }

    @Override
    public void getForce(ForceItem forceItem) {
        int n2 = ForceItem.a;
        float[] fArray = forceItem.location;
        int n3 = Line2D.relativeCCW(this.b, this.c, this.d, this.e, fArray[0], fArray[1]);
        float f2 = (float)Line2D.ptSegDist(this.b, this.c, this.d, this.e, fArray[0], fArray[1]);
        if ((double)f2 == 0.0) {
            f2 = (float)Math.random() / 100.0f;
        }
        float f3 = this.params[0] * forceItem.mass / (f2 * f2 * f2);
        if (fArray[0] >= Math.min(this.b, this.d) && fArray[0] <= Math.max(this.b, this.d)) {
            forceItem.force[1] = forceItem.force[1] + (float)n3 * f3 * this.f;
        }
        if (fArray[1] >= Math.min(this.c, this.e) && fArray[1] <= Math.max(this.c, this.e)) {
            forceItem.force[0] = forceItem.force[0] + (float)(-1 * n3) * f3 * this.g;
        }
        if (AbstractExpression.b) {
            ForceItem.a = ++n2;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                stringArray = new String[1];
                char[] cArray3 = "\\\u0013\rTqo\u0000\u0018Kwu\u0000\u0000awu\u0012\u0018Cvo".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 27;
                            break;
                        }
                        case 1: {
                            n7 = 97;
                            break;
                        }
                        case 2: {
                            n7 = 108;
                            break;
                        }
                        case 3: {
                            n7 = 34;
                            break;
                        }
                        default: {
                            n7 = 24;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[0] = new String(cArray).intern();
        a = stringArray;
    }
}

