/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.io;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.swing.JFileChooser;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.io.CSVTableReader;
import prefuse.data.io.DelimitedTextTableReader;
import prefuse.data.io.GraphMLReader;
import prefuse.data.io.GraphReader;
import prefuse.data.io.TableReader;
import prefuse.data.io.TreeMLReader;
import prefuse.util.StringLib;
import prefuse.util.collections.ByteArrayList;
import prefuse.util.io.SimpleFileFilter;

public class IOLib {
    public static boolean a;
    private static final String[] z;

    private IOLib() {
    }

    public static boolean isUrlString(String string) {
        return string.startsWith(z[8]) || string.startsWith(z[9]) || string.startsWith(z[7]);
    }

    public static URL urlFromString(String string) {
        return IOLib.urlFromString(string, null, true);
    }

    public static URL urlFromString(String string, Class clazz, boolean bl) {
        URL uRL = null;
        if (IOLib.isUrlString(string)) {
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            File file;
            uRL = clazz != null ? clazz.getResource(string) : IOLib.class.getResource(string);
            if (uRL == null && !string.startsWith("/")) {
                uRL = IOLib.class.getResource("/" + string);
            }
            if (bl && uRL == null && (file = new File(string)).exists()) {
                try {
                    uRL = file.toURI().toURL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return uRL;
    }

    public static InputStream streamFromString(String string) throws IOException {
        InputStream inputStream = null;
        URL uRL = IOLib.urlFromString(string, null, false);
        if (uRL != null) {
            inputStream = uRL.openStream();
        } else {
            File file = new File(string);
            if (file.exists()) {
                inputStream = new FileInputStream(file);
            }
        }
        if (inputStream == null) {
            return null;
        }
        if (IOLib.isGZipFile(string)) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static String getExtension(File file) {
        return file != null ? IOLib.getExtension(file.getName()) : null;
    }

    public static boolean isGZipFile(String string) {
        String string2 = IOLib.getExtension(string);
        return z[5].equals(string2) || "z".equals(string2);
    }

    public static boolean isZipFile(String string) {
        return z[10].equals(IOLib.getExtension(string));
    }

    public static String getExtension(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 > 0 && n2 < string.length() - 1) {
            return string.substring(n2 + 1).toLowerCase();
        }
        return null;
    }

    public static ByteArrayList readAsBytes(InputStream inputStream) throws IOException {
        boolean bl = a;
        ByteArrayList byteArrayList = new ByteArrayList();
        byte[] byArray = new byte[8192];
        int n2 = -1;
        while ((n2 = inputStream.read(byArray)) >= 0) {
            byteArrayList.add(byArray, 0, n2);
            if (!bl) continue;
        }
        return byteArrayList;
    }

    public static String readAsString(InputStream inputStream) throws IOException {
        boolean bl = a;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[8192];
        int n2 = -1;
        while ((n2 = inputStream.read(byArray)) >= 0) {
            String string = new String(byArray, 0, n2);
            stringBuffer.append(string);
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }

    public static String readAsString(String string) throws IOException {
        return IOLib.readAsString(IOLib.streamFromString(string));
    }

    public static Table getTableFile(Component component) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(z[15]);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(z[12], z[14], new CSVTableReader());
        simpleFileFilter.addExtension(z[5]);
        jFileChooser.setFileFilter(simpleFileFilter);
        simpleFileFilter = new SimpleFileFilter(z[16], z[13], new DelimitedTextTableReader("|"));
        simpleFileFilter.addExtension(z[5]);
        jFileChooser.setFileFilter(simpleFileFilter);
        simpleFileFilter = new SimpleFileFilter(z[16], z[11], new DelimitedTextTableReader());
        simpleFileFilter.addExtension(z[5]);
        jFileChooser.setFileFilter(simpleFileFilter);
        int n2 = jFileChooser.showOpenDialog(component);
        if (n2 != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        simpleFileFilter = (SimpleFileFilter)jFileChooser.getFileFilter();
        TableReader tableReader = (TableReader)simpleFileFilter.getUserData();
        try {
            return tableReader.readTable(IOLib.streamFromString(file.getAbsolutePath()));
        }
        catch (Exception exception) {
            Logger.getLogger(IOLib.class.getName()).warning(exception.getMessage() + "\n" + StringLib.getStackTrace(exception));
            return null;
        }
    }

    public static Graph getGraphFile(Component component) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(z[6]);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(z[1], z[0], new TreeMLReader());
        simpleFileFilter.addExtension(z[4]);
        simpleFileFilter.addExtension(z[5]);
        jFileChooser.setFileFilter(simpleFileFilter);
        simpleFileFilter = new SimpleFileFilter(z[1], z[3], new GraphMLReader());
        simpleFileFilter.addExtension(z[2]);
        simpleFileFilter.addExtension(z[5]);
        jFileChooser.setFileFilter(simpleFileFilter);
        int n2 = jFileChooser.showOpenDialog(component);
        if (n2 != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        simpleFileFilter = (SimpleFileFilter)jFileChooser.getFileFilter();
        GraphReader graphReader = (GraphReader)simpleFileFilter.getUserData();
        try {
            return graphReader.readGraph(IOLib.streamFromString(file.getAbsolutePath()));
        }
        catch (Exception exception) {
            Logger.getLogger(IOLib.class.getName()).warning(exception.getMessage() + "\n" + StringLib.getStackTrace(exception));
            return null;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[17];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\\A\u0005~\u0001D\u0013&r m\u0013H1bp^\f7l\"\u001d\u0014i)m^\f2";
        int n3 = -1;
        block24: while (true) {
            char[] cArray;
            block29: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block28: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block28;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block29;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 8;
                                break;
                            }
                            case 1: {
                                n9 = 51;
                                break;
                            }
                            case 2: {
                                n9 = 96;
                                break;
                            }
                            case 3: {
                                n9 = 27;
                                break;
                            }
                            default: {
                                n9 = 76;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "p^\f";
                    n3 = 0;
                    continue block24;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "oA\u0001k$e_";
                    n3 = 1;
                    continue block24;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "OA\u0001k$E\u007f@]%dV@3f&K\rw`(\u0019N|>iC\bv !";
                    n3 = 2;
                    continue block24;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "|A\u0005~!d";
                    n3 = 3;
                    continue block24;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "oI";
                    n3 = 4;
                    continue block24;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "GC\u0005ulOA\u0001k$(\\\u0012;\u0018zV\u0005;\na_\u0005";
                    n3 = 5;
                    continue block24;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "nZ\f~v'";
                    n3 = 6;
                    continue block24;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "`G\u0014kv'";
                    n3 = 7;
                    continue block24;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "nG\u0010!c";
                    n3 = 8;
                    continue block24;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "rZ\u0010";
                    n3 = 9;
                    continue block24;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\\R\u00026\bm_\tv%|V\u0004;\u0018mK\u0014;\na_\u0005;d\"\u001d\u0014c8!";
                    n3 = 10;
                    continue block24;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "k@\u0016";
                    n3 = 11;
                    continue block24;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "XZ\u0010~aLV\fr!aG\u0005\u007fl\\V\u0018olNZ\f~l \u0019No4|\u001a";
                    n3 = 12;
                    continue block24;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "K\\\rv-(`\u0005k-zR\u0014~((e\u0001w9m@@3\u000f[eI;\na_\u0005;d\"\u001d\u0003h:!";
                    n3 = 13;
                    continue block24;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "GC\u0005ul\\R\u0002w)(u\tw)";
                    n3 = 14;
                    continue block24;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "|K\u0014";
                    n3 = 15;
                    continue block24;
                }
                case 15: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

