/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prefuse.data.expression.AbstractExpression;
import prefuse.util.ui.UILib;

public class JRangeSlider
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int LEFTRIGHT_TOPBOTTOM = 0;
    public static final int RIGHTLEFT_BOTTOMTOP = 1;
    public static final int PREFERRED_BREADTH = 16;
    public static final int PREFERRED_LENGTH = 300;
    protected static final int ARROW_SZ = 16;
    protected static final int ARROW_WIDTH = 8;
    protected static final int ARROW_HEIGHT = 4;
    protected BoundedRangeModel model;
    protected int orientation;
    protected int direction;
    protected boolean empty;
    protected int increment = 1;
    protected int minExtent = 0;
    protected ArrayList listeners = new ArrayList();
    protected ChangeEvent changeEvent = null;
    protected ChangeListener lstnr;
    protected Color thumbColor = new Color(150, 180, 220);
    int a;
    int b;
    int c;
    int d;

    public JRangeSlider(int n2, int n3, int n4, int n5, int n6) {
        this(new DefaultBoundedRangeModel(n4, n5 - n4, n2, n3), n6, 0);
    }

    public JRangeSlider(int n2, int n3, int n4, int n5, int n6, int n7) {
        this(new DefaultBoundedRangeModel(n4, n5 - n4, n2, n3), n6, n7);
    }

    public JRangeSlider(BoundedRangeModel boundedRangeModel, int n2, int n3) {
        super.setFocusable(true);
        this.model = boundedRangeModel;
        this.orientation = n2;
        this.direction = n3;
        this.setForeground(Color.LIGHT_GRAY);
        this.lstnr = this.createListener();
        boundedRangeModel.addChangeListener(this.lstnr);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    protected ChangeListener createListener() {
        return new RangeSliderChangeListener();
    }

    public int getLowValue() {
        return this.model.getValue();
    }

    public void setLowValue(int n2) {
        int n3 = this.model.getValue() - n2 + this.model.getExtent();
        this.model.setRangeProperties(n2, n3, this.model.getMinimum(), this.model.getMaximum(), false);
        this.model.setValue(n2);
    }

    public int getHighValue() {
        return this.model.getValue() + this.model.getExtent();
    }

    public void setHighValue(int n2) {
        this.model.setExtent(n2 - this.model.getValue());
    }

    public void setRange(int n2, int n3) {
        this.model.setRangeProperties(n2, n3 - n2, this.model.getMinimum(), this.model.getMaximum(), false);
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int n2) {
        this.model.setMinimum(n2);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int n2) {
        this.model.setMaximum(n2);
    }

    public void setMinExtent(int n2) {
        this.minExtent = n2;
    }

    public void setEmpty(boolean bl) {
        this.empty = bl;
        this.repaint();
    }

    public Color getThumbColor() {
        return this.thumbColor;
    }

    public void setThumbColor(Color color) {
        this.thumbColor = color;
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        this.model.removeChangeListener(this.lstnr);
        this.model = boundedRangeModel;
        this.model.addChangeListener(this.lstnr);
        this.repaint();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    protected void fireChangeEvent() {
        boolean bl = UILib.a;
        this.repaint();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(this.changeEvent);
            if (!bl) continue;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.orientation == 0) {
            return new Dimension(16, 300);
        }
        return new Dimension(300, 16);
    }

    protected void customPaint(Graphics2D graphics2D, int n2, int n3) {
    }

    @Override
    public void paintComponent(Graphics graphics) {
        boolean bl;
        block15: {
            Graphics2D graphics2D;
            int n2;
            int n3;
            int n4;
            block16: {
                block13: {
                    int n5;
                    block14: {
                        block11: {
                            block12: {
                                bl = UILib.a;
                                Rectangle rectangle = this.getBounds();
                                n5 = (int)rectangle.getWidth() - 1;
                                n4 = (int)rectangle.getHeight() - 1;
                                n3 = this.toScreen(this.getLowValue());
                                n2 = this.toScreen(this.getHighValue());
                                if (!this.empty) break block11;
                                if (this.direction != 0) break block12;
                                n3 = 16;
                                int n6 = n2 = this.orientation == 0 ? n4 - 16 : n5 - 16;
                                if (!bl) break block11;
                            }
                            n3 = this.orientation == 0 ? n4 - 16 : n5 - 16;
                            n2 = 16;
                        }
                        graphics2D = (Graphics2D)graphics;
                        graphics2D.setColor(this.getBackground());
                        graphics2D.fillRect(0, 0, n5, n4);
                        graphics2D.setColor(this.getForeground());
                        graphics2D.drawRect(0, 0, n5, n4);
                        this.customPaint(graphics2D, n5, n4);
                        graphics2D.setStroke(new BasicStroke(1.0f));
                        if (this.orientation != 0) break block13;
                        if (this.direction != 0) break block14;
                        graphics2D.setColor(this.getForeground());
                        graphics2D.fillRect(0, n3 - 16, n5, 15);
                        this.paint3DRectLighting(graphics2D, 0, n3 - 16, n5, 15);
                        if (this.thumbColor != null) {
                            graphics2D.setColor(this.thumbColor);
                            graphics2D.fillRect(0, n3, n5, n2 - n3 - 1);
                            this.paint3DRectLighting(graphics2D, 0, n3, n5, n2 - n3 - 1);
                        }
                        graphics2D.setColor(this.getForeground());
                        graphics2D.fillRect(0, n2, n5, 15);
                        this.paint3DRectLighting(graphics2D, 0, n2, n5, 15);
                        graphics2D.setColor(Color.black);
                        this.paintArrow(graphics2D, (double)(n5 - 8) / 2.0, (double)(n3 - 16) + 6.0, 8, 4, true);
                        this.paintArrow(graphics2D, (double)(n5 - 8) / 2.0, (double)n2 + 6.0, 8, 4, false);
                        if (!bl) break block15;
                    }
                    graphics2D.setColor(this.getForeground());
                    graphics2D.fillRect(0, n3, n5, 15);
                    this.paint3DRectLighting(graphics2D, 0, n3, n5, 15);
                    if (this.thumbColor != null) {
                        graphics2D.setColor(this.thumbColor);
                        graphics2D.fillRect(0, n2, n5, n3 - n2 - 1);
                        this.paint3DRectLighting(graphics2D, 0, n2, n5, n3 - n2 - 1);
                    }
                    graphics2D.setColor(this.getForeground());
                    graphics2D.fillRect(0, n2 - 16, n5, 15);
                    this.paint3DRectLighting(graphics2D, 0, n2 - 16, n5, 15);
                    graphics2D.setColor(Color.black);
                    this.paintArrow(graphics2D, (double)(n5 - 8) / 2.0, (double)n3 + 6.0, 8, 4, false);
                    this.paintArrow(graphics2D, (double)(n5 - 8) / 2.0, (double)(n2 - 16) + 6.0, 8, 4, true);
                    if (!bl) break block15;
                }
                if (this.direction != 0) break block16;
                graphics2D.setColor(this.getForeground());
                graphics2D.fillRect(n3 - 16, 0, 15, n4);
                this.paint3DRectLighting(graphics2D, n3 - 16, 0, 15, n4);
                if (this.thumbColor != null) {
                    graphics2D.setColor(this.thumbColor);
                    graphics2D.fillRect(n3, 0, n2 - n3 - 1, n4);
                    this.paint3DRectLighting(graphics2D, n3, 0, n2 - n3 - 1, n4);
                }
                graphics2D.setColor(this.getForeground());
                graphics2D.fillRect(n2, 0, 15, n4);
                this.paint3DRectLighting(graphics2D, n2, 0, 15, n4);
                graphics2D.setColor(Color.black);
                this.paintArrow(graphics2D, (double)(n3 - 16) + 6.0, (double)(n4 - 8) / 2.0, 4, 8, true);
                this.paintArrow(graphics2D, (double)n2 + 6.0, (double)(n4 - 8) / 2.0, 4, 8, false);
                if (!bl) break block15;
            }
            graphics2D.setColor(this.getForeground());
            graphics2D.fillRect(n3, 0, 15, n4);
            this.paint3DRectLighting(graphics2D, n3, 0, 15, n4);
            if (this.thumbColor != null) {
                graphics2D.setColor(this.thumbColor);
                graphics2D.fillRect(n2, 0, n3 - n2 - 1, n4);
                this.paint3DRectLighting(graphics2D, n2, 0, n3 - n2 - 1, n4);
            }
            graphics2D.setColor(this.getForeground());
            graphics2D.fillRect(n2 - 16, 0, 15, n4);
            this.paint3DRectLighting(graphics2D, n2 - 16, 0, 15, n4);
            graphics2D.setColor(Color.black);
            this.paintArrow(graphics2D, (double)n3 + 6.0, (double)(n4 - 8) / 2.0, 4, 8, true);
            this.paintArrow(graphics2D, (double)(n2 - 16) + 6.0, (double)(n4 - 8) / 2.0, 4, 8, false);
        }
        if (AbstractExpression.b) {
            UILib.a = !bl;
        }
    }

    protected void paintArrow(Graphics2D graphics2D, double d2, double d3, int n2, int n3, boolean bl) {
        block11: {
            int n4;
            int n5;
            int n6;
            boolean bl2;
            block12: {
                block9: {
                    block10: {
                        bl2 = UILib.a;
                        n6 = (int)(d2 + 0.5);
                        n5 = (int)(d3 + 0.5);
                        if (this.orientation != 0) break block9;
                        if (n2 % 2 == 0) {
                            --n2;
                        }
                        if (!bl) break block10;
                        for (n4 = 0; n4 < n2 / 2 + 1; ++n4) {
                            graphics2D.drawLine(n6 + n4, n5 + n4, n6 + n2 - n4 - 1, n5 + n4);
                            if (!bl2) continue;
                        }
                        if (!bl2) break block11;
                    }
                    for (n4 = 0; n4 < n2 / 2 + 1; ++n4) {
                        graphics2D.drawLine(n6 + n2 / 2 - n4, n5 + n4, n6 + n2 - n2 / 2 + n4 - 1, n5 + n4);
                        if (!bl2) continue;
                    }
                    if (!bl2) break block11;
                }
                if (n3 % 2 == 0) {
                    --n3;
                }
                if (!bl) break block12;
                for (n4 = 0; n4 < n3 / 2 + 1; ++n4) {
                    graphics2D.drawLine(n6 + n4, n5 + n4, n6 + n4, n5 + n3 - n4 - 1);
                    if (!bl2) continue;
                }
                if (!bl2) break block11;
            }
            for (n4 = 0; n4 < n3 / 2 + 1; ++n4) {
                graphics2D.drawLine(n6 + n4, n5 + n3 / 2 - n4, n6 + n4, n5 + n3 - n3 / 2 + n4 - 1);
                if (!bl2) continue;
            }
        }
    }

    protected void paint3DRectLighting(Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
        graphics2D.setColor(Color.white);
        graphics2D.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + n5 - 1);
        graphics2D.drawLine(n2 + 1, n3 + 1, n2 + n4 - 1, n3 + 1);
        graphics2D.setColor(Color.gray);
        graphics2D.drawLine(n2 + 1, n3 + n5 - 1, n2 + n4 - 1, n3 + n5 - 1);
        graphics2D.drawLine(n2 + n4 - 1, n3 + 1, n2 + n4 - 1, n3 + n5 - 1);
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawLine(n2, n3 + n5, n2 + n4, n3 + n5);
        graphics2D.drawLine(n2 + n4, n3, n2 + n4, n3 + n5);
    }

    protected int toLocal(int n2) {
        double d2;
        int n3;
        Dimension dimension;
        block6: {
            block5: {
                dimension = this.getSize();
                n3 = this.getMinimum();
                if (this.orientation != 0) break block5;
                d2 = (double)(dimension.height - 32) / (double)(this.getMaximum() - n3);
                if (!UILib.a) break block6;
            }
            d2 = (double)(dimension.width - 32) / (double)(this.getMaximum() - n3);
        }
        if (this.direction == 0) {
            return (int)((double)(n2 - 16) / d2 + (double)n3 + 0.5);
        }
        if (this.orientation == 0) {
            return (int)((double)(dimension.height - n2 - 16) / d2 + (double)n3 + 0.5);
        }
        return (int)((double)(dimension.width - n2 - 16) / d2 + (double)n3 + 0.5);
    }

    protected int toScreen(int n2) {
        double d2;
        int n3;
        Dimension dimension;
        block6: {
            block5: {
                dimension = this.getSize();
                n3 = this.getMinimum();
                if (this.orientation != 0) break block5;
                d2 = (double)(dimension.height - 32) / (double)(this.getMaximum() - n3);
                if (!UILib.a) break block6;
            }
            d2 = (double)(dimension.width - 32) / (double)(this.getMaximum() - n3);
        }
        if (this.direction == 0) {
            return (int)(16.0 + (double)(n2 - n3) * d2 + 0.5);
        }
        if (this.orientation == 0) {
            return (int)((double)dimension.height - (double)(n2 - n3) * d2 - 16.0 + 0.5);
        }
        return (int)((double)dimension.width - (double)(n2 - n3) * d2 - 16.0 + 0.5);
    }

    protected double toScreenDouble(int n2) {
        double d2;
        int n3;
        Dimension dimension;
        block6: {
            block5: {
                dimension = this.getSize();
                n3 = this.getMinimum();
                if (this.orientation != 0) break block5;
                d2 = (double)(dimension.height - 32) / (double)(this.getMaximum() + 1 - n3);
                if (!UILib.a) break block6;
            }
            d2 = (double)(dimension.width - 32) / (double)(this.getMaximum() + 1 - n3);
        }
        if (this.direction == 0) {
            return 16.0 + (double)(n2 - n3) * d2;
        }
        if (this.orientation == 0) {
            return (double)dimension.height - (double)(n2 - n3) * d2 - 16.0;
        }
        return (double)dimension.width - (double)(n2 - n3) * d2 - 16.0;
    }

    private int a(int n2) {
        int n3;
        block6: {
            int n4;
            block9: {
                int n5;
                boolean bl;
                block8: {
                    block4: {
                        block7: {
                            block5: {
                                bl = UILib.a;
                                n5 = this.toScreen(this.getLowValue());
                                n4 = this.toScreen(this.getHighValue());
                                n3 = 0;
                                if (this.direction != 0) break block4;
                                if (n2 <= n5 - 16 || n2 >= n5) break block5;
                                n3 = 1;
                                if (!bl) break block6;
                            }
                            if (n2 < n5 || n2 > n4) break block7;
                            n3 = 2;
                            if (!bl) break block6;
                        }
                        if (n2 <= n4 || n2 >= n4 + 16) break block6;
                        n3 = 3;
                        if (!bl) break block6;
                    }
                    if (n2 <= n5 || n2 >= n5 + 16) break block8;
                    n3 = 1;
                    if (!bl) break block6;
                }
                if (n2 > n5 || n2 < n4) break block9;
                n3 = 2;
                if (!bl) break block6;
            }
            if (n2 > n4 - 16 && n2 < n4) {
                n3 = 3;
            }
        }
        return n3;
    }

    private void b(int n2) {
        this.model.setValue(this.model.getValue() + n2);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        block3: {
            block2: {
                if (this.orientation != 0) break block2;
                this.a = this.a(mouseEvent.getY());
                this.b = mouseEvent.getY() - this.toScreen(this.getLowValue());
                this.c = mouseEvent.getY() - this.toScreen(this.getHighValue());
                this.d = mouseEvent.getY();
                if (!UILib.a) break block3;
            }
            this.a = this.a(mouseEvent.getX());
            this.b = mouseEvent.getX() - this.toScreen(this.getLowValue());
            this.c = mouseEvent.getX() - this.toScreen(this.getHighValue());
            this.d = mouseEvent.getX();
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl = UILib.a;
        this.requestFocus();
        int n2 = this.orientation == 0 ? mouseEvent.getY() : mouseEvent.getX();
        int n3 = this.getMinimum();
        int n4 = this.getMaximum();
        int n5 = this.getLowValue();
        int n6 = this.getHighValue();
        switch (this.a) {
            case 1: {
                int n7 = this.toLocal(n2 - this.b);
                if (n7 < n3) {
                    n7 = n3;
                }
                if (n7 > n4 - this.minExtent) {
                    n7 = n4 - this.minExtent;
                }
                if (n7 > n6 - this.minExtent) {
                    this.setRange(n7, n7 + this.minExtent);
                    if (!bl) break;
                }
                this.setLowValue(n7);
                if (!bl) break;
            }
            case 3: {
                int n8 = this.toLocal(n2 - this.c);
                if (n8 < n3 + this.minExtent) {
                    n8 = n3 + this.minExtent;
                }
                if (n8 > n4) {
                    n8 = n4;
                }
                if (n8 < n5 + this.minExtent) {
                    this.setRange(n8 - this.minExtent, n8);
                    if (!bl) break;
                }
                this.setHighValue(n8);
                if (!bl) break;
            }
            case 2: {
                int n9 = this.toLocal(n2 - this.b) - n5;
                if (n9 < 0 && n5 + n9 < n3) {
                    n9 = n3 - n5;
                }
                if (n9 > 0 && n6 + n9 > n4) {
                    n9 = n4 - n6;
                }
                if (n9 == 0) break;
                this.b(n9);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.a = 0;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        block15: {
            boolean bl;
            block14: {
                bl = UILib.a;
                if (this.orientation != 0) break block14;
                switch (this.a(mouseEvent.getY())) {
                    case 1: {
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        if (!bl) break;
                    }
                    case 3: {
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        if (!bl) break;
                    }
                    case 2: {
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        if (!bl) break;
                    }
                    case 0: {
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                if (!bl) break block15;
            }
            switch (this.a(mouseEvent.getX())) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    if (!bl) break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    if (!bl) break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    if (!bl) break;
                }
                case 0: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void c(int n2) {
        this.model.setRangeProperties(this.model.getValue() - n2, this.model.getExtent() + 2 * n2, this.model.getMinimum(), this.model.getMaximum(), false);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        block5: {
            int n2;
            int n3;
            boolean bl;
            boolean bl2;
            boolean bl3;
            block7: {
                int n4;
                int n5;
                boolean bl4;
                boolean bl5;
                boolean bl6;
                block6: {
                    block4: {
                        bl6 = UILib.a;
                        int n6 = keyEvent.getKeyCode();
                        bl3 = this.orientation == 0;
                        bl5 = n6 == 40;
                        bl2 = n6 == 38;
                        bl4 = n6 == 37;
                        bl = n6 == 39;
                        n5 = this.getMinimum();
                        n3 = this.getMaximum();
                        n4 = this.getLowValue();
                        n2 = this.getHighValue();
                        if ((!bl3 || !bl) && (bl3 || !bl2)) break block4;
                        if (n4 - this.increment < n5 || n2 + this.increment > n3) break block5;
                        this.c(this.increment);
                        if (!bl6) break block5;
                    }
                    if ((!bl3 || !bl4) && (bl3 || !bl5)) break block6;
                    if (n2 - n4 < 2 * this.increment) break block5;
                    this.c(-1 * this.increment);
                    if (!bl6) break block5;
                }
                if ((!bl3 || !bl5) && (bl3 || !bl4)) break block7;
                if (n4 - this.increment < n5) break block5;
                this.b(-this.increment);
                if (!bl6) break block5;
            }
            if ((bl3 && bl2 || !bl3 && bl) && n2 + this.increment <= n3) {
                this.b(this.increment);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    protected class RangeSliderChangeListener
    implements ChangeListener {
        protected RangeSliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JRangeSlider.this.fireChangeEvent();
        }
    }
}

