/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual;

import java.util.HashSet;
import java.util.Iterator;
import prefuse.Visualization;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.util.Index;
import prefuse.util.collections.IntIterator;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;
import prefuse.visual.tuple.TableAggregateItem;

public class AggregateTable
extends VisualTable {
    protected Table m_aggregated = AGGREGATED_SCHEMA.instantiate();
    protected static final String AGGREGATE;
    protected static final String MEMBER_HASH;
    protected static final String MEMBER;
    protected static final Schema AGGREGATED_SCHEMA;
    private static final String z;

    public AggregateTable(Visualization visualization, String string) {
        this(visualization, string, VisualItem.SCHEMA);
    }

    public AggregateTable(Visualization visualization, String string, Schema schema) {
        super(visualization, string, schema, TableAggregateItem.class);
        this.m_aggregated.index(AGGREGATE);
        this.m_aggregated.index(MEMBER_HASH);
    }

    public int getAggregateSize(int n2) {
        boolean bl = VisualTable.h;
        int n3 = 0;
        AggregatedIterator aggregatedIterator = new AggregatedIterator(this, n2);
        while (aggregatedIterator.hasNext()) {
            ++n3;
            aggregatedIterator.next();
            if (!bl) continue;
        }
        return n3;
    }

    public void addToAggregate(int n2, VisualItem visualItem) {
        this.validRowCheck(n2, true);
        if (!this.aggregateContains(n2, visualItem)) {
            int n3 = this.m_aggregated.addRow();
            this.m_aggregated.setInt(n3, AGGREGATE, n2);
            this.m_aggregated.setInt(n3, MEMBER_HASH, this.getHashCode(visualItem));
            this.m_aggregated.set(n3, MEMBER, (Object)visualItem);
            this.fireTableEvent(n2, n2, -1, 0);
        }
    }

    public void removeFromAggregate(int n2, VisualItem visualItem) {
        this.validRowCheck(n2, true);
        int n3 = this.getAggregatedRow(n2, visualItem);
        if (n3 >= 0) {
            this.m_aggregated.removeRow(n3);
            this.fireTableEvent(n2, n2, -1, 0);
        }
    }

    public void removeAllFromAggregate(int n2) {
        this.clearAggregateMappings(n2, true);
    }

    protected void clearAggregateMappings(int n2, boolean bl) {
        boolean bl2 = VisualTable.h;
        Index index = this.m_aggregated.index(AGGREGATE);
        boolean bl3 = false;
        IntIterator intIterator = index.rows(n2);
        while (intIterator.hasNext()) {
            int n3 = intIterator.nextInt();
            intIterator.remove();
            this.m_aggregated.removeRow(n3);
            bl3 = true;
            if (!bl2) continue;
        }
        if (bl && bl3) {
            this.fireTableEvent(n2, n2, -1, 0);
        }
    }

    public boolean aggregateContains(int n2, VisualItem visualItem) {
        return this.getAggregatedRow(n2, visualItem) >= 0;
    }

    protected int getAggregatedRow(int n2, VisualItem visualItem) {
        int n3;
        Index index = this.m_aggregated.index(MEMBER_HASH);
        int n4 = index.get(n3 = this.getHashCode(visualItem));
        if (n4 < 0) {
            return -1;
        }
        if (this.m_aggregated.getInt(n4, AGGREGATE) == n2) {
            return n4;
        }
        IntIterator intIterator = index.rows(n3);
        while (intIterator.hasNext()) {
            n4 = intIterator.nextInt();
            if (this.m_aggregated.getInt(n4, AGGREGATE) != n2) continue;
            return n4;
        }
        return -1;
    }

    public Iterator aggregatedTuples(int n2) {
        return new AggregatedIterator(this, n2);
    }

    public Iterator getAggregates(Tuple tuple) {
        boolean bl = VisualTable.h;
        int n2 = this.getHashCode(tuple);
        IntIterator intIterator = this.m_aggregated.getIndex(MEMBER_HASH).rows(n2);
        HashSet<Tuple> hashSet = new HashSet<Tuple>();
        while (intIterator.hasNext()) {
            int n3 = intIterator.nextInt();
            hashSet.add(this.getTuple(this.m_aggregated.getInt(n3, AGGREGATE)));
            if (!bl) continue;
        }
        return hashSet.iterator();
    }

    protected int getHashCode(Tuple tuple) {
        return tuple.hashCode();
    }

    protected boolean validRowCheck(int n2, boolean bl) {
        if (this.isValidRow(n2)) {
            return true;
        }
        if (bl) {
            throw new IllegalArgumentException(z + n2);
        }
        return false;
    }

    @Override
    protected void fireTableEvent(int n2, int n3, int n4, int n5) {
        boolean bl = VisualTable.h;
        if (n4 == -1 && n5 == -1) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                this.clearAggregateMappings(i2, false);
                if (!bl) continue;
            }
        }
        super.fireTableEvent(n2, n3, n4, n5);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String string2 = "\u00189S\u001a\t83\u0005\t\n&wS\u001a\t$2\u001f[";
        int n2 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block15;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 81;
                                break;
                            }
                            case 1: {
                                n8 = 87;
                                break;
                            }
                            case 2: {
                                n8 = 37;
                                break;
                            }
                            case 3: {
                                n8 = 123;
                                break;
                            }
                            default: {
                                n8 = 101;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    z = string.intern();
                    string2 = "<2H\u0019\u0000#";
                    n2 = 0;
                    continue block11;
                }
                case 0: {
                    MEMBER = string.intern();
                    string2 = "00B\t\u000066Q\u001e";
                    n2 = 1;
                    continue block11;
                }
                case 1: {
                    AGGREGATE = string.intern();
                    string2 = "96V\u0013";
                    n2 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        MEMBER_HASH = string.intern();
        AGGREGATED_SCHEMA = new Schema();
        AGGREGATED_SCHEMA.addColumn(AGGREGATE, Integer.TYPE);
        AGGREGATED_SCHEMA.addColumn(MEMBER_HASH, Integer.TYPE);
        AGGREGATED_SCHEMA.addColumn(MEMBER, Tuple.class);
    }

    protected class AggregatedIterator
    implements Iterator {
        private IntIterator a;
        private Tuple b;
        final /* synthetic */ AggregateTable this$0;
        private static final String[] z;

        public AggregatedIterator(AggregateTable aggregateTable, int n2) {
            boolean bl = VisualTable.h;
            this.this$0 = aggregateTable;
            this.b = null;
            Index index = aggregateTable.m_aggregated.index(z[1]);
            this.a = index.rows(n2);
            this.a();
            if (AbstractExpression.b) {
                VisualTable.h = !bl;
            }
        }

        @Override
        public boolean hasNext() {
            return this.b != null;
        }

        public Object next() {
            Tuple tuple = this.b;
            this.a();
            return tuple;
        }

        private void a() {
            boolean bl = VisualTable.h;
            while (this.a.hasNext()) {
                int n2 = this.a.nextInt();
                Tuple tuple = (Tuple)this.this$0.m_aggregated.get(n2, z[0]);
                if (tuple.isValid()) {
                    this.b = tuple;
                    return;
                }
                this.this$0.m_aggregated.removeRow(n2);
                if (!bl) continue;
            }
            this.b = null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "3\u001fW\u0004H,";
            int n3 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block13;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 94;
                                    break;
                                }
                                case 1: {
                                    n9 = 122;
                                    break;
                                }
                                case 2: {
                                    n9 = 58;
                                    break;
                                }
                                case 3: {
                                    n9 = 102;
                                    break;
                                }
                                default: {
                                    n9 = 45;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "?\u001d]\u0014H9\u001bN\u0003";
                        n3 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

