/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.packandgo.impl;

import com.thinkbuzan.gaia.editor.EditorComponentUtilities;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.entities.HyperLink;
import com.thinkbuzan.gaia.entities.HyperLinkType;
import com.thinkbuzan.gaia.export.packandgo.model.LinkedFile;
import com.thinkbuzan.gaia.filesaving.FileSaving;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorModel {
    private static final Logger LOGGER = Logger.getLogger(EditorModel.class);
    private final transient FileSaving fileSaving;
    private final transient Set<String> fileNames;
    private final transient Map<File, LinkedFile> filesToLinkedFiles;

    public EditorModel(FileSaving fileSavingIn) {
        if (fileSavingIn == null) {
            throw new IllegalArgumentException("fileSaving can't be null");
        }
        this.fileSaving = fileSavingIn;
        this.fileNames = new HashSet<String>();
        this.filesToLinkedFiles = new HashMap<File, LinkedFile>();
    }

    public final Document getDocument(IEditorComponent editorComponentIn) {
        return this.buildXML(editorComponentIn);
    }

    protected final Document buildXML(IEditorComponent editor) {
        org.w3c.dom.Document encodeModel = this.fileSaving.encodeModel(editor);
        DOMBuilder builder = new DOMBuilder();
        return builder.build(encodeModel);
    }

    public final Set<LinkedFile> getLinkedFiles(IEditorComponent editorComponent) throws JDOMException {
        Document doc = this.getDocument(editorComponent);
        DOMOutputter domOutputter = new DOMOutputter();
        org.w3c.dom.Document document = domOutputter.output(doc);
        Element rootElement = document.getDocumentElement();
        this.filesToLinkedFiles.clear();
        this.fileNames.clear();
        HashSet<LinkedFile> linkedFiles = new HashSet<LinkedFile>();
        List<Node> nodes = this.getNodesOfSpecificType(rootElement, "hyperlink");
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            LinkedFile lf = this.getLinkedFile(node, i, editorComponent);
            if (null == lf) continue;
            linkedFiles.add(lf);
        }
        return linkedFiles;
    }

    private List<Node> getNodesOfSpecificType(Element element, String nodeName) {
        ArrayList<Node> matchingChildNodes = new ArrayList<Node>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (1 == child.getNodeType() && nodeName.equals(child.getNodeName())) {
                matchingChildNodes.add(child);
            }
            if (1 != child.getNodeType() || !child.hasChildNodes()) continue;
            matchingChildNodes.addAll(this.getNodesOfSpecificType((Element)child, nodeName));
        }
        return matchingChildNodes;
    }

    private LinkedFile getLinkedFile(Node node, int index, IEditorComponent editorComponent) {
        HyperLink hyperlink = (HyperLink)new HyperLink().decode(node);
        if (HyperLinkType.FILE != hyperlink.getType()) {
            return null;
        }
        String link = hyperlink.getLink();
        File file = new File(link);
        file = EditorComponentUtilities.ensureFileIsAbsolute((IEditorComponent)editorComponent, (File)file);
        link = file.getAbsolutePath();
        if (this.filesToLinkedFiles.containsKey(file)) {
            LinkedFile linkedFile = this.filesToLinkedFiles.get(file);
            linkedFile.addNode(node);
            return null;
        }
        LinkedFile linkedFile = new LinkedFile(link, index);
        linkedFile.addNode(node);
        this.filesToLinkedFiles.put(file, linkedFile);
        if (this.fileNames.contains(linkedFile.getFileName())) {
            linkedFile.setFileName(this.renameConflictName(linkedFile.getFileName()));
        }
        this.fileNames.add(linkedFile.getFileName());
        return linkedFile;
    }

    private String renameConflictName(String conflictName) {
        String fName;
        int index = conflictName.lastIndexOf(46);
        String fileName = conflictName;
        String extensionName = "";
        if (index > 0) {
            fileName = conflictName.substring(0, index);
            extensionName = conflictName.substring(index);
        }
        index = fileName.lastIndexOf(95);
        String numberString = "";
        if (index > -1 && (numberString = fileName.substring(index + 1)).matches("[0-9]+")) {
            fileName = fileName.substring(0, index);
        }
        index = 1;
        while (true) {
            if (!this.fileNames.contains(fName = fileName + "_" + index + extensionName)) break;
            ++index;
        }
        fileName = fName;
        return fileName;
    }
}

