/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.packandgo.impl;

import com.buzanonline.chaos.fileaccessservice.FileAccessService;
import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.utilities.compression.ZIPFileEntry;
import com.thinkbuzan.chaos.utilities.compression.ZipUtils;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.FileType;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.IExporterListener;
import com.thinkbuzan.gaia.export.IFileType;
import com.thinkbuzan.gaia.export.packandgo.PackAndGoService;
import com.thinkbuzan.gaia.export.packandgo.exception.PackAndGoExporterException;
import com.thinkbuzan.gaia.export.packandgo.i18n.PackAndGoExporterI18n;
import com.thinkbuzan.gaia.export.packandgo.license.IBundleLicenser;
import com.thinkbuzan.gaia.export.packandgo.model.LinkedFile;
import com.thinkbuzan.gaia.export.packandgo.ui.AbstractPackAndGoOptionsPanel;
import com.thinkbuzan.gaia.export.packandgo.ui.mac.MacPackAndGoOptionsPanel;
import com.thinkbuzan.gaia.export.packandgo.ui.windows.WindowsPackAndGoOptionsPanel;
import com.thinkbuzan.gaia.export.unlicensed.TrialExporterPanel;
import com.thinkbuzan.gaia.export.unlicensed.UnlicensedExporterPanel;
import com.thinkbuzan.gaia.filesaving.FileSaving;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackAndGoExporter
implements IExporter {
    private static final Logger LOGGER = Logger.getLogger(PackAndGoExporter.class);
    private static final String ZIP_FILE_EXT = "zip";
    private static final String ZIP_DESC = "Pack and Go Compressed File (*.zip)";
    private static final Map<String, List<String>> DESC_EXT_MAP = new HashMap<String, List<String>>();
    private static final FileType FILE_TYPE;
    private static final String EXPORTER_ID = "com.thinkbuzan.gaia.export.packandgo";
    private static final String EXPORTER_NAME = "com.thinkbuzan.i18n.packandgoexporter.name";
    private static final String ZIP_LINKED_FOLDER = "packandgo";
    private transient AbstractPackAndGoOptionsPanel optionsPanel;
    private final transient PackAndGoService packAndGoService;
    private final transient FileSaving fileSaving;
    private final transient IBundleLicenser licenser;
    private final transient FileAccessService fileAccess;

    public PackAndGoExporter(PackAndGoService pagService, FileSaving fileSavingIn, IBundleLicenser licenserIn, FileAccessService fileAccessIn) {
        if (pagService == null) {
            throw new IllegalArgumentException("service can't be null");
        }
        if (fileSavingIn == null) {
            throw new IllegalArgumentException("fileSaving can't be null");
        }
        if (fileAccessIn == null) {
            throw new IllegalArgumentException("fileAccess can't be null");
        }
        this.packAndGoService = pagService;
        this.fileSaving = fileSavingIn;
        this.licenser = licenserIn;
        this.fileAccess = fileAccessIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void export(IEditorComponent editor, File file, IExporterListener listener) {
        this.validateExport(editor, file, listener);
        LinkedFile[] values = this.optionsPanel.getSelectedValues();
        String password = this.optionsPanel.getPassword();
        try {
            File imxFile = this.buildimxFile(editor);
            ArrayList<ZIPFileEntry> files = new ArrayList<ZIPFileEntry>();
            String mapFileCompressedName = "map.imx";
            files.add(new ZIPFileEntry(imxFile, "map.imx"));
            if (values.length == 0) {
                this.addDummyFolder(files);
            }
            for (LinkedFile value : values) {
                if (value.getLinkedFile().isFile()) {
                    String zipPath = "packandgo/" + value.getFileName();
                    files.add(new ZIPFileEntry(value.getLinkedFile(), zipPath));
                    continue;
                }
                this.addLinkedFolder(value, files);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Calling ZipUtils.zipFiles(filesToZip=%s, outputFile=%s, password==null=%s", files, file.getPath(), password == null));
            }
            ZipUtils.zipFiles(files, (String)file.getPath(), (String)password);
            if (!imxFile.delete()) {
                LOGGER.warn((Object)("Couldn't delete imx file: " + imxFile.getAbsolutePath()));
            }
        }
        catch (Exception ex) {
            listener.exportErrorOccurred(ex.getMessage());
        }
        finally {
            listener.exportProgress(1.0f);
        }
    }

    private void addDummyFolder(List<ZIPFileEntry> files) {
        File emptyFolder = this.fileAccess.getSharedFile(ZIP_LINKED_FOLDER);
        boolean dirExists = emptyFolder.exists() ? true : emptyFolder.mkdirs();
        if (dirExists) {
            files.add(new ZIPFileEntry(emptyFolder, "packandgo/"));
        } else {
            LOGGER.warn((Object)("Couldn't create dummy packandgo folder for export: " + emptyFolder.getAbsolutePath()));
        }
    }

    private void addLinkedFolder(LinkedFile linkedFolder, List<ZIPFileEntry> files) {
        if (linkedFolder.getLinkedFile().getParentFile() == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Root directories are not supported by Pack and Go (\"%s\")", linkedFolder.getLinkedFile()));
            }
            return;
        }
        String toStrip = linkedFolder.getLinkedFile().getAbsolutePath();
        String base = "packandgo/" + linkedFolder.getFileName();
        Stack<File> fileStack = new Stack<File>();
        fileStack.add(linkedFolder.getLinkedFile());
        while (!fileStack.isEmpty()) {
            File file = (File)fileStack.pop();
            if (file.isFile() || this.isEmptyDirectory(file)) {
                String zipFilePath = base + '/' + file.getAbsolutePath().replace(toStrip, "");
                zipFilePath = new File(zipFilePath).getPath();
                zipFilePath = zipFilePath.replace('\\', '/');
                if (file.isDirectory()) {
                    zipFilePath = zipFilePath + '/';
                }
                files.add(new ZIPFileEntry(file, zipFilePath));
            }
            if (!file.isDirectory()) continue;
            for (File childFile : file.listFiles()) {
                fileStack.add(childFile);
            }
        }
    }

    private boolean isEmptyDirectory(File file) {
        return file.isDirectory() && (file.listFiles() == null || file.listFiles().length == 0);
    }

    public final void export(IEditorComponent editorComponent, File outputFile, IExporterListener exporterListener, Object ... objects) {
        block13: {
            LOGGER.debug((Object)("export pack and go : outputFile = [" + outputFile + "] editorComponent = [" + editorComponent + "]"));
            this.getComponent();
            if (objects == null) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)"Did not expect objects to be null");
                }
                return;
            }
            if (objects.length != 3) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)String.format("Expected objects.length(%s) to be equal to 3", objects.length));
                }
                return;
            }
            if (!(objects[0] instanceof List)) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)String.format("Expected objects[0](%s) to be a List", objects[0]));
                }
                return;
            }
            try {
                List linkedFiles = (List)objects[0];
                ArrayList<LinkedFile> selectedLinkedFiles = new ArrayList<LinkedFile>();
                for (LinkedFile linkedFile : linkedFiles) {
                    if (!linkedFile.isSelected()) continue;
                    selectedLinkedFiles.add(linkedFile);
                }
                LinkedFile[] selectedLinkedFilesArray = selectedLinkedFiles.toArray(new LinkedFile[selectedLinkedFiles.size()]);
                this.optionsPanel.setSelectedFiles(selectedLinkedFilesArray);
            }
            catch (Exception exception) {
                if (!LOGGER.isErrorEnabled()) break block13;
                LOGGER.error((Object)"Caught Exception when processing LinkedFiles", (Throwable)exception);
            }
        }
        if (!(objects[1] instanceof Boolean)) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Expected objects[1](%s) to be a Boolean", objects[1]));
            }
            return;
        }
        if (!(objects[2] instanceof String)) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Expected objects[2](%s) to be a String", objects[2]));
            }
            return;
        }
        this.optionsPanel.setPassword((String)objects[2]);
        this.export(editorComponent, outputFile, exporterListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final JComponent getComponent() {
        switch (this.getLicenseState()) {
            case full: {
                try {
                    if (SystemInfo.isWindows() || SystemInfo.isLinux()) {
                        this.optionsPanel = new WindowsPackAndGoOptionsPanel(this.packAndGoService);
                        return this.optionsPanel;
                    } else {
                        if (!SystemInfo.isMacOSX()) throw new UnsupportedOperationException(String.format("Unsupported Operating System: %s", SystemInfo.getOS()));
                        this.optionsPanel = new MacPackAndGoOptionsPanel(this.packAndGoService);
                    }
                    return this.optionsPanel;
                }
                catch (JDOMException ex) {
                    throw new PackAndGoExporterException(ex);
                }
            }
            case trial: {
                return TrialExporterPanel.getInstance((I18n)PackAndGoExporterI18n.getI18n());
            }
        }
        return UnlicensedExporterPanel.getInstance((I18n)PackAndGoExporterI18n.getI18n());
    }

    public final Icon getIcon() {
        return null;
    }

    public final String getId() {
        return EXPORTER_ID;
    }

    public final String getName() {
        return PackAndGoExporterI18n.getLocalizedText(EXPORTER_NAME);
    }

    public final IFileType getOutputFileType() {
        return FILE_TYPE;
    }

    private File buildimxFile(IEditorComponent editor) throws IOException {
        boolean savedSuccessfull;
        File imxFile = File.createTempFile(ZIP_LINKED_FOLDER, ".imx");
        LinkedFile[] linkedFiles = this.optionsPanel.getSelectedValues();
        Node originalDoc = null;
        for (LinkedFile linkedFile : linkedFiles) {
            List<Node> nodes = linkedFile.getNodes();
            for (Node node : nodes) {
                NodeList childNodes = node.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node childNode = childNodes.item(i);
                    if (!"link".equals(childNode.getNodeName())) continue;
                    childNode.setTextContent("packandgo/" + linkedFile.getFileName());
                }
                originalDoc = node.getOwnerDocument();
            }
        }
        if (null == originalDoc) {
            try {
                Document doc = this.packAndGoService.getEditorModel().getDocument(editor);
                DOMOutputter domOutputter = new DOMOutputter();
                originalDoc = domOutputter.output(doc);
            }
            catch (JDOMException e) {
                throw new PackAndGoExporterException("could not save the imx file");
            }
        }
        if (!(savedSuccessfull = this.fileSaving.saveTemporaryFile(editor, imxFile, originalDoc.getFirstChild()))) {
            throw new IOException("could not save the imx file");
        }
        return imxFile;
    }

    private void validateExport(IEditorComponent editor, File file, IExporterListener listener) {
        if (editor == null) {
            throw new IllegalArgumentException("editor can't be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file can't be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener can't be null");
        }
    }

    public final Category.CategoryId getCategoryId() {
        return Category.CategoryId.PACK_AND_GO;
    }

    public final IExporter.LicenseState getLicenseState() {
        return this.licenser.getPackAndGoExporterState();
    }

    static {
        DESC_EXT_MAP.put(ZIP_DESC, Arrays.asList(ZIP_FILE_EXT));
        FILE_TYPE = new FileType(Arrays.asList(ZIP_DESC), DESC_EXT_MAP);
    }
}

