/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.packandgo.impl;

import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.export.packandgo.PackAndGoService;
import com.thinkbuzan.gaia.export.packandgo.exception.PackAndGoExporterException;
import com.thinkbuzan.gaia.export.packandgo.impl.EditorModel;
import com.thinkbuzan.gaia.export.packandgo.model.LinkedFile;
import com.thinkbuzan.gaia.filesaving.FileSaving;
import java.util.ArrayList;
import java.util.List;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackAndGoServiceImpl
implements PackAndGoService {
    private final transient EditorManager editorManager;
    private final transient EditorModel editorModel;

    public PackAndGoServiceImpl(EditorManager editorManagerIn, FileSaving fileSavingIn) {
        if (editorManagerIn == null) {
            throw new IllegalArgumentException("editor component can't be null");
        }
        if (fileSavingIn == null) {
            throw new IllegalArgumentException("fileSaving can't be null");
        }
        this.editorManager = editorManagerIn;
        this.editorModel = new EditorModel(fileSavingIn);
    }

    @Override
    public final List<LinkedFile> getAllFilesToExport() {
        ArrayList<LinkedFile> linkedFiles = new ArrayList<LinkedFile>();
        try {
            linkedFiles.addAll(this.editorModel.getLinkedFiles(this.editorManager.getCurrentEditorComponent()));
        }
        catch (JDOMException ex) {
            throw new PackAndGoExporterException(ex);
        }
        return linkedFiles;
    }

    @Override
    public final EditorModel getEditorModel() {
        return this.editorModel;
    }
}

