/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.packandgo.license;

import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.packandgo.license.IBundleLicenser;
import com.thinkbuzan.phoenix.licensing.LicenseState;
import com.thinkbuzan.phoenix.licensing.PluginLicense;
import com.thinkbuzan.phoenix.licensing.PluginLicenseService;
import org.osgi.framework.BundleContext;

public class BundleLicenser
implements IBundleLicenser {
    private static final String PACK_AND_GO_EXPORTER_LICENSE_ID = "com.thinkbuzan.license.gaia.export.packandgo";
    private static final String TRIAL_LICENSE_ID = "com.thinkbuzan.license.gaia.imm5trial";
    private final transient PluginLicenseService pluginLicenseService;

    public BundleLicenser(BundleContext context) {
        this.pluginLicenseService = (PluginLicenseService)new OSGiService(context, PluginLicenseService.class).get();
    }

    public final IExporter.LicenseState getPackAndGoExporterState() {
        if (this.pluginLicenseService != null) {
            if (this.isLicenseActive(this.pluginLicenseService.getPluginLicense(PACK_AND_GO_EXPORTER_LICENSE_ID))) {
                return IExporter.LicenseState.full;
            }
            if (this.isLicenseActive(this.pluginLicenseService.getPluginLicense(TRIAL_LICENSE_ID))) {
                return IExporter.LicenseState.trial;
            }
        }
        return IExporter.LicenseState.unlicensed;
    }

    private boolean isLicenseActive(PluginLicense pluginLicense) {
        return pluginLicense != null && LicenseState.valid.equals((Object)pluginLicense.getState());
    }
}

