/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.packandgo.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkedFile {
    private static final String INVALID_FILE_INDICATOR = " * ";
    private final transient int id;
    private final transient String linkedFilePath;
    private final transient File filePath;
    private transient String fileName;
    private transient boolean selected;
    private final transient boolean validFile;
    private final transient List<Element> elements;
    private final transient List<Node> nodes;

    public LinkedFile(String linkedFilePathIn, int idIn) {
        this.validateEmptyString(linkedFilePathIn, "linkedFilePathIn can't be null or empty string");
        this.id = idIn;
        this.linkedFilePath = linkedFilePathIn;
        this.filePath = new File(this.linkedFilePath);
        this.validFile = this.filePath.exists() && this.filePath.getParentFile() != null;
        this.fileName = this.filePath.getName();
        this.elements = new ArrayList<Element>();
        this.nodes = new ArrayList<Node>();
    }

    public boolean isValid() {
        return this.validFile;
    }

    public void setFileName(String fileNameIn) {
        this.validateEmptyString(fileNameIn, "filename can't be null or empty string");
        this.fileName = fileNameIn;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getLinkedFilePath() {
        return this.linkedFilePath;
    }

    public File getLinkedFile() {
        return this.filePath;
    }

    public void addElement(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("element can't be null");
        }
        this.elements.add(element);
    }

    public void addNode(Node node) {
        if (null == node) {
            throw new IllegalArgumentException("LinkedFile node can't be null");
        }
        this.nodes.add(node);
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LinkedFile) {
            return this.filePath.equals(((LinkedFile)obj).getLinkedFile());
        }
        return false;
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }

    public String toString() {
        if (this.isValid()) {
            return this.getFileName();
        }
        return INVALID_FILE_INDICATOR + this.getFileName();
    }

    private void validateEmptyString(String arg, String message) {
        if (arg == null || arg.equals("")) {
            throw new IllegalArgumentException(message);
        }
    }

    public void setSelected(boolean selectedIn) {
        this.selected = selectedIn;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int getId() {
        return this.id;
    }
}

