/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.packandgo.osgi;

import com.buzanonline.chaos.fileaccessservice.FileAccessService;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.export.ExportManager;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.packandgo.PackAndGoService;
import com.thinkbuzan.gaia.export.packandgo.i18n.PackAndGoExporterI18n;
import com.thinkbuzan.gaia.export.packandgo.impl.PackAndGoExporter;
import com.thinkbuzan.gaia.export.packandgo.impl.PackAndGoServiceImpl;
import com.thinkbuzan.gaia.export.packandgo.license.BundleLicenser;
import com.thinkbuzan.gaia.filesaving.FileSaving;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class OSGiManager
implements BundleActivator {
    public void start(BundleContext context) {
        long start = System.currentTimeMillis();
        OSGiService i18nService = new OSGiService(context, I18n.class);
        PackAndGoExporterI18n.setI18n((I18n)i18nService.get());
        OSGiService exportManagerService = new OSGiService(context, ExportManager.class);
        OSGiService editorManagerService = new OSGiService(context, EditorManager.class);
        OSGiService fileSavingService = new OSGiService(context, FileSaving.class);
        OSGiService fileAccess = new OSGiService(context, FileAccessService.class);
        PackAndGoServiceImpl pagService = new PackAndGoServiceImpl((EditorManager)editorManagerService.get(), (FileSaving)fileSavingService.get());
        context.registerService(PackAndGoService.class.getName(), (Object)pagService, null);
        BundleLicenser licenser = new BundleLicenser(context);
        ((ExportManager)exportManagerService.get()).register((IExporter)new PackAndGoExporter(pagService, (FileSaving)fileSavingService.get(), licenser, (FileAccessService)fileAccess.get()));
        i18nService.close();
        exportManagerService.close();
        editorManagerService.close();
        fileSavingService.close();
        fileAccess.close();
        long end = System.currentTimeMillis();
        Logger.getLogger(OSGiManager.class).debug((Object)String.format("[BUNDLESTARTTIME] duration=%s, start=%s, end=%s", end - start, start, end));
    }

    public void stop(BundleContext context) {
    }
}

