/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.packandgo.ui;

import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.apollo.ui.core.win.component.DialogButton;
import com.thinkbuzan.gaia.export.packandgo.PackAndGoService;
import com.thinkbuzan.gaia.export.packandgo.i18n.PackAndGoExporterI18n;
import com.thinkbuzan.gaia.export.packandgo.model.LinkedFile;
import com.thinkbuzan.gaia.export.packandgo.ui.AbstractPasswordDialog;
import com.thinkbuzan.gaia.export.packandgo.ui.MultilineLabel;
import com.thinkbuzan.gaia.export.packandgo.ui.OptionType;
import com.thinkbuzan.gaia.export.packandgo.ui.YLayout;
import com.thinkbuzan.gaia.export.packandgo.ui.mac.MacPasswordDialog;
import com.thinkbuzan.gaia.export.packandgo.ui.windows.WindowsPasswordDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import org.jdom.JDOMException;

public abstract class AbstractPackAndGoOptionsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8411353186039438796L;
    private static final Insets PANEL_INSETS = new Insets(10, 20, 20, 20);
    private static final int PANEL_WIDTH = 600;
    private static final int TITLE_LABEL_FONT_SIZE = 4;
    private static final int ROW_GAP = 16;
    private static final int PWD_GAP = 10;
    private static final int PWD_LABEL_GAP = 6;
    private static final int LIST_VISIBLE_ROW_COUNT = 8;
    private transient JLabel titleLabel;
    private transient MultilineLabel descriptionLabel;
    private transient JLabel passwordLabel;
    private transient DialogButton passwordButton;
    private transient MultilineLabel brokenLinksLabel;
    private transient CheckBoxList linkedCheckBoxList;
    private transient String password;
    private transient boolean hasbroken;
    private final transient List<LinkedFile> linkedFiles = new ArrayList<LinkedFile>();
    private transient LinkedFile[] selectedFiles;

    public AbstractPackAndGoOptionsPanel(PackAndGoService packAndGoServiceIn) throws JDOMException {
        if (packAndGoServiceIn == null) {
            throw new IllegalArgumentException("pack and go service can't be null.");
        }
        this.setOpaque(false);
        this.password = null;
        this.linkedFiles.addAll(packAndGoServiceIn.getAllFilesToExport());
        this.initComponents();
    }

    public final LinkedFile[] getSelectedValues() {
        if (this.selectedFiles != null) {
            return this.selectedFiles;
        }
        Object[] values = this.getLinkedCheckBoxList().getCheckBoxListSelectedValues();
        LinkedFile[] selectedValues = new LinkedFile[values.length];
        for (int i = 0; i < values.length; ++i) {
            selectedValues[i] = (LinkedFile)values[i];
        }
        return selectedValues;
    }

    public final void setSelectedFiles(LinkedFile[] selectedValues) {
        this.selectedFiles = selectedValues;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String passwordIn) {
        this.password = passwordIn;
    }

    public final JLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = new JLabel(PackAndGoExporterI18n.getLocalizedText("com.thinkbuzan.i18n.packandgoexporter.title"));
            this.titleLabel.setName("titleLabel");
            Font oldFont = this.titleLabel.getFont();
            this.titleLabel.setFont(oldFont.deriveFont(1, oldFont.getSize2D() + 4.0f));
        }
        return this.titleLabel;
    }

    public final MultilineLabel getDescriptionLabel() {
        if (this.descriptionLabel == null) {
            this.descriptionLabel = new MultilineLabel(PackAndGoExporterI18n.getLocalizedText("com.thinkbuzan.i18n.packandgoexporter.description"));
            this.descriptionLabel.setName("descriptionLabel");
            this.descriptionLabel.setOpaque(false);
        }
        return this.descriptionLabel;
    }

    public final JLabel getPasswordLabel() {
        if (this.passwordLabel == null) {
            this.passwordLabel = new JLabel(PackAndGoExporterI18n.getLocalizedText("com.thinkbuzan.i18n.packandgoexporter.passwordprotect"));
            this.passwordLabel.setName("passwordLabel");
            this.passwordLabel.setHorizontalAlignment(4);
        }
        return this.passwordLabel;
    }

    public final DialogButton getPasswordButton() {
        if (this.passwordButton == null) {
            this.passwordButton = new DialogButton(PackAndGoExporterI18n.getLocalizedText("com.thinkbuzan.i18n.packandgoexporter.setpassword"), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AbstractPackAndGoOptionsPanel.this.showPasswordDialog();
                }
            }, DialogButton.DialogButtonColour.brightGrey);
            this.passwordButton.setName("passwordButton");
        }
        return this.passwordButton;
    }

    public final MultilineLabel getBrokenLinksLabel() {
        if (this.brokenLinksLabel == null) {
            this.brokenLinksLabel = new MultilineLabel(PackAndGoExporterI18n.getLocalizedText("com.thinkbuzan.i18n.packandgoexporter.brokenlinks"));
            this.brokenLinksLabel.setName("brokenLinksLabel");
            this.brokenLinksLabel.setOpaque(false);
        }
        return this.brokenLinksLabel;
    }

    public final CheckBoxList getLinkedCheckBoxList() {
        if (this.linkedCheckBoxList == null) {
            this.linkedCheckBoxList = new CheckBoxList(){
                private static final long serialVersionUID = 1L;

                public boolean isCheckBoxEnabled(int index) {
                    ListModel model = AbstractPackAndGoOptionsPanel.this.linkedCheckBoxList.getModel();
                    LinkedFile value = (LinkedFile)model.getElementAt(index);
                    return value.isValid();
                }
            };
            this.linkedCheckBoxList.setOpaque(false);
            this.linkedCheckBoxList.setName("linkedCheckBoxList");
            this.linkedCheckBoxList.setVisibleRowCount(8);
            DefaultListModel<LinkedFile> listModel = new DefaultListModel<LinkedFile>();
            this.linkedCheckBoxList.setModel(listModel);
            this.hasbroken = false;
            for (LinkedFile linkedFile : this.linkedFiles) {
                listModel.addElement(linkedFile);
                if (linkedFile.isValid()) {
                    this.linkedCheckBoxList.addCheckBoxListSelectedValue((Object)linkedFile, true);
                    continue;
                }
                this.hasbroken = true;
            }
        }
        return this.linkedCheckBoxList;
    }

    public final void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("password")) {
            this.showPasswordDialog();
        }
    }

    private void initComponents() {
        this.setBorder(new EmptyBorder(PANEL_INSETS));
        this.setLayout(new YLayout());
        this.add(this.getDescriptionLabel());
        this.add(Box.createVerticalStrut(16));
        JScrollPane listScroll = new JScrollPane((Component)this.getLinkedCheckBoxList());
        listScroll.setOpaque(false);
        listScroll.getViewport().setOpaque(false);
        listScroll.setVerticalScrollBarPolicy(22);
        this.add(listScroll);
        this.add(Box.createVerticalStrut(10));
        JPanel passwordPanel = new JPanel(new BorderLayout(6, 0));
        passwordPanel.setOpaque(false);
        passwordPanel.add((Component)this.getPasswordLabel(), "Center");
        passwordPanel.add((Component)this.getPasswordButton(), "East");
        this.add(passwordPanel);
        if (this.hasbroken) {
            this.add(Box.createVerticalStrut(16));
            this.add(this.getBrokenLinksLabel());
        }
        int width = 600 - this.getInsets().left - this.getInsets().right;
        this.getDescriptionLabel().setSize(width, this.getDescriptionLabel().getPreferredSize().height);
        this.getBrokenLinksLabel().setSize(width, this.getBrokenLinksLabel().getPreferredSize().height);
        this.setPreferredSize(new Dimension(600, this.getPreferredSize().height));
    }

    private void showPasswordDialog() {
        AbstractPasswordDialog passwordDialog = null;
        if (SystemInfo.isWindows() || SystemInfo.isLinux()) {
            passwordDialog = new WindowsPasswordDialog();
        } else if (SystemInfo.isMacOSX()) {
            passwordDialog = new MacPasswordDialog();
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported Operating System: %s", SystemInfo.getOS()));
        }
        passwordDialog.pack();
        passwordDialog.setLocationRelativeTo(null);
        passwordDialog.setVisible(true);
        if (passwordDialog.getOption() != null && passwordDialog.getOption().equals((Object)OptionType.OK)) {
            this.password = passwordDialog.getPassword();
        }
    }
}

