/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.packandgo.ui;

import com.thinkbuzan.gaia.export.packandgo.i18n.PackAndGoExporterI18n;
import com.thinkbuzan.gaia.export.packandgo.ui.OptionType;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;

public abstract class AbstractPasswordDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 5440706817889618368L;
    private transient JLabel titleLabel;
    private transient JLabel passwordLabel;
    private transient JPasswordField passwordField;
    private transient JButton okButton;
    private transient JButton cancelButton;
    private transient OptionType option;
    private final int PASSWORD_LABEL_WIDTH = 120;
    private final int PASSWORD_LABEL_HEIGHT = 30;

    public AbstractPasswordDialog() {
        super((Frame)null, true);
        this.initComponents();
    }

    public abstract JComponent getContentPanel();

    public final OptionType getOption() {
        return this.option;
    }

    public final String getPassword() {
        return String.valueOf(this.getPasswordField().getPassword());
    }

    public final JLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = new JLabel(PackAndGoExporterI18n.getLocalizedText("com.thinkbuzan.i18n.packandgoexporter.passwordmanager.requirespassword"));
            this.titleLabel.setName("titleLabel");
        }
        return this.titleLabel;
    }

    public final JLabel getPasswordLabel() {
        if (this.passwordLabel == null) {
            this.passwordLabel = new JLabel(PackAndGoExporterI18n.getLocalizedText("com.thinkbuzan.i18n.packandgoexporter.passwordmanager.providepassword"));
            this.passwordLabel.setName("passwordLabel");
        }
        return this.passwordLabel;
    }

    public final JPasswordField getPasswordField() {
        if (this.passwordField == null) {
            this.passwordField = new JPasswordField();
            this.passwordField.setPreferredSize(new Dimension(this.PASSWORD_LABEL_WIDTH, this.PASSWORD_LABEL_HEIGHT));
            this.passwordField.setName("passwordField");
        }
        return this.passwordField;
    }

    public final JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(PackAndGoExporterI18n.getLocalizedText("com.thinkbuzan.i18n.common.ok"));
            this.okButton.setName("okButton");
            this.okButton.setActionCommand("ok");
        }
        return this.okButton;
    }

    public final JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(PackAndGoExporterI18n.getLocalizedText("com.thinkbuzan.i18n.common.cancel"));
            this.cancelButton.setName("cancelButton");
            this.cancelButton.setActionCommand("cancel");
        }
        return this.cancelButton;
    }

    public final void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ok")) {
            this.option = OptionType.OK;
            this.dispose();
        } else if (e.getActionCommand().equals("cancel")) {
            this.option = OptionType.CANCEL;
            this.dispose();
        }
    }

    private void initComponents() {
        this.setTitle(PackAndGoExporterI18n.getLocalizedText("com.thinkbuzan.i18n.packandgoexporter.passwordmanager.title"));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                AbstractPasswordDialog.this.option = null;
                AbstractPasswordDialog.this.getPasswordField().requestFocus();
            }

            public void windowClosing(WindowEvent e) {
                AbstractPasswordDialog.this.option = OptionType.CLOSE;
            }
        });
        this.getOkButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        this.setContentPane(this.getContentPanel());
        this.getRootPane().setDefaultButton(this.getOkButton());
    }
}

