/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.packandgo.ui.windows;

import com.thinkbuzan.gaia.export.packandgo.ui.AbstractPasswordDialog;
import com.thinkbuzan.gaia.export.packandgo.ui.YLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public final class WindowsPasswordDialog
extends AbstractPasswordDialog {
    private static final long serialVersionUID = 694387884223549134L;
    private static final int CONTENT_PANEL_WIDTH = 330;
    private static final int PASSWORD_WIDTH = 250;
    private static final Color BOTTOM_PANEL_BACKGROUND = new Color(240, 240, 240);
    private static final Color TITLE_LABEL_FOREGROUND = new Color(81, 130, 202);
    private static final Border CENTER_PANEL_BORDER = new EmptyBorder(16, 20, 14, 20);
    private static final Border BUTTON_PANEL_BORDER = new EmptyBorder(10, 12, 8, 12);
    private static final int TITLE_LABEL_FONT_SIZE = 4;
    private static final Insets BUTTON_MARGIN = new Insets(2, 20, 2, 20);
    private static final int ROW_GAP = 14;
    private static final int LABEL_GAP = 6;
    private static final int BUTTON_GAP = 6;
    private transient JPanel contentPanel;

    public JComponent getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel(new BorderLayout());
            this.contentPanel.setOpaque(false);
            this.getTitleLabel().setForeground(TITLE_LABEL_FOREGROUND);
            Font font = this.getTitleLabel().getFont();
            this.getTitleLabel().setFont(font.deriveFont(1, font.getSize2D() + 4.0f));
            this.getOkButton().setMargin(BUTTON_MARGIN);
            this.getCancelButton().setMargin(BUTTON_MARGIN);
            JPanel mainPanel = this.makeMainPanel();
            this.contentPanel.add((Component)mainPanel, "Center");
            this.contentPanel.add((Component)this.makeButtonPanel(), "South");
            Dimension size = this.getTitleLabel().getPreferredSize();
            int width = Math.max(330, size.width);
            this.getTitleLabel().setPreferredSize(new Dimension(width, size.height));
            size = this.getPasswordField().getPreferredSize();
            this.getPasswordField().setPreferredSize(new Dimension(250, size.height));
        }
        return this.contentPanel;
    }

    private JPanel makeMainPanel() {
        JPanel centerPanel = new JPanel(new YLayout());
        centerPanel.setBackground(Color.white);
        centerPanel.setBorder(CENTER_PANEL_BORDER);
        centerPanel.add(this.getTitleLabel());
        centerPanel.add(Box.createVerticalStrut(14));
        centerPanel.add(this.getPasswordLabel());
        centerPanel.add(Box.createVerticalStrut(6));
        JPanel passwordPanel = new JPanel(new BorderLayout());
        passwordPanel.setOpaque(false);
        passwordPanel.add((Component)this.getPasswordField(), "West");
        centerPanel.add(passwordPanel);
        return centerPanel;
    }

    private JPanel makeButtonPanel() {
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBackground(BOTTOM_PANEL_BACKGROUND);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 0));
        buttonPanel.setBorder(BUTTON_PANEL_BORDER);
        buttonPanel.setOpaque(false);
        buttonPanel.add(this.getOkButton());
        buttonPanel.add(this.getCancelButton());
        bottomPanel.add((Component)new JSeparator(), "North");
        bottomPanel.add((Component)buttonPanel, "East");
        return bottomPanel;
    }
}

