/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AcceptPendingException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ShutdownChannelGroupException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.misc.Unsafe;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.AsynchronousServerSocketChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.Iocp;
import sun.nio.ch.Net;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.PendingIoCache;
import sun.nio.ch.WindowsAsynchronousSocketChannelImpl;

class WindowsAsynchronousServerSocketChannelImpl
extends AsynchronousServerSocketChannelImpl
implements Iocp.OverlappedChannel {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int DATA_BUFFER_SIZE = 88;
    private final long handle;
    private final int completionKey;
    private final Iocp iocp;
    private final PendingIoCache ioCache;
    private final long dataBuffer;
    private AtomicBoolean accepting = new AtomicBoolean();

    WindowsAsynchronousServerSocketChannelImpl(Iocp iocp) throws IOException {
        super(iocp);
        int n;
        long l = IOUtil.fdVal(this.fd);
        try {
            n = iocp.associate(this, l);
        }
        catch (IOException iOException) {
            WindowsAsynchronousServerSocketChannelImpl.closesocket0(l);
            throw iOException;
        }
        this.handle = l;
        this.completionKey = n;
        this.iocp = iocp;
        this.ioCache = new PendingIoCache();
        this.dataBuffer = unsafe.allocateMemory(88L);
    }

    @Override
    public <V, A> PendingFuture<V, A> getByOverlapped(long l) {
        return this.ioCache.remove(l);
    }

    @Override
    void implClose() throws IOException {
        WindowsAsynchronousServerSocketChannelImpl.closesocket0(this.handle);
        this.ioCache.close();
        this.iocp.disassociate(this.completionKey);
        unsafe.freeMemory(this.dataBuffer);
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.iocp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Future<AsynchronousSocketChannel> implAccept(Object object, CompletionHandler<AsynchronousSocketChannel, Object> completionHandler) {
        if (!this.isOpen()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            if (completionHandler == null) {
                return CompletedFuture.withFailure(closedChannelException);
            }
            Invoker.invokeIndirectly(this, completionHandler, object, null, closedChannelException);
            return null;
        }
        if (this.isAcceptKilled()) {
            throw new RuntimeException("Accept not allowed due to cancellation");
        }
        if (this.localAddress == null) {
            throw new NotYetBoundException();
        }
        WindowsAsynchronousSocketChannelImpl windowsAsynchronousSocketChannelImpl = null;
        IOException iOException = null;
        try {
            this.begin();
            windowsAsynchronousSocketChannelImpl = new WindowsAsynchronousSocketChannelImpl(this.iocp, false);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        finally {
            this.end();
        }
        if (iOException != null) {
            if (completionHandler == null) {
                return CompletedFuture.withFailure(iOException);
            }
            Invoker.invokeIndirectly(this, completionHandler, object, null, iOException);
            return null;
        }
        AccessControlContext accessControlContext = System.getSecurityManager() == null ? null : AccessController.getContext();
        PendingFuture<AsynchronousSocketChannel, Object> pendingFuture = new PendingFuture<AsynchronousSocketChannel, Object>(this, completionHandler, object);
        AcceptTask acceptTask = new AcceptTask(windowsAsynchronousSocketChannelImpl, accessControlContext, pendingFuture);
        pendingFuture.setContext(acceptTask);
        if (!this.accepting.compareAndSet(false, true)) {
            throw new AcceptPendingException();
        }
        if (Iocp.supportsThreadAgnosticIo()) {
            acceptTask.run();
        } else {
            Invoker.invokeOnThreadInThreadPool(this, acceptTask);
        }
        return pendingFuture;
    }

    private static native void initIDs();

    private static native int accept0(long var0, long var2, long var4, long var6) throws IOException;

    private static native void updateAcceptContext(long var0, long var2) throws IOException;

    private static native void closesocket0(long var0) throws IOException;

    static {
        IOUtil.load();
        WindowsAsynchronousServerSocketChannelImpl.initIDs();
    }

    private class AcceptTask
    implements Runnable,
    Iocp.ResultHandler {
        private final WindowsAsynchronousSocketChannelImpl channel;
        private final AccessControlContext acc;
        private final PendingFuture<AsynchronousSocketChannel, Object> result;

        AcceptTask(WindowsAsynchronousSocketChannelImpl windowsAsynchronousSocketChannelImpl, AccessControlContext accessControlContext, PendingFuture<AsynchronousSocketChannel, Object> pendingFuture) {
            this.channel = windowsAsynchronousSocketChannelImpl;
            this.acc = accessControlContext;
            this.result = pendingFuture;
        }

        void enableAccept() {
            WindowsAsynchronousServerSocketChannelImpl.this.accepting.set(false);
        }

        void closeChildChannel() {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void finishAccept() throws IOException {
            WindowsAsynchronousServerSocketChannelImpl.updateAcceptContext(WindowsAsynchronousServerSocketChannelImpl.this.handle, this.channel.handle());
            InetSocketAddress inetSocketAddress = Net.localAddress(this.channel.fd);
            final InetSocketAddress inetSocketAddress2 = Net.remoteAddress(this.channel.fd);
            this.channel.setConnected(inetSocketAddress, inetSocketAddress2);
            if (this.acc != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        SecurityManager securityManager = System.getSecurityManager();
                        securityManager.checkAccept(inetSocketAddress2.getAddress().getHostAddress(), inetSocketAddress2.getPort());
                        return null;
                    }
                }, this.acc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = 0L;
            try {
                WindowsAsynchronousServerSocketChannelImpl.this.begin();
                try {
                    this.channel.begin();
                    PendingFuture<AsynchronousSocketChannel, Object> pendingFuture = this.result;
                    synchronized (pendingFuture) {
                        block18: {
                            l = WindowsAsynchronousServerSocketChannelImpl.this.ioCache.add(this.result);
                            int n = WindowsAsynchronousServerSocketChannelImpl.accept0(WindowsAsynchronousServerSocketChannelImpl.this.handle, this.channel.handle(), l, WindowsAsynchronousServerSocketChannelImpl.this.dataBuffer);
                            if (n != -2) break block18;
                            return;
                        }
                        this.finishAccept();
                        this.enableAccept();
                        this.result.setResult(this.channel);
                    }
                }
                finally {
                    this.channel.end();
                }
            }
            catch (Throwable throwable) {
                IOException iOException;
                if (l != 0L) {
                    WindowsAsynchronousServerSocketChannelImpl.this.ioCache.remove(l);
                }
                this.closeChildChannel();
                if (throwable instanceof ClosedChannelException) {
                    iOException = new AsynchronousCloseException();
                }
                if (!(iOException instanceof IOException) && !(iOException instanceof SecurityException)) {
                    iOException = new IOException(iOException);
                }
                this.enableAccept();
                this.result.setFailure(iOException);
            }
            finally {
                WindowsAsynchronousServerSocketChannelImpl.this.end();
            }
            if (this.result.isCancelled()) {
                this.closeChildChannel();
            }
            Invoker.invokeIndirectly(this.result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(int n, boolean bl) {
            try {
                if (WindowsAsynchronousServerSocketChannelImpl.this.iocp.isShutdown()) {
                    throw new IOException(new ShutdownChannelGroupException());
                }
                try {
                    WindowsAsynchronousServerSocketChannelImpl.this.begin();
                    try {
                        this.channel.begin();
                        this.finishAccept();
                    }
                    finally {
                        this.channel.end();
                    }
                }
                finally {
                    WindowsAsynchronousServerSocketChannelImpl.this.end();
                }
                this.enableAccept();
                this.result.setResult(this.channel);
            }
            catch (Throwable throwable) {
                IOException iOException;
                this.enableAccept();
                this.closeChildChannel();
                if (throwable instanceof ClosedChannelException) {
                    iOException = new AsynchronousCloseException();
                }
                if (!(iOException instanceof IOException) && !(iOException instanceof SecurityException)) {
                    iOException = new IOException(iOException);
                }
                this.result.setFailure(iOException);
            }
            if (this.result.isCancelled()) {
                this.closeChildChannel();
            }
            Invoker.invokeIndirectly(this.result);
        }

        @Override
        public void failed(int n, IOException iOException) {
            this.enableAccept();
            this.closeChildChannel();
            if (WindowsAsynchronousServerSocketChannelImpl.this.isOpen()) {
                this.result.setFailure(iOException);
            } else {
                this.result.setFailure(new AsynchronousCloseException());
            }
            Invoker.invokeIndirectly(this.result);
        }
    }
}

