/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class KeyPadCanvas
extends Canvas {
    private int barNumber = 1;
    private boolean markerModeSet;
    private int mode = 0;
    private int topLine = 0;
    private int width = this.getWidth();
    private int height = this.getHeight();
    private int keyHeight;
    private int keyWidth;
    private Font smallFont;
    private int smallFontHeight;

    public KeyPadCanvas() {
        Font smallFont = Font.getFont((int)64, (int)0, (int)0);
        this.smallFontHeight = smallFont.getHeight();
    }

    protected void paint(Graphics g) {
        int i;
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(0);
        int yPos = this.topLine;
        int xPos = 0;
        for (i = 0; i < 4; ++i) {
            g.drawLine(0, yPos, this.width, yPos);
            yPos += (this.height - this.topLine) / 3;
            g.drawLine(xPos, this.topLine, xPos, this.height);
            xPos += this.width / 3;
        }
        g.setFont(this.smallFont);
        this.keyWidth = this.width / 3;
        this.keyHeight = (this.height - this.topLine) / 3;
        int onBkColour = 255;
        int onTextColour = 0xFFFFFF;
        int offBkColour = 0xFFFFFF;
        int offTextColour = 255;
        int unavailableColour = 0x808080;
        int availableColour = 255;
        if (this.mode == 0) {
            if (((ScoreDrawingCanvas)useful.theScore.sdc).shift) {
                g.setColor(onBkColour);
                g.fillRect(0, this.topLine, this.keyWidth, this.keyHeight);
                g.setColor(onTextColour);
                g.drawString("SHIFT", this.keyWidth / 2, this.topLine + (int)((double)this.keyHeight * 0.5), 0x10 | 1);
            } else {
                g.setColor(offTextColour);
                g.drawString("SHIFT", this.keyWidth / 2, this.topLine + (int)((double)this.keyHeight * 0.5), 0x10 | 1);
            }
            if (((ScoreDrawingCanvas)useful.theScore.sdc).singleSelect) {
                g.setColor(onBkColour);
                g.fillRect(this.keyWidth, this.topLine, this.keyWidth, this.keyHeight);
                g.setColor(onTextColour);
                g.drawString("SINGLE", this.keyWidth + this.keyWidth / 2, this.topLine + (int)((double)this.keyHeight * 0.5), 0x10 | 1);
            } else if (((ScoreDrawingCanvas)useful.theScore.sdc).multiSelect) {
                g.setColor(onBkColour);
                g.fillRect(this.keyWidth, this.topLine, this.keyWidth, this.keyHeight);
                g.setColor(onTextColour);
                g.drawString("MULTI", this.keyWidth + this.keyWidth / 2, this.topLine + (int)((double)this.keyHeight * 0.5), 0x10 | 1);
            } else {
                g.setColor(offTextColour);
                g.drawString("SELECT", this.keyWidth + this.keyWidth / 2, this.topLine + (int)((double)this.keyHeight * 0.5), 0x10 | 1);
            }
            g.setColor(availableColour);
            g.drawString("MARKERS", (int)((double)this.keyWidth * 2.5), this.topLine + (int)((double)this.keyHeight * 0.5), 0x10 | 1);
            if (((ScoreDrawingCanvas)useful.theScore.sdc).numSelectedNotes > 0) {
                g.setColor(availableColour);
            } else {
                g.setColor(unavailableColour);
            }
            g.drawString("CUT", (int)((double)this.keyWidth * 0.5), this.topLine + (int)((double)this.keyHeight * 1.5), 0x10 | 1);
            g.drawString("COPY", (int)((double)this.keyWidth * 1.5), this.topLine + (int)((double)this.keyHeight * 1.5), 0x10 | 1);
            if (useful.theScore.clipboard.isEmpty()) {
                g.setColor(unavailableColour);
            } else {
                g.setColor(availableColour);
            }
            g.drawString("PASTE", (int)((double)this.keyWidth * 2.5), this.topLine + (int)((double)this.keyHeight * 1.5), 0x10 | 1);
            g.setColor(availableColour);
            g.drawString("dt / du", (int)((double)this.keyWidth * 0.5), this.topLine + (int)((double)this.keyHeight * 2.5), 0x10 | 1);
        } else if (this.mode == 1) {
            g.drawString("MARKERS", this.width / 2, 0, 0x10 | 1);
            g.drawString("Bar " + String.valueOf(this.barNumber), 0, 15, 0x10 | 4);
            if (this.markerModeSet) {
                g.drawString("SET", this.width, this.smallFontHeight, 0x10 | 8);
            } else {
                g.drawString("GOTO", this.width, this.smallFontHeight, 0x10 | 8);
            }
            xPos = (int)((double)this.keyWidth * 0.5);
            yPos = this.topLine + (int)((double)this.keyHeight * 0.5);
            for (i = 0; i < 9; ++i) {
                g.drawString("BAR " + String.valueOf(useful.theScore.markers[i]), xPos, yPos, 0x10 | 1);
                if ((xPos += this.keyWidth) <= this.width) continue;
                xPos = (int)((double)this.keyWidth * 0.5);
                yPos += this.keyHeight;
            }
        } else if (this.mode == 2 || this.mode == 3 || this.mode == 4) {
            xPos = (int)((double)this.keyWidth * 0.5);
            yPos = this.topLine + (int)((double)this.keyHeight * 0.5);
            for (i = 0; i < 9; ++i) {
                g.drawString(useful.theScore.clipboard.slotToString(i), xPos, yPos, 0x10 | 1);
                if ((xPos += this.keyWidth) <= this.width) continue;
                xPos = (int)((double)this.keyWidth * 0.5);
                yPos += this.keyHeight;
            }
            if (this.mode == 2) {
                g.drawString("CUT", this.width / 2, 0, 0x10 | 1);
            } else if (this.mode == 3) {
                g.drawString("COPY", this.width / 2, 0, 0x10 | 1);
            } else if (this.mode == 4) {
                g.drawString("PASTE", this.width / 2, 0, 0x10 | 1);
            }
        }
    }

    public void drawStandard(int bar) {
        this.mode = 0;
        this.topLine = 30;
        useful.theScore.showDisplayable((Displayable)this);
        this.barNumber = bar;
        this.repaint();
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == useful.theScore.optionsCanvas.keyCodes[9]) {
            useful.theScore.showDisplayable(useful.theScore.sdc);
        } else if (keyCode != useful.theScore.optionsCanvas.keyCodes[10]) {
            if (keyCode == useful.theScore.optionsCanvas.keyCodes[11]) {
                if (this.mode == 1) {
                    this.markerModeSet = !this.markerModeSet;
                }
            } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[0]) {
                if (this.mode == 0) {
                    ((ScoreDrawingCanvas)useful.theScore.sdc).shift = !((ScoreDrawingCanvas)useful.theScore.sdc).shift;
                } else if (this.mode == 1) {
                    if (this.markerModeSet) {
                        useful.theScore.markers[0] = this.barNumber;
                    } else {
                        ((ScoreDrawingCanvas)useful.theScore.sdc).gotoMarker(0);
                    }
                } else if (this.mode == 3) {
                    useful.theScore.clipboard.copy(0);
                } else if (this.mode == 4) {
                    useful.theScore.clipboard.paste(0);
                }
            } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[1]) {
                if (this.mode == 0) {
                    if (!((ScoreDrawingCanvas)useful.theScore.sdc).singleSelect && !((ScoreDrawingCanvas)useful.theScore.sdc).multiSelect) {
                        ((ScoreDrawingCanvas)useful.theScore.sdc).singleSelect = true;
                    } else if (((ScoreDrawingCanvas)useful.theScore.sdc).singleSelect && !((ScoreDrawingCanvas)useful.theScore.sdc).multiSelect) {
                        ((ScoreDrawingCanvas)useful.theScore.sdc).singleSelect = false;
                        ((ScoreDrawingCanvas)useful.theScore.sdc).multiSelect = true;
                    } else if (!((ScoreDrawingCanvas)useful.theScore.sdc).singleSelect && ((ScoreDrawingCanvas)useful.theScore.sdc).multiSelect) {
                        ((ScoreDrawingCanvas)useful.theScore.sdc).multiSelect = false;
                    }
                } else if (this.mode == 1) {
                    if (this.markerModeSet) {
                        useful.theScore.markers[1] = this.barNumber;
                    } else {
                        ((ScoreDrawingCanvas)useful.theScore.sdc).gotoMarker(1);
                    }
                } else if (this.mode == 3) {
                    useful.theScore.clipboard.copy(1);
                } else if (this.mode == 4) {
                    useful.theScore.clipboard.paste(1);
                }
            } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[2]) {
                if (this.mode == 0) {
                    this.mode = 1;
                } else if (this.mode == 1) {
                    if (this.markerModeSet) {
                        useful.theScore.markers[2] = this.barNumber;
                    } else {
                        ((ScoreDrawingCanvas)useful.theScore.sdc).gotoMarker(2);
                    }
                } else if (this.mode == 3) {
                    useful.theScore.clipboard.copy(2);
                } else if (this.mode == 4) {
                    useful.theScore.clipboard.paste(2);
                }
            } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[3]) {
                if (this.mode == 0) {
                    if (((ScoreDrawingCanvas)useful.theScore.sdc).numSelectedNotes > 0) {
                        this.mode = 2;
                    }
                } else if (this.mode == 1) {
                    if (this.markerModeSet) {
                        useful.theScore.markers[3] = this.barNumber;
                    } else {
                        ((ScoreDrawingCanvas)useful.theScore.sdc).gotoMarker(3);
                    }
                } else if (this.mode == 3) {
                    useful.theScore.clipboard.copy(3);
                } else if (this.mode == 4) {
                    useful.theScore.clipboard.paste(3);
                }
            } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[4]) {
                if (this.mode == 0) {
                    if (((ScoreDrawingCanvas)useful.theScore.sdc).numSelectedNotes > 0) {
                        this.mode = 3;
                    }
                } else if (this.mode == 1) {
                    if (this.markerModeSet) {
                        useful.theScore.markers[4] = this.barNumber;
                    } else {
                        ((ScoreDrawingCanvas)useful.theScore.sdc).gotoMarker(4);
                    }
                } else if (this.mode == 4) {
                    useful.theScore.clipboard.copy(4);
                } else if (this.mode == 4) {
                    useful.theScore.clipboard.paste(4);
                }
            } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[5]) {
                if (this.mode == 0) {
                    if (!useful.theScore.clipboard.isEmpty()) {
                        this.mode = 4;
                    }
                } else if (this.mode == 1) {
                    if (this.markerModeSet) {
                        useful.theScore.markers[5] = this.barNumber;
                    } else {
                        ((ScoreDrawingCanvas)useful.theScore.sdc).gotoMarker(5);
                    }
                } else if (this.mode == 3) {
                    useful.theScore.clipboard.copy(5);
                } else if (this.mode == 4) {
                    useful.theScore.clipboard.paste(5);
                }
            } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[5]) {
                if (this.mode == 1) {
                    if (this.markerModeSet) {
                        useful.theScore.markers[6] = this.barNumber;
                    } else {
                        ((ScoreDrawingCanvas)useful.theScore.sdc).gotoMarker(6);
                    }
                } else if (this.mode == 3) {
                    useful.theScore.clipboard.copy(6);
                } else if (this.mode == 4) {
                    useful.theScore.clipboard.paste(6);
                }
            } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[7]) {
                if (this.mode == 1) {
                    if (this.markerModeSet) {
                        useful.theScore.markers[7] = this.barNumber;
                    } else {
                        ((ScoreDrawingCanvas)useful.theScore.sdc).gotoMarker(7);
                    }
                } else if (this.mode == 3) {
                    useful.theScore.clipboard.copy(7);
                } else if (this.mode == 4) {
                    useful.theScore.clipboard.paste(7);
                }
            } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[8]) {
                if (this.mode == 1) {
                    if (this.markerModeSet) {
                        useful.theScore.markers[8] = this.barNumber;
                    } else {
                        ((ScoreDrawingCanvas)useful.theScore.sdc).gotoMarker(8);
                    }
                } else if (this.mode == 3) {
                    useful.theScore.clipboard.copy(8);
                } else if (this.mode == 4) {
                    useful.theScore.clipboard.paste(8);
                }
            }
        }
        this.repaint();
    }
}

