/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class MidiHandler {
    public RecordStore rs;
    public byte[] midiData;
    public int pointer;
    public Vector playingNotes;
    private InputStream is;
    private Score theScore;
    public Player player;
    public int rsIDPlayed;
    public long totalTime;
    public Alert pleaseWait;
    private int ignoredDt = 0;
    private int quantisedDtTotal;
    private int unquantisedDtTotal;

    public MidiHandler(Score sc) {
        this.theScore = sc;
        this.rsIDPlayed = -1;
        this.pleaseWait = new Alert("Please wait...", "", null, AlertType.INFO);
        this.pleaseWait.setTimeout(-2);
        try {
            this.rs = RecordStore.openRecordStore((String)"Score", (boolean)true);
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        this.playingNotes = new Vector();
    }

    public int getRemainingRSSize() {
        int rsSize = -1;
        try {
            rsSize = this.rs.getSizeAvailable();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        return rsSize;
    }

    private String readString(int length) {
        String toReturn = "";
        for (int i = 0; i < length; ++i) {
            toReturn = toReturn + (char)this.midiData[this.pointer];
            ++this.pointer;
        }
        return toReturn;
    }

    private void fixLongNotes() {
        try {
            Vector<Note> tiedNotes = new Vector<Note>();
            int trebleBassPitch = 0;
            for (int trackNum = 0; trackNum < this.theScore.tracks.size(); ++trackNum) {
                this.pleaseWait.setString("Parsing rhythm - track " + (trackNum + 1) + " of " + this.theScore.tracks.size() + "...");
                Track theTrack = this.theScore.getTrack(trackNum);
                this.theScore.tempoTrack.setDeltaTime(0);
                int ticksPerBar = this.theScore.tempoTrack.getCurrentTimeSig().getTicksPerBar(this.theScore.getTicksPerCrotchet());
                int ticksPerBeat = this.theScore.tempoTrack.getCurrentTimeSig().getTicksPerBeat(this.theScore.getTicksPerCrotchet());
                int currentBarTicks = 0;
                int currentBeatTicks = 0;
                tiedNotes.removeAllElements();
                int trackDT = 0;
                for (int i = 0; i < theTrack.getSize(); ++i) {
                    int tempDT;
                    Note tempNote;
                    Note currentNote = theTrack.getNote(i);
                    trebleBassPitch = currentNote.getPitch() >= 60 ? ++trebleBassPitch : --trebleBassPitch;
                    if (currentNote.getDuration() + currentBeatTicks > ticksPerBeat) {
                        Note newNote = new Note(currentNote.getPitch(), currentNote.getVelocity(), currentNote.getDeltaTime(), currentNote.getDuration());
                        if (currentNote.getPitch() > 0) {
                            currentNote.setTieForwards(true);
                            newNote.setTieBackwards(true);
                        }
                        tiedNotes.addElement(newNote);
                        ((Note)tiedNotes.elementAt(tiedNotes.size() - 1)).setDuration(currentNote.getDuration() - (ticksPerBeat - currentBeatTicks));
                        currentNote.setDuration(ticksPerBeat - currentBeatTicks);
                        int oldDT = currentNote.getDeltaTime();
                        if (currentNote.getDeltaTime() > currentNote.getDuration()) {
                            currentNote.setDeltaTime(currentNote.getDuration());
                            ((Note)tiedNotes.elementAt(tiedNotes.size() - 1)).setDeltaTime(oldDT - currentNote.getDeltaTime());
                        } else {
                            ((Note)tiedNotes.elementAt(tiedNotes.size() - 1)).setDeltaTime(0);
                        }
                    }
                    if (currentNote.getPitch() > 0) {
                        Queue noteQueue = this.theScore.makeNoteDisplayable(currentNote);
                        try {
                            tempNote = (Note)noteQueue.dequeue();
                            currentNote.setDuration(tempNote.getDuration());
                            currentNote.setDeltaTime(tempNote.getDeltaTime());
                            currentNote.setTieForwards(tempNote.getTieForwards());
                            tempDT = trackDT + currentNote.getDuration();
                            while (!noteQueue.isEmpty()) {
                                tempNote = (Note)noteQueue.dequeue();
                                if (tempNote.getPitch() > 0) {
                                    theTrack.insertNote(tempNote, tempDT);
                                } else {
                                    theTrack.getNotes().insertElementAt(new Note(tempNote), i + 1);
                                }
                                tempDT += tempNote.getDuration();
                            }
                        }
                        catch (Exception ex) {
                            System.out.println("doh... can't pop off stack...");
                        }
                    } else {
                        Stack noteStack = this.theScore.makeRestDisplayable(currentNote);
                        try {
                            tempNote = (Note)noteStack.pop();
                            currentNote.setDuration(tempNote.getDuration());
                            currentNote.setDeltaTime(tempNote.getDeltaTime());
                            currentNote.setTieForwards(tempNote.getTieForwards());
                            tempDT = trackDT + currentNote.getDuration();
                            while (noteStack.size() > 0) {
                                tempNote = (Note)noteStack.pop();
                                if (tempNote.getPitch() > 0) {
                                    theTrack.insertNote(tempNote, tempDT);
                                } else {
                                    theTrack.getNotes().insertElementAt(new Note(tempNote), i + 1);
                                }
                                tempDT += tempNote.getDuration();
                            }
                        }
                        catch (Exception ex) {
                            System.out.println("doh... can't pop off stack...");
                        }
                    }
                    int checkDT = currentNote.getDeltaTime();
                    int dtExcess = 0;
                    if (currentBeatTicks + checkDT > ticksPerBeat) {
                        trackDT += ticksPerBeat - currentBeatTicks;
                        dtExcess = checkDT - (ticksPerBeat - currentBeatTicks);
                        currentNote.setDeltaTime(checkDT - dtExcess);
                        currentBeatTicks = ticksPerBeat;
                    } else {
                        currentBeatTicks += currentNote.getDeltaTime();
                        trackDT += currentNote.getDeltaTime();
                    }
                    if (currentBeatTicks != ticksPerBeat) continue;
                    if ((currentBarTicks += ticksPerBeat) == ticksPerBar) {
                        currentBarTicks = 0;
                        this.theScore.tempoTrack.incrementDeltaTime(ticksPerBeat);
                        ticksPerBar = this.theScore.tempoTrack.getCurrentTimeSig().getTicksPerBar(this.theScore.getTicksPerCrotchet());
                        ticksPerBeat = this.theScore.tempoTrack.getCurrentTimeSig().getTicksPerBeat(this.theScore.getTicksPerCrotchet());
                    }
                    currentBeatTicks = 0;
                    int tt = 1;
                    boolean useDtExcess = false;
                    if (tiedNotes.size() > 1) {
                        useDtExcess = true;
                    }
                    for (int tiedNoteNum = 0; tiedNoteNum < tiedNotes.size(); ++tiedNoteNum) {
                        Note currentTiedNote = (Note)tiedNotes.elementAt(tiedNoteNum);
                        Note toInsert = new Note(currentTiedNote.getPitch(), currentTiedNote.getVelocity(), currentTiedNote.getDeltaTime(), currentTiedNote.getDuration());
                        if (toInsert.getPitch() != 0) {
                            toInsert.setTieBackwards(true);
                        }
                        if (toInsert.getDuration() > ticksPerBeat) {
                            currentTiedNote.setDuration(toInsert.getDuration() - ticksPerBeat);
                            currentTiedNote.setDeltaTime(currentTiedNote.getDeltaTime() - ticksPerBeat);
                            if (currentTiedNote.getDeltaTime() < 0) {
                                currentTiedNote.setDeltaTime(0);
                            }
                            toInsert.setDuration(ticksPerBeat);
                            if (toInsert.getPitch() != 0) {
                                toInsert.setTieForwards(true);
                            }
                        } else {
                            tiedNotes.removeElementAt(tiedNoteNum);
                            --tiedNoteNum;
                        }
                        if (tiedNoteNum == tiedNotes.size() - 1) {
                            useDtExcess = true;
                            if (true) {
                                // empty if block
                            }
                        }
                        theTrack.getNotes().insertElementAt(toInsert, i + tt);
                        ++tt;
                    }
                }
                while (tiedNotes.size() > 0) {
                    int tt = 1;
                    for (int tiedNoteNum = 0; tiedNoteNum < tiedNotes.size(); ++tiedNoteNum) {
                        Note currentTiedNote = (Note)tiedNotes.elementAt(tiedNoteNum);
                        Note toInsert = new Note(currentTiedNote.getPitch(), currentTiedNote.getVelocity(), currentTiedNote.getDeltaTime(), currentTiedNote.getDuration());
                        if (toInsert.getPitch() != 0) {
                            toInsert.setTieBackwards(true);
                        }
                        if (toInsert.getDuration() > ticksPerBar) {
                            currentTiedNote.setDuration(toInsert.getDuration() - ticksPerBar);
                            currentTiedNote.setDeltaTime(currentTiedNote.getDeltaTime() - ticksPerBar);
                            if (currentTiedNote.getDeltaTime() < 0) {
                                currentTiedNote.setDeltaTime(0);
                            }
                            toInsert.setDuration(ticksPerBar);
                            if (toInsert.getPitch() != 0) {
                                toInsert.setTieForwards(true);
                            }
                        } else {
                            tiedNotes.removeElementAt(tiedNoteNum);
                            --tiedNoteNum;
                        }
                        ++tt;
                    }
                    this.theScore.tempoTrack.incrementDeltaTime(ticksPerBar);
                    ticksPerBar = this.theScore.tempoTrack.getCurrentTimeSig().getTicksPerBar(this.theScore.getTicksPerCrotchet());
                    ticksPerBeat = this.theScore.tempoTrack.getCurrentTimeSig().getTicksPerBeat(this.theScore.getTicksPerCrotchet());
                }
                if (trebleBassPitch < 0) {
                    theTrack.setClef((byte)1);
                }
                trebleBassPitch = 0;
            }
        }
        catch (Exception ex) {
            System.out.println("doh an exception has happened in fixLongNotes()...");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private int quantise(int dt) {
        int toReturn = 0;
        int dsq = this.theScore.getTicksPerCrotchet() / 8;
        int hdsq = dsq / 2;
        toReturn = dt == 0 ? 0 : (dt < dsq ? (this.playingNotes.size() > 0 ? dsq : 0) : (dt % dsq == 0 ? dt : (dt % dsq >= hdsq ? dt + (dsq - dt % dsq) : dt - dt % dsq)));
        this.unquantisedDtTotal += dt;
        this.quantisedDtTotal += toReturn;
        while (this.quantisedDtTotal - this.unquantisedDtTotal >= dsq && toReturn > dsq) {
            toReturn -= dsq;
            this.quantisedDtTotal -= dsq;
        }
        while (this.quantisedDtTotal - this.unquantisedDtTotal <= 0 - dsq && toReturn > dsq) {
            toReturn += dsq;
            this.quantisedDtTotal += dsq;
        }
        return toReturn;
    }

    private int parseMidiData() {
        Track track;
        int trackCount;
        Date startTime = new Date();
        this.theScore.tempoTrack.clearMetaEvents();
        this.theScore.tracks.removeAllElements();
        this.theScore.setScoreName("untitled");
        this.pointer = 0;
        if (!this.readString(4).equals("MThd")) {
            return 2;
        }
        this.readInt(4);
        if (this.readInt(2) != 1) {
            return 3;
        }
        int numTracks = this.readInt(2);
        this.theScore.setTicksPerCrotchet(this.readInt(2));
        if (!this.readString(4).equals("MTrk")) {
            return 4;
        }
        int trackLength = this.readInt(4);
        this.pleaseWait.setString("Parsing tempo track...");
        this.ignoredDt = 0;
        int deltaTime = this.quantise(this.readVarLen());
        byte checkMeta = this.midiData[this.pointer++];
        while (checkMeta == -16) {
            int sysExLength = this.readVarLen();
            this.pointer += sysExLength;
            deltaTime = this.quantise(this.readVarLen());
            checkMeta = this.midiData[this.pointer++];
        }
        byte eventType = this.midiData[this.pointer++];
        byte[] vlbytes = this.getVariableLengthAsBytes();
        int eventLength = this.readVarLen();
        byte[] eventData = this.readBytes(eventLength);
        while (eventType != 47) {
            if (eventType == 3) {
                this.theScore.setScoreName(eventData);
            } else {
                this.theScore.tempoTrack.addMetaEventFromBytes(deltaTime, eventType, eventLength, eventData, vlbytes);
            }
            deltaTime = this.quantise(this.readVarLen());
            checkMeta = this.midiData[this.pointer++];
            while (checkMeta == -16) {
                int sysExLength = this.readVarLen();
                this.pointer += sysExLength;
                deltaTime = this.quantise(this.readVarLen());
                checkMeta = this.midiData[this.pointer++];
            }
            eventType = this.midiData[this.pointer++];
            vlbytes = this.getVariableLengthAsBytes();
            eventLength = this.readVarLen();
            eventData = this.readBytes(eventLength);
        }
        this.theScore.tempoTrack.checkMetaEventsLoaded();
        this.playingNotes.removeAllElements();
        int currentDeltaTime = 0;
        int deltaTimeSinceLastNoteOn = 0;
        byte pitch = 0;
        int trackDeltaTime = 0;
        for (trackCount = 0; trackCount < numTracks - 1; ++trackCount) {
            trackDeltaTime = 0;
            this.ignoredDt = 0;
            this.quantisedDtTotal = 0;
            this.unquantisedDtTotal = 0;
            this.pleaseWait.setString("Parsing track " + (trackCount + 1) + " of " + numTracks + "...");
            this.theScore.showDisplayable((Displayable)this.pleaseWait);
            currentDeltaTime = 0;
            deltaTimeSinceLastNoteOn = 0;
            track = new Track();
            track.setChannel((byte)0);
            track.setInstrument((byte)0);
            this.readString(4);
            trackLength = this.readInt(4);
            int endOfTrack = this.pointer + trackLength;
            while (this.pointer < endOfTrack) {
                int tempDuration;
                byte velocity;
                byte temp;
                deltaTime = this.quantise(this.readVarLen());
                currentDeltaTime += deltaTime;
                deltaTimeSinceLastNoteOn += deltaTime;
                if (this.playingNotes.size() == 0 && deltaTime != 0) {
                    if (track.getSize() != 0) {
                        int tempDuration2 = ((Note)track.getNotes().elementAt(track.getSize() - 1)).getDuration();
                        ((Note)track.getNotes().elementAt(track.getSize() - 1)).setDeltaTime(tempDuration2);
                    }
                    if (track.getSize() > 0) {
                        trackDeltaTime += track.getNote(track.getSize() - 1).getDeltaTime();
                    }
                    if (this.playingNotes.size() == 0 && track.getSize() > 0 && currentDeltaTime - deltaTime > trackDeltaTime) {
                        track.getNote(track.getSize() - 1).incrementDeltaTime(currentDeltaTime - deltaTime - trackDeltaTime);
                        trackDeltaTime = currentDeltaTime - deltaTime;
                    }
                    track.addNote(new Note(0, 127, deltaTime, deltaTime));
                    deltaTimeSinceLastNoteOn = 0;
                }
                if ((temp = this.midiData[this.pointer++]) == -1) {
                    eventType = -1;
                    byte controlEventType = this.midiData[this.pointer++];
                    eventLength = this.readVarLen();
                    if (controlEventType == 3) {
                        track.setTrackName(this.readString(eventLength));
                    } else {
                        this.pointer += eventLength;
                    }
                } else if ((temp & 0xFFFFFF80) == -128) {
                    eventType = temp;
                    track.setChannel((byte)(eventType & 0xF));
                    if ((eventType & 0xFFFFFFF0) == -128 || (eventType & 0xFFFFFFF0) == -112) {
                        pitch = this.midiData[this.pointer++];
                    }
                } else if ((eventType & 0xFFFFFFF0) == -128 || (eventType & 0xFFFFFFF0) == -112) {
                    pitch = temp;
                } else {
                    --this.pointer;
                }
                if ((eventType & 0xFFFFFFF0) == -112) {
                    if ((velocity = this.midiData[this.pointer++]) != 0) {
                        if (track.getSize() > 0) {
                            byte tempPitch = ((Note)track.getNotes().elementAt(track.getSize() - 1)).getPitch();
                            if (tempPitch != 0) {
                                ((Note)track.getNotes().elementAt(track.getSize() - 1)).setDeltaTime(deltaTimeSinceLastNoteOn);
                            }
                            trackDeltaTime += track.getNote(track.getSize() - 1).getDeltaTime();
                            deltaTimeSinceLastNoteOn = 0;
                        }
                        track.addNote(new Note(pitch, velocity, currentDeltaTime));
                        this.playingNotes.addElement(new Note(pitch, velocity, track.getSize() - 1));
                    } else {
                        Note removedNote = this.getNoteWithPitch(pitch);
                        tempDuration = ((Note)track.getNotes().elementAt(removedNote.getDuration())).getDuration();
                        ((Note)track.getNotes().elementAt(removedNote.getDuration())).setDuration(currentDeltaTime - tempDuration);
                        trackDeltaTime += track.getNote(track.getSize() - 1).getDeltaTime();
                    }
                }
                if ((eventType & 0xFFFFFFF0) == -128) {
                    velocity = this.midiData[this.pointer++];
                    Note removedNote = this.getNoteWithPitch(pitch);
                    if (removedNote != null) {
                        tempDuration = ((Note)track.getNotes().elementAt(removedNote.getDuration())).getDuration();
                        ((Note)track.getNotes().elementAt(removedNote.getDuration())).setDuration(currentDeltaTime - tempDuration);
                        trackDeltaTime += track.getNote(track.getSize() - 1).getDeltaTime();
                    }
                }
                if ((eventType & 0xFFFFFFF0) == -96) {
                    this.pointer += 2;
                }
                if ((eventType & 0xFFFFFFF0) == -80) {
                    this.pointer += 2;
                }
                if ((eventType & 0xFFFFFFF0) == -64) {
                    track.setInstrument(this.midiData[this.pointer++]);
                }
                if ((eventType & 0xFFFFFFF0) == -48) {
                    ++this.pointer;
                }
                if ((eventType & 0xFFFFFFF0) == -32) {
                    this.pointer += 2;
                }
                if (eventType != -16) continue;
                int sysExLength = this.readVarLen();
                this.pointer += sysExLength;
            }
            if (track.getNotes().size() > 0) {
                int tempDT = ((Note)track.getNotes().elementAt(track.getNotes().size() - 1)).getDuration();
                ((Note)track.getNotes().elementAt(track.getNotes().size() - 1)).setDeltaTime(tempDT);
            }
            if (track.getTrackName().equals("")) {
                track.setTrackName("Track " + (trackCount + 1));
            }
            track.addNote(new Note(0, 100, this.theScore.getTicksPerCrotchet() / 2, this.theScore.getTicksPerCrotchet() / 2));
            this.theScore.tracks.addElement(track);
        }
        this.fixLongNotes();
        this.midiData = new byte[1];
        this.pleaseWait.setString("Adding rests...");
        for (trackCount = 0; trackCount < this.theScore.tracks.size(); ++trackCount) {
            track = this.theScore.getTrack(trackCount);
            for (int i = 0; i < 100; ++i) {
                track.addNote(new Note(0, 70, this.theScore.getTicksPerCrotchet() / 2, this.theScore.getTicksPerCrotchet() / 2));
            }
        }
        this.totalTime = new Date().getTime() - startTime.getTime();
        return 0;
    }

    private byte[] readBytes(int length) {
        byte[] toReturn = new byte[length];
        if (length == 0) {
            return toReturn;
        }
        for (int i = 0; i < length; ++i) {
            toReturn[i] = this.midiData[this.pointer];
            ++this.pointer;
        }
        return toReturn;
    }

    private Note getNoteWithPitch(byte p) {
        int pos = 0;
        for (pos = 0; pos < this.playingNotes.size(); ++pos) {
            Note n = (Note)this.playingNotes.elementAt(pos);
            if (n.getPitch() != p) continue;
            this.playingNotes.removeElementAt(pos);
            return n;
        }
        return null;
    }

    public boolean deleteRecord(int recID) {
        try {
            this.rs.deleteRecord(recID);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public void loadMidiFromRS(int rec) {
        try {
            this.pleaseWait.setString("Reading data...");
            this.theScore.showDisplayable((Displayable)this.pleaseWait);
            this.midiData = new byte[this.rs.getRecordSize(rec)];
            this.midiData = this.rs.getRecord(rec);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.parseMidiData();
    }

    public int deleteFile(String path) {
        try {
            FileConnection filecon = (FileConnection)Connector.open((String)("file:///" + path));
            filecon.delete();
        }
        catch (SecurityException sec) {
            return -1;
        }
        catch (IOException ioe) {
            return -2;
        }
        catch (Exception ex) {
            return -3;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadMidiFromFile(String path) {
        Connection c = null;
        this.is = null;
        try {
            c = Connector.open((String)("file:///" + path), (int)3);
            FileConnection fc = (FileConnection)c;
            if (!fc.exists()) {
                int n = 1;
                return n;
            }
            this.is = fc.openInputStream();
            long fileLen = fc.fileSize();
            this.pleaseWait.setString("Reading data...");
            this.theScore.showDisplayable((Displayable)this.pleaseWait);
            this.midiData = new byte[(int)fileLen];
            int read = this.is.read(this.midiData, 0, (int)fileLen);
            this.pointer = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.is != null) {
                    this.is.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.parseMidiData();
    }

    public void tidyUp() {
        int i;
        this.stop();
        for (i = 0; i < this.theScore.tracks.size(); ++i) {
            this.theScore.getTrack(i).addNote(new Note(60, 127, this.theScore.getTicksPerCrotchet() / 8, this.theScore.getTicksPerCrotchet() / 8));
        }
        int dt = this.theScore.tempoTrack.getBarNumber();
        this.createMidiData();
        int rec = this.writeMidiToRS();
        this.loadMidiFromRS(rec);
        try {
            this.rs.deleteRecord(rec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (i = 0; i < this.theScore.tracks.size(); ++i) {
            this.theScore.getTrack(i).getNotes().removeElementAt(this.theScore.getTrack(i).getSize() - 1);
        }
        ((ScoreDrawingCanvas)this.theScore.sdc).gotoStart();
    }

    public void stop() {
        if (this.player != null) {
            this.player.deallocate();
            this.player.close();
            this.player = null;
        }
        if (this.rsIDPlayed >= 0) {
            try {
                this.rs.deleteRecord(this.rsIDPlayed);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.rsIDPlayed = -1;
        }
    }

    public boolean play() {
        if (this.player != null) {
            if (this.player.getState() == 400) {
                this.stop();
                return false;
            }
        }
        this.stop();
        this.createMidiData();
        this.rsIDPlayed = this.writeMidiToRS();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.rs.getRecord(this.rsIDPlayed));
            this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            this.player.start();
            VolumeControl vc = (VolumeControl)this.player.getControl("VolumeControl");
            if (vc != null) {
                vc.setLevel(this.theScore.optionsCanvas.playerVolume);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (MediaException me) {
            me.printStackTrace();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (InvalidRecordIDException ire) {
            ire.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public int writeMidiToRS() {
        int id = -1;
        try {
            this.pleaseWait.setString("Writing data...");
            id = this.rs.addRecord(this.midiData, 0, this.pointer);
        }
        catch (RecordStoreNotOpenException ex) {
            return -1;
        }
        catch (RecordStoreFullException ex) {
            return -2;
        }
        catch (RecordStoreException ex) {
            return -3;
        }
        return id;
    }

    public void createMidiData() {
        this.pleaseWait.setString("Preparing midi data...");
        this.theScore.showDisplayable((Displayable)this.pleaseWait);
        int size = 0;
        for (int i = 0; i < this.theScore.tracks.size(); ++i) {
            size += this.theScore.getTrack(i).getSize() * 10;
            size += this.theScore.getTrack(i).getTrackName().length();
            size += 50;
        }
        size += this.theScore.tempoTrack.metaEvents.size() * 10;
        this.midiData = new byte[size += 100];
        this.pointer = 0;
        this.insertString("MThd");
        this.insertPaddedInt(6, 4);
        this.insertInt(0);
        this.insertInt(1);
        this.insertPaddedInt(this.theScore.tracks.size() + 1, 2);
        this.insertPaddedInt(this.theScore.getTicksPerCrotchet(), 2);
        this.insertString("MTrk");
        int lengthPointer = this.pointer;
        this.pointer += 4;
        this.insertInt(0);
        this.insertTrackName(this.theScore.getScoreName());
        this.pleaseWait.setString("Creating tempo track...");
        TempoTrack tempoTrack = this.theScore.tempoTrack;
        for (int ce = 0; ce < tempoTrack.metaEvents.size(); ++ce) {
            byte[] eventBytes = tempoTrack.getEventAsBytes(ce);
            if (eventBytes == null) continue;
            this.insertVarLen(((MetaEvent)tempoTrack.metaEvents.elementAt(ce)).getDeltaTime());
            for (int j = 0; j < eventBytes.length; ++j) {
                this.midiData[this.pointer] = eventBytes[j];
                ++this.pointer;
            }
        }
        this.insertInt(0);
        this.insertEndOfTrack();
        int trackLen = this.pointer - lengthPointer - 4;
        int tempPointer = this.pointer;
        this.pointer = lengthPointer;
        this.insertPaddedInt(trackLen, 4);
        this.pointer = tempPointer;
        this.playingNotes.removeAllElements();
        for (int ct = 0; ct < this.theScore.tracks.size(); ++ct) {
            System.out.println("saving track " + ct);
            this.pleaseWait.setString("Creating track " + ct + " of " + this.theScore.tracks.size() + "...");
            this.insertString("MTrk");
            lengthPointer = this.pointer;
            this.pointer += 4;
            Track t = this.theScore.getTrack(ct);
            this.insertInt(0);
            this.insertTrackName(t.getTrackName());
            byte channel = t.getChannel();
            int cn = 0;
            int dt = 0;
            int currentSmallest = 0;
            Note toStop = new Note();
            this.insertByte((byte)0);
            this.insertByte((byte)(0xC0 | t.getChannel()));
            this.insertByte(t.getInstrument());
            Note n = t.getNote(cn);
            if (n.getPitch() > 0) {
                dt = 0;
            }
            for (cn = 0; cn < t.getSize(); ++cn) {
                n = t.getNote(cn);
                if (n.getPitch() != 0 && !n.getTieBackwards()) {
                    this.subtractDurationFromPlayingNotesNotTiedBack(dt);
                    this.insertVarLen(dt);
                    this.insertByte((byte)(0x90 | channel));
                    this.insertByte(n.getPitch());
                    this.insertByte(n.getVelocity());
                    dt = 0;
                } else if (n.getPitch() == 0) {
                    dt += n.getDeltaTime();
                } else if (n.getTieBackwards()) {
                    for (int pn = 0; pn < this.playingNotes.size(); ++pn) {
                        System.out.println("pn = " + (Note)this.playingNotes.elementAt(pn));
                    }
                }
                if (n.getPitch() != 0) {
                    Note playingNote = new Note(n);
                    this.playingNotes.addElement(playingNote);
                }
                int currentNoteDeltaTime = n.getDeltaTime();
                currentSmallest = this.getSmallestPlayingDuration();
                if (currentSmallest > currentNoteDeltaTime && n.getPitch() != 0 && !n.getTieBackwards()) {
                    dt += currentNoteDeltaTime;
                    this.subtractDurationFromPlayingNotes(currentNoteDeltaTime);
                } else if (currentSmallest > currentNoteDeltaTime && n.getPitch() != 0) {
                    this.subtractDurationFromPlayingNotes(currentNoteDeltaTime);
                }
                int dtRem = currentNoteDeltaTime;
                if (currentSmallest > currentNoteDeltaTime && !n.getTieBackwards()) {
                    dtRem = 0;
                }
                while (currentNoteDeltaTime >= currentSmallest) {
                    dtRem -= currentSmallest;
                    System.out.println("dt = " + dt);
                    toStop = this.getNoteWithDuration(this.getSmallestPlayingDuration());
                    if (!toStop.getTieForwards()) {
                        this.insertVarLen(currentSmallest + dt);
                        this.insertByte((byte)(0x80 | channel));
                        this.insertByte(toStop.getPitch());
                        this.insertByte(toStop.getVelocity());
                        dt = 0;
                    } else {
                        System.out.println("dt adding currentsmallest...");
                        dt += currentSmallest;
                    }
                    this.subtractDurationFromPlayingNotes(currentSmallest);
                    toStop = this.getNoteWithDuration(0);
                    while (toStop != null) {
                        if (!toStop.getTieForwards()) {
                            this.insertVarLen(dt);
                            this.insertByte((byte)(0x80 | channel));
                            this.insertByte(toStop.getPitch());
                            this.insertByte(toStop.getVelocity());
                            dt = 0;
                        }
                        toStop = this.getNoteWithDuration(0);
                    }
                    currentSmallest = this.getSmallestPlayingDuration();
                }
                if (dtRem <= 0) continue;
                dt += dtRem;
            }
            for (int stopNotes = 0; stopNotes < this.playingNotes.size(); ++stopNotes) {
                currentSmallest = this.getSmallestPlayingDuration();
                toStop = this.getNoteWithDuration(currentSmallest);
                this.insertVarLen(dt + currentSmallest);
                this.insertByte((byte)(0x80 | channel));
                this.insertByte(toStop.getPitch());
                this.insertByte(toStop.getVelocity());
                dt = 0;
            }
            this.insertVarLen(0);
            this.insertEndOfTrack();
            trackLen = this.pointer - lengthPointer - 4;
            tempPointer = this.pointer;
            this.pointer = lengthPointer;
            this.insertPaddedInt(trackLen, 4);
            this.pointer = tempPointer;
        }
    }

    private void insertByte(byte b) {
        this.midiData[this.pointer] = b;
        ++this.pointer;
    }

    private void insertPaddedInt(int val, int length) {
        for (int i = length - 1; i >= 0; --i) {
            this.insertInt(val >> i * 8 & 0xFF);
        }
    }

    private int getSmallestPlayingDuration() {
        int minRemainingDuration = 1000000;
        int smallestIndex = -1;
        for (int pos = 0; pos < this.playingNotes.size(); ++pos) {
            int currentDuration = ((Note)this.playingNotes.elementAt(pos)).getDuration();
            if (currentDuration >= minRemainingDuration) continue;
            minRemainingDuration = currentDuration;
            smallestIndex = pos;
        }
        return minRemainingDuration;
    }

    private Note getNoteWithDuration(int d) {
        int pos = 0;
        for (pos = 0; pos < this.playingNotes.size(); ++pos) {
            Note n = (Note)this.playingNotes.elementAt(pos);
            if (n.getDuration() != d) continue;
            this.playingNotes.removeElementAt(pos);
            return n;
        }
        return null;
    }

    private void subtractDurationFromPlayingNotes(int d) {
        for (int pos = 0; pos < this.playingNotes.size(); ++pos) {
            int duration = ((Note)this.playingNotes.elementAt(pos)).getDuration();
            ((Note)this.playingNotes.elementAt(pos)).setDuration(duration -= d);
        }
    }

    private void subtractDurationFromPlayingNotesNotTiedBack(int d) {
        for (int pos = 0; pos < this.playingNotes.size(); ++pos) {
            if (((Note)this.playingNotes.elementAt(pos)).getTieBackwards()) continue;
            int duration = ((Note)this.playingNotes.elementAt(pos)).getDuration();
            ((Note)this.playingNotes.elementAt(pos)).setDuration(duration -= d);
        }
    }

    private void insertString(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.midiData[this.pointer] = (byte)s.charAt(i);
            ++this.pointer;
        }
    }

    private int readVarLen() {
        int num = 0;
        do {
            byte read = (byte)(this.midiData[this.pointer] & 0x7F);
            ++this.pointer;
            num <<= 7;
            num |= read;
        } while ((this.midiData[this.pointer - 1] & 0x80) == 128);
        return num;
    }

    private void insertVarLen(int num) {
        int buffer = num & 0x7F;
        while ((num >>= 7) > 0) {
            buffer <<= 8;
            buffer |= 0x80;
            buffer += num & 0x7F;
        }
        while (true) {
            this.midiData[this.pointer] = (byte)buffer;
            ++this.pointer;
            if ((buffer & 0x80) != 128) break;
            buffer >>= 8;
        }
    }

    public void insertInt(int num) {
        this.midiData[this.pointer] = (byte)num;
        ++this.pointer;
    }

    private int readInt(int length) {
        int num = 0;
        for (int i = 1; i <= length; ++i) {
            num += useful.fix2sCompliment(this.midiData[this.pointer]) << (length - i) * 8;
            ++this.pointer;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeMidiToFile() {
        Connection c = null;
        OutputStream os = null;
        try {
            c = Connector.open((String)("file:///" + this.theScore.path + this.theScore.fileName + ".mid"), (int)3);
            FileConnection fc = (FileConnection)c;
            if (!fc.exists()) {
                fc.create();
            } else {
                fc.truncate(0L);
            }
            this.pleaseWait.setString("Writing data...");
            os = fc.openOutputStream();
            os.write(this.midiData, 0, this.pointer);
            os.flush();
            int n = 0;
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception ex) {
                return -2;
            }
        }
    }

    private void insertTrackName(String trackName) {
        this.insertInt(255);
        this.insertInt(3);
        this.insertVarLen(trackName.length());
        this.insertString(trackName);
    }

    private void insertEndOfTrack() {
        this.insertInt(255);
        this.insertInt(47);
        this.insertInt(0);
    }

    private byte[] getVariableLengthAsBytes() {
        int tempPointer = this.pointer;
        while ((this.midiData[++tempPointer] & 0x80) == 128) {
        }
        byte[] toReturn = new byte[tempPointer - this.pointer];
        for (int c = 0; c < tempPointer - this.pointer; ++c) {
            toReturn[c] = this.midiData[this.pointer + c];
        }
        return toReturn;
    }

    public int getFileList(List fileList) {
        try {
            if (this.theScore.path.equals("")) {
                Enumeration drives = FileSystemRegistry.listRoots();
                while (drives.hasMoreElements()) {
                    fileList.append((String)drives.nextElement(), null);
                }
            } else {
                FileConnection fc = (FileConnection)Connector.open((String)("file:///" + this.theScore.path));
                Enumeration files = fc.list("*", true);
                while (files.hasMoreElements()) {
                    fileList.append((String)files.nextElement(), null);
                }
                fc.close();
            }
        }
        catch (SecurityException sec) {
            return -1;
        }
        catch (IOException ioe) {
            return -2;
        }
        catch (Exception ex) {
            return -3;
        }
        return 0;
    }

    public int doesFileExist() {
        try {
            FileConnection filecon = (FileConnection)Connector.open((String)("file:///" + this.theScore.path + this.theScore.fileName + ".mid"));
            if (filecon.exists()) {
                return 1;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }

    public int getRecordList(List fileList) {
        try {
            RecordEnumeration re = this.rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                int recID = re.nextRecordId();
                String recName = Integer.toString(recID) + " -- " + this.rs.getRecordSize(recID);
                fileList.append(recName, null);
            }
        }
        catch (Exception ex) {
            return -1;
        }
        return 0;
    }
}

