/*
 * Decompiled with CFR 0.152.
 */
public class TimeSigEvent {
    private byte numerator;
    private byte denominator;
    private byte metronome;
    private byte demiSemiQuavers;

    public TimeSigEvent(byte n, byte d) {
        this.numerator = n;
        this.denominator = d;
        this.metronome = (byte)24;
        this.demiSemiQuavers = (byte)8;
    }

    public TimeSigEvent(byte[] data) {
        this.numerator = data[0];
        this.denominator = data[1];
        this.metronome = data[2];
        this.demiSemiQuavers = data[3];
    }

    public void setNumerator(byte n) {
        this.numerator = n;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setDenominator(int d) {
        int i = 1;
        for (int total = 2; total < d; total *= 2) {
            ++i;
        }
        this.denominator = (byte)i;
    }

    public int getDenominator() {
        int total = 2;
        for (int i = 1; i < this.denominator; ++i) {
            total *= 2;
        }
        return total;
    }

    public int getTicksPerBeat(int ticksPerCrotchet) {
        if (this.numerator == 4 && this.denominator == 2) {
            return 2 * ticksPerCrotchet;
        }
        if (this.denominator == 3) {
            return (int)((double)ticksPerCrotchet * 1.5);
        }
        if (this.denominator == 1) {
            return ticksPerCrotchet * 2;
        }
        return ticksPerCrotchet;
    }

    public int getTicksPerBar(int ticksPerCrotchet) {
        if (this.numerator == 4 && this.denominator == 2) {
            return 4 * ticksPerCrotchet;
        }
        if (this.denominator == 3) {
            int ticksPerBeat = this.getTicksPerBeat(ticksPerCrotchet);
            return this.numerator / 3 * ticksPerBeat;
        }
        return this.numerator * this.getTicksPerBeat(ticksPerCrotchet);
    }

    public byte[] returnBytes() {
        byte[] toReturn = new byte[]{-1, 88, 4, this.numerator, this.denominator, this.metronome, this.demiSemiQuavers};
        return toReturn;
    }

    public String toString() {
        return String.valueOf(this.getNumerator()) + "/" + String.valueOf(this.getDenominator());
    }
}

