/*
 * Decompiled with CFR 0.152.
 */
package bomber;

import bomber.Bomber;
import bomber.Enemies;
import bomber.HighScores;
import bomber.MenuScreen;
import bomber.Player;
import bomber.Playfield;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextField;

public class GameScreen
extends Canvas {
    public static final int MODE_PLAY = 0;
    public static final int MODE_PAUSE = 1;
    public static final int MODE_LEVELSTART = 2;
    public static final int MODE_LEVELEND = 3;
    public static final int MODE_DEAD = 4;
    public static final int MODE_GAMEOVER = 5;
    public static final int MODE_MENU = 6;
    private MenuScreen menuScreen = null;
    Player player = null;
    Playfield playfield = null;
    Enemies enemies = null;
    Image buffer = null;
    Graphics bufG = null;
    public int mode = 0;
    public int cnt = 0;
    private int drawWidth = 0;
    private int drawHeight = 0;
    public int level = 0;
    private int menuItemFocus = 0;
    private int menuItems = 0;
    private int menuImageY = 32;
    private int lastScore = 0;
    Timer frameUpdateTimer = null;
    static GameScreen instance = null;
    private HighScores hs = null;
    private Form instructionsForm = null;
    private Form highScoresForm = null;
    private Form nameForm = null;
    private TextField nameField = null;
    private Command newGameComm = null;
    private Command quitComm = null;
    private Command highScoresComm = null;
    private Command instructionsComm = null;
    private Command backComm = null;
    private Command okComm = null;

    public GameScreen(MenuScreen menuScreen) {
        this.menuScreen = menuScreen;
        try {
            this.drawWidth = Math.min(this.getWidth(), 162);
            this.drawHeight = Math.min(this.getHeight(), 162);
            instance = this;
            this.jbInit();
            this.newGame();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.player = new Player(instance);
        this.playfield = new Playfield(28, 28);
        this.enemies = new Enemies(25);
        this.player.playfield = this.playfield;
        this.playfield.player = this.player;
        this.playfield.setDrawDimensions(this.drawWidth, this.drawHeight);
        this.playfield.enemies = this.enemies;
        this.enemies.playfield = this.playfield;
        this.enemies.player = this.player;
        this.frameUpdateTimer = new Timer();
        this.frameUpdateTimer.schedule((TimerTask)new FrameUpdateTask(), 0L, 100L);
    }

    public void newGame() {
        this.player.reset();
        this.level = 0;
        this.nextLevel();
    }

    public void nextLevel() {
        ++this.level;
        this.playfield.reset();
        this.playfield.loadLevel(this.level);
        this.player.resetPos();
        this.mode = 2;
        this.removeCommand(this.newGameComm);
        this.removeCommand(this.instructionsComm);
        this.removeCommand(this.highScoresComm);
        this.cnt = 10;
    }

    public void levelClear() {
        this.mode = 3;
        this.cnt = 20;
    }

    public void showMenu() {
        this.menuScreen.showMenu();
    }

    public void showGameOver(int n) {
        this.lastScore = n;
        if (this.hs.isHighScore(n)) {
            Bomber.instance.setDisplayable((Displayable)this.nameForm);
        } else {
            this.showMenu();
        }
    }

    public void keyPressed(int n) {
        switch (this.mode) {
            default: {
                break;
            }
            case 0: {
                this.keyPressedPlayMode(n);
                break;
            }
            case 2: {
                if (this.cnt != 0) break;
                this.mode = 0;
                break;
            }
            case 5: {
                this.showMenu();
                break;
            }
            case 1: {
                this.mode = 0;
            }
        }
    }

    private void keyPressedPlayMode(int n) {
        int n2 = this.getGameAction(n);
        System.out.println(n);
        switch (n2) {
            case 2: {
                this.player.moveLeft = true;
                this.player.moveRight = false;
                this.player.moveLeftOnce = true;
                return;
            }
            case 5: {
                this.player.moveRight = true;
                this.player.moveLeft = false;
                this.player.moveRightOnce = true;
                return;
            }
            case 6: {
                this.player.moveDown = true;
                this.player.moveUp = false;
                this.player.moveDownOnce = true;
                return;
            }
            case 1: {
                this.player.moveUp = true;
                this.player.moveDown = false;
                this.player.moveUpOnce = true;
                return;
            }
            case 8: {
                this.player.fire = true;
                this.player.fireOnce = true;
                return;
            }
        }
        switch (n) {
            case 52: {
                this.player.moveLeft = true;
                this.player.moveRight = false;
                this.player.moveLeftOnce = true;
                return;
            }
            case 54: {
                this.player.moveRight = true;
                this.player.moveLeft = false;
                this.player.moveRightOnce = true;
                return;
            }
            case 56: {
                this.player.moveDown = true;
                this.player.moveUp = false;
                this.player.moveDownOnce = true;
                return;
            }
            case 50: {
                this.player.moveUp = true;
                this.player.moveDown = false;
                this.player.moveUpOnce = true;
                return;
            }
            case 53: {
                this.player.fire = true;
                this.player.fireOnce = true;
                return;
            }
        }
    }

    private void keyReleasedPlayMode(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                this.player.moveLeft = false;
                break;
            }
            case 5: {
                this.player.moveRight = false;
                break;
            }
            case 6: {
                this.player.moveDown = false;
                break;
            }
            case 1: {
                this.player.moveUp = false;
                break;
            }
            case 8: {
                this.player.fire = false;
            }
        }
        switch (n) {
            case 52: {
                this.player.moveLeft = false;
                return;
            }
            case 54: {
                this.player.moveRight = false;
                return;
            }
            case 56: {
                this.player.moveDown = false;
                return;
            }
            case 50: {
                this.player.moveUp = false;
                return;
            }
            case 53: {
                this.player.fire = false;
                return;
            }
        }
    }

    public void keyReleased(int n) {
        switch (this.mode) {
            case 0: {
                this.keyReleasedPlayMode(n);
            }
        }
    }

    protected void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.buffer == null) {
            this.buffer = Image.createImage((int)this.drawWidth, (int)this.drawHeight);
            this.bufG = this.buffer.getGraphics();
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        switch (this.mode) {
            case 0: {
                this.renderPlayMode(this.bufG);
                graphics.drawImage(this.buffer, n / 2, n2 / 2, 3);
                break;
            }
            case 2: {
                this.renderLevelStartMode(this.bufG);
                graphics.drawImage(this.buffer, n / 2, n2 / 2, 3);
                break;
            }
            case 5: {
                this.renderGameOverMode(this.bufG);
                graphics.drawImage(this.buffer, n / 2, n2 / 2, 3);
                break;
            }
            case 3: {
                this.renderLevelEndMode(this.bufG);
                graphics.drawImage(this.buffer, n / 2, n2 / 2, 3);
                break;
            }
            case 1: {
                graphics.drawImage(this.buffer, n / 2, n2 / 2, 3);
                graphics.setColor(0, 0, 0);
                graphics.fillRect(n / 2 - 40, n2 / 2 - 10, 80, 20);
                graphics.setColor(100, 200, 250);
                graphics.drawString("Paused", n / 2, n2 / 2, 65);
            }
        }
        if (this.cnt > 0) {
            --this.cnt;
        }
        if (this.mode == 3 && this.cnt == 0) {
            this.nextLevel();
        }
    }

    private void renderPlayMode(Graphics graphics) {
        this.player.update();
        this.playfield.update(graphics);
    }

    public void renderLevelStartMode(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.drawWidth, this.drawHeight);
        graphics.setColor(200, 180, 160);
        graphics.drawString("Level ".concat(String.valueOf(String.valueOf(this.level))), this.drawWidth / 2, this.drawHeight / 2, 65);
        graphics.drawString("Press any key", this.drawWidth / 2, this.drawHeight / 2 + 16, 65);
    }

    public void renderGameOverMode(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.setClip(0, 0, this.drawWidth, this.drawHeight);
        graphics.fillRect(0, 0, this.drawWidth, this.drawHeight);
        graphics.setColor(200, 180, 160);
        graphics.drawString("G A M E   O V E R", this.drawWidth / 2, this.drawHeight / 2 - 10, 65);
        graphics.setColor(100, 180, 200);
        graphics.drawString("Score: ".concat(String.valueOf(String.valueOf(this.player.points))), this.drawWidth / 2, this.drawHeight / 2 + 10, 65);
    }

    public void renderLevelEndMode(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.drawWidth, this.drawHeight);
        graphics.setColor(100, 200, 250);
        graphics.drawString("Level Clear!", this.drawWidth / 2, this.drawHeight / 2, 65);
        graphics.drawString("Score: ".concat(String.valueOf(String.valueOf(Integer.toString(this.player.points)))), this.drawWidth / 2, this.drawHeight / 2 + 16, 65);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void updateAll() {
        this.repaint();
    }

    class FrameUpdateTask
    extends TimerTask {
        public void run() {
            GameScreen.this.updateAll();
        }
    }
}

