/*
 * Decompiled with CFR 0.152.
 */
package bomber;

import bomber.Bomber;
import bomber.GameScreen;
import bomber.Playfield;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;

public class Player {
    public static final byte FACE_DOWN = 0;
    public static final byte FACE_LEFT = 1;
    public static final byte FACE_UP = 2;
    public static final byte FACE_RIGHT = 3;
    public static final int[] STEPS = new int[]{0, 1, 2, 1, 0, 3, 4, 3};
    public static final int NONE = 0;
    public static final byte MODE_NORMAL = 0;
    public static final byte MODE_DYING = 1;
    public static final byte MODE_DEAD = 2;
    GameScreen gameScreen = null;
    int x = 0;
    int y = 0;
    int fx = 0;
    int fy = 0;
    int face = 0;
    int step = 0;
    int startX = 0;
    int startY = 0;
    int lastFX = 0;
    int lastFY = 0;
    int lives = 0;
    int bombs = 0;
    int flames = 0;
    int speed = 0;
    int points = 0;
    int bonus = 0;
    int invinc = 0;
    byte mode = 0;
    byte extra = 0;
    byte exCnt = 0;
    boolean moveUp = false;
    boolean moveDown = false;
    boolean moveLeft = false;
    boolean moveRight = false;
    boolean fire = false;
    boolean fireExtra = false;
    boolean powerUp = false;
    boolean moveUpOnce = false;
    boolean moveDownOnce = false;
    boolean moveLeftOnce = false;
    boolean moveRightOnce = false;
    boolean fireOnce = false;
    boolean fireExtraOnce = false;
    public Playfield playfield = null;
    Image images = null;

    public boolean encode(OutputStream outputStream) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(this.x);
            dataOutputStream.writeInt(this.y);
            dataOutputStream.writeInt(this.fx);
            dataOutputStream.writeInt(this.fy);
            dataOutputStream.writeInt(this.face);
            dataOutputStream.writeInt(this.step);
            dataOutputStream.writeInt(this.startX);
            dataOutputStream.writeInt(this.startY);
            dataOutputStream.writeInt(this.lastFX);
            dataOutputStream.writeInt(this.lastFY);
            dataOutputStream.writeInt(this.lives);
            dataOutputStream.writeInt(this.bombs);
            dataOutputStream.writeInt(this.flames);
            dataOutputStream.writeInt(this.speed);
            dataOutputStream.writeInt(this.points);
            dataOutputStream.writeInt(this.bonus);
            dataOutputStream.writeInt(this.invinc);
            dataOutputStream.writeByte(this.mode);
            dataOutputStream.writeByte(this.extra);
            dataOutputStream.writeByte(this.exCnt);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean decode(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.x = dataInputStream.readInt();
            this.y = dataInputStream.readInt();
            this.fx = dataInputStream.readInt();
            this.fy = dataInputStream.readInt();
            this.face = dataInputStream.readInt();
            this.step = dataInputStream.readInt();
            this.startX = dataInputStream.readInt();
            this.startY = dataInputStream.readInt();
            this.lastFX = dataInputStream.readInt();
            this.lastFY = dataInputStream.readInt();
            this.lives = dataInputStream.readInt();
            this.bombs = dataInputStream.readInt();
            this.flames = dataInputStream.readInt();
            this.speed = dataInputStream.readInt();
            this.points = dataInputStream.readInt();
            this.bonus = dataInputStream.readInt();
            this.invinc = dataInputStream.readInt();
            this.mode = dataInputStream.readByte();
            this.extra = dataInputStream.readByte();
            this.exCnt = dataInputStream.readByte();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public Player(GameScreen gameScreen) {
        this.gameScreen = gameScreen;
        this.images = Bomber.getImage("player00");
    }

    public Image getImage() {
        return this.images;
    }

    public void givePoints(int n) {
        this.bonus = 20;
        this.points += n;
    }

    public void reset() {
        this.startX = 0;
        this.startY = 0;
        this.lives = 3;
        this.bombs = 3;
        this.flames = 2;
        this.speed = 6;
        this.extra = (byte)106;
        this.exCnt = (byte)5;
        this.resetPos();
    }

    public void resetPos() {
        this.x = this.startX;
        this.y = this.startY;
        this.fx = this.lastFX = this.playfield.getGridX(this.x);
        this.fy = this.lastFY = this.playfield.getGridY(this.y);
        this.face = 0;
        this.step = 0;
        this.speed = 6;
        this.mode = 0;
        this.powerUp = false;
        this.fireExtra = false;
        this.fire = false;
        this.moveRight = false;
        this.moveLeft = false;
        this.moveDown = false;
        this.moveUp = false;
        this.fireExtraOnce = false;
        this.fireOnce = false;
        this.moveRightOnce = false;
        this.moveLeftOnce = false;
        this.moveDownOnce = false;
        this.moveUpOnce = false;
    }

    public void kill() {
        if (this.invinc > 0) {
            return;
        }
        this.mode = 1;
        this.step = 0;
    }

    public void update() {
        int n;
        block54: {
            block56: {
                block55: {
                    if (this.mode == 2) {
                        this.gameScreen.showGameOver(this.points);
                        return;
                    }
                    if (this.mode == 1) {
                        ++this.step;
                        if (this.step == 28) {
                            --this.lives;
                            if (this.lives > 0) {
                                this.extra = 0;
                                this.exCnt = 0;
                                this.playfield.trace[this.fy][this.fx] = -1;
                                this.resetPos();
                                this.invinc = 40;
                            } else {
                                this.mode = (byte)2;
                                GameScreen.instance.mode = 5;
                            }
                        }
                        return;
                    }
                    if (this.invinc > 0) {
                        --this.invinc;
                    }
                    n = 8;
                    this.fx = this.playfield.getGridX(this.x + n);
                    this.fy = this.playfield.getGridY(this.y + n);
                    int n2 = (this.x + n) % 16;
                    int n3 = (this.y + n) % 16;
                    boolean bl = false;
                    byte by = this.playfield.passThrough(this.fx, this.fy, true);
                    if (by == 2 && this.flames < 7) {
                        ++this.flames;
                    } else if (by == 1 && this.bombs < 7) {
                        ++this.bombs;
                    } else if (by == 11) {
                        GameScreen.instance.levelClear();
                    } else if (by == 10) {
                        this.kill();
                    } else if (by == 8) {
                        this.givePoints(50);
                    } else if (by >= 4 && by <= 7) {
                        if (this.extra == by + 100) {
                            this.exCnt = (byte)(this.exCnt + 5);
                        } else {
                            this.exCnt = (byte)5;
                            this.extra = (byte)(by + 100);
                        }
                    }
                    if (this.powerUp) {
                        ++this.bombs;
                        ++this.flames;
                        this.powerUp = false;
                    }
                    if (this.moveDown || this.moveDownOnce) {
                        this.face = 0;
                        this.moveDownOnce = false;
                        this.moveUpOnce = false;
                        this.moveLeftOnce = false;
                        this.moveRightOnce = false;
                        if (n2 == n && n3 < n) {
                            this.y += Math.min(this.speed, n - n3);
                            bl = true;
                        } else if (this.playfield.isPassable(this.fx, this.fy + 1, -2)) {
                            if (n2 == n) {
                                this.y += this.speed;
                            } else {
                                this.x = n2 > n ? (this.x -= Math.min(this.speed, n2 - n)) : (this.x += Math.min(this.speed, n - n2));
                            }
                            bl = true;
                        }
                    }
                    if ((this.moveUp || this.moveUpOnce) && !bl) {
                        this.face = 2;
                        this.moveDownOnce = false;
                        this.moveUpOnce = false;
                        this.moveLeftOnce = false;
                        this.moveRightOnce = false;
                        if (n2 == n && n3 > n) {
                            this.y -= Math.min(this.speed, n3 - n);
                            bl = true;
                        } else if (this.playfield.isPassable(this.fx, this.fy - 1, -2)) {
                            if (n2 == n) {
                                this.y -= this.speed;
                            } else {
                                this.x = n2 > n ? (this.x -= Math.min(this.speed, n2 - n)) : (this.x += Math.min(this.speed, n - n2));
                            }
                            bl = true;
                        }
                    }
                    if ((this.moveRight || this.moveRightOnce) && !bl) {
                        this.face = 3;
                        this.moveDownOnce = false;
                        this.moveUpOnce = false;
                        this.moveLeftOnce = false;
                        this.moveRightOnce = false;
                        if (n3 == n && n2 < n) {
                            this.x += Math.min(this.speed, n - n2);
                            bl = true;
                        } else if (this.playfield.isPassable(this.fx + 1, this.fy, -2)) {
                            if (n3 == n) {
                                this.x += this.speed;
                            } else {
                                this.y = n3 > n ? (this.y -= Math.min(this.speed, n3 - n)) : (this.y += Math.min(this.speed, n - n3));
                            }
                            bl = true;
                        }
                    }
                    if ((this.moveLeft || this.moveLeftOnce) && !bl) {
                        this.face = 1;
                        this.moveDownOnce = false;
                        this.moveUpOnce = false;
                        this.moveLeftOnce = false;
                        this.moveRightOnce = false;
                        if (n3 == n && n2 > n) {
                            this.x -= Math.min(this.speed, n2 - n);
                            bl = true;
                        } else if (this.playfield.isPassable(this.fx - 1, this.fy, -2)) {
                            if (n3 == n) {
                                this.x -= this.speed;
                            } else {
                                this.y = n3 > n ? (this.y -= Math.min(this.speed, n3 - n)) : (this.y += Math.min(this.speed, n - n3));
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        ++this.step;
                        if (this.step == 8) {
                            this.step = 0;
                        }
                    }
                    if (this.fire || this.fireOnce) {
                        this.playfield.setBomb((byte)101, this.fx, this.fy, 32);
                        this.fireOnce = false;
                    }
                    if (!this.fireExtra && !this.fireExtraOnce) break block54;
                    Player player = this;
                    if (this.extra == 105) break block55;
                    Player player2 = this;
                    if (this.extra == 104) break block55;
                    Player player3 = this;
                    if (this.extra == 106) break block55;
                    Player player4 = this;
                    if (this.extra != 107) break block56;
                }
                if (this.playfield.setBomb(this.extra, this.fx, this.fy, 32)) {
                    this.exCnt = (byte)(this.exCnt - 1);
                }
                if (this.exCnt == 0) {
                    this.extra = 0;
                }
            }
            this.fireExtraOnce = false;
        }
        this.fx = this.playfield.getGridX(this.x + n);
        this.fy = this.playfield.getGridY(this.y + n);
        if (this.fx != this.lastFX) {
            this.playfield.trace[this.lastFY][this.lastFX] = (byte)(this.lastFX >= this.fx ? 1 : 3);
        }
        if (this.fy != this.lastFY) {
            this.playfield.trace[this.lastFY][this.lastFX] = (byte)(this.lastFY >= this.fy ? 2 : 0);
        }
        this.lastFX = this.fx;
        this.lastFY = this.fy;
    }
}

