/*
 * Decompiled with CFR 0.152.
 */
package com.edek.dg.config;

import com.edek.dg.FlashLight;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FlashConfig {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec server_config;
    public static ForgeConfigSpec.ConfigValue<Integer> range;
    public static ForgeConfigSpec.ConfigValue<Integer> batteryLifeTime;

    private static void setupServerConfig() {
        builder.comment("General Config").push("General");
        range = builder.comment("Default: 32").define("Flashlight light range", (Object)32);
        batteryLifeTime = builder.comment("Default: 12000 (10 min)").define("Small Redstone Battery lifetime in ticks", (Object)12000);
        builder.pop();
    }

    public static void loadConfig(ForgeConfigSpec config, String path) {
        FlashLight.log.info("Loading config: " + path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        FlashLight.log.info("Config loaded");
        config.setConfig((CommentedConfig)file);
    }

    static {
        FlashConfig.setupServerConfig();
        server_config = builder.build();
        FlashLight.log.info("Config has been initialized");
    }
}

