/*
 * Decompiled with CFR 0.152.
 */
package com.growuphappily.test.client;

import com.growuphappily.test.client.ClientLighting;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class LightingThread
extends Thread {
    public static ArrayList<BlockPos> getBall(Vector3d c, int r) {
        float x = (float)c.field_72450_a;
        float y = (float)c.field_72448_b;
        float z = (float)c.field_72449_c;
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (float i = x - (float)r; i < x + (float)r; i += 1.0f) {
            for (float j = y - (float)r; j < y + (float)r; j += 1.0f) {
                for (float k = z - (float)r; k < z + (float)r; k += 1.0f) {
                    double v = Math.pow(i - x, 2.0) + Math.pow(j - y, 2.0) + Math.pow(k - z, 2.0);
                    if (!(v <= Math.pow(r, 2.0))) continue;
                    blocks.add(new BlockPos((double)i, (double)j, (double)k));
                }
            }
        }
        return blocks;
    }

    public static ArrayList<BlockPos> getLineOrdered(Vector3d v1, Vector3d v2) {
        Vector3d v = v2.func_178788_d(v1);
        Vector3d lv = LightingThread.vecmul(v, 0.9 / v.func_72433_c());
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        BlockPos lastBlock = null;
        Vector3d lv1 = lv;
        while (lv1.func_72433_c() <= v.func_72433_c()) {
            Vector3d pos = lv1.func_178787_e(v1);
            BlockPos currentBlock = new BlockPos(Math.floor(pos.field_72450_a), Math.floor(pos.field_72448_b), Math.floor(pos.field_72449_c));
            if (currentBlock.equals(lastBlock)) {
                lv1 = lv1.func_178787_e(lv);
                continue;
            }
            lv1 = lv1.func_178787_e(lv);
            if (!blocks.contains(currentBlock)) {
                blocks.add(currentBlock);
            }
            lastBlock = currentBlock;
        }
        return blocks;
    }

    public static Vector3d vecmul(Vector3d v, double x) {
        return new Vector3d(v.field_72450_a * x, v.field_72448_b * x, v.field_72449_c * x);
    }

    public static double mul(Vector3d v1, Vector3d v2) {
        return v1.field_72450_a * v2.field_72450_a + v1.field_72448_b * v2.field_72448_b + v1.field_72449_c * v2.field_72449_c;
    }

    public static boolean noBlockSurround(World world, BlockPos pos) {
        boolean noBlockSurround = true;
        for (int i = -1; i < 2; ++i) {
            block1: for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    BlockPos current = new BlockPos(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k);
                    if (current == pos || world.func_175623_d(current)) continue;
                    noBlockSurround = false;
                    continue block1;
                }
            }
        }
        return noBlockSurround;
    }

    @Override
    public void run() {
        while (true) {
            if (!ClientLighting.run) {
                continue;
            }
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || world == null) {
                ClientLighting.run = false;
                continue;
            }
            Vector3d playerPos = player.func_213303_ch();
            playerPos = new Vector3d(playerPos.field_72450_a, playerPos.field_72448_b + (double)player.func_70047_e(), playerPos.field_72449_c);
            Vector3d lookVec = LightingThread.vecmul(player.func_70040_Z(), ClientLighting.maxDistance);
            Vector3d lookPos = lookVec.func_178787_e(playerPos);
            ArrayList<BlockPos> ball = LightingThread.getBall(lookPos, ClientLighting.maxR);
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            block1: for (int j = 0; j < ball.size(); ++j) {
                ArrayList<BlockPos> currentLine = LightingThread.getLineOrdered(playerPos, new Vector3d((double)ball.get(j).func_177958_n(), (double)ball.get(j).func_177956_o(), (double)ball.get(j).func_177952_p()));
                for (int k = 0; k < currentLine.size(); ++k) {
                    if (world.func_180495_p(currentLine.get(k)).func_200132_m()) {
                        if (blocks.contains(currentLine.get(k))) continue block1;
                        blocks.add(currentLine.get(k));
                        continue block1;
                    }
                    if (blocks.contains(currentLine.get(k))) continue;
                    blocks.add(currentLine.get(k));
                }
            }
            ClientLighting.output = blocks;
        }
    }
}

