var Opcodes = Java.type('org.objectweb.asm.Opcodes');
var InsnNode = Java.type('org.objectweb.asm.tree.InsnNode');
var InsnList = Java.type('org.objectweb.asm.tree.InsnList');
var MethodInsnNode = Java.type('org.objectweb.asm.tree.MethodInsnNode');
var VarInsnNode = Java.type('org.objectweb.asm.tree.VarInsnNode');

function initializeCoreMod() {
    return {
        'BlockLightTransformer': {
            'target': {
                'type': 'CLASS',
                'name': 'net/minecraft/world/IBlockDisplayReader'
            },
            'transformer': function (cn) {
                cn.methods.forEach(function (method) {
                    if (method.name === "getLightFor" || method.name === "func_226658_a_") {
                        method.instructions.clear();
                        var list = new InsnList();
                        list.add(new VarInsnNode(Opcodes.ALOAD, 0));
                        list.add(new VarInsnNode(Opcodes.ALOAD, 1));
                        list.add(new VarInsnNode(Opcodes.ALOAD, 2));
                        list.add(new MethodInsnNode(Opcodes.INVOKESTATIC, "com/growuphappily/test/core/BlockDisplayReaderOverride", "getLightFor", "(Lnet/minecraft/world/IBlockDisplayReader;Lnet/minecraft/world/LightType;Lnet/minecraft/util/math/BlockPos;)I"))
                        list.add(new InsnNode(Opcodes.IRETURN))
                        method.instructions.insert(list);
                    }
                });
                return cn;
            }
        },
        'EntityRenderManagerTransformer': {
            'target': {
                'type': 'CLASS',
                'name': 'net/minecraft/client/renderer/entity/EntityRendererManager'
            },
            'transformer': function (cn) {
                cn.methods.forEach(function (method) {
                    if (method.name === "getPackedLight" || method.name === "func_229085_a_") {
                        method.instructions.clear();
                        var list = new InsnList();
                        list.add(new VarInsnNode(Opcodes.ALOAD, 0));
                        list.add(new VarInsnNode(Opcodes.ALOAD, 1));
                        list.add(new VarInsnNode(Opcodes.FLOAD, 2));
                        list.add(new MethodInsnNode(Opcodes.INVOKESTATIC, "com/growuphappily/test/core/EntityRendererManagerOverride", "getPackedLight", "(Lnet/minecraft/client/renderer/entity/EntityRendererManager;Lnet/minecraft/entity/Entity;F)I"))
                        list.add(new InsnNode(Opcodes.IRETURN))
                        method.instructions.insert(list);
                    }
                });
                return cn;
            }
        }
    }
}