/*
 * Decompiled with CFR 0.152.
 */
package net.pure2.game2048;

import java.io.File;
import net.pure2.game2048.InputHandler;
import net.pure2.game2048.UserInterface;
import net.pure2.game2048.tile.TileSet;
import org.lwjgl.LWJGLUtil;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;

public final class Game
extends BasicGame {
    private static final String VERSION = "v1.0.2";
    private InputHandler input;
    private UserInterface ui;
    private TileSet tiles;
    private int score = 0;
    private int bestScore = 0;

    public static void main(String[] args) throws SlickException {
        System.setProperty("org.lwjgl.librarypath", new File(new File(System.getProperty("user.dir"), "lib/natives"), LWJGLUtil.getPlatformName()).getAbsolutePath());
        System.setProperty("net.java.games.input.librarypath", System.getProperty("org.lwjgl.librarypath"));
        AppGameContainer gc = new AppGameContainer((org.newdawn.slick.Game)new Game("2048"));
        gc.setDisplayMode(514, 514, false);
        gc.setTargetFrameRate(60);
        gc.setShowFPS(false);
        gc.setAlwaysRender(true);
        gc.setSmoothDeltas(true);
        gc.setVSync(true);
        gc.start();
    }

    public Game(String title) {
        super(title);
    }

    public void init(GameContainer gc) throws SlickException {
        this.input = new InputHandler(this);
        this.ui = new UserInterface(this);
        this.tiles = new TileSet(this, 4, 4);
        this.tiles.populate();
        this.tiles.insertRandomTile();
    }

    public void update(GameContainer gc, int i) throws SlickException {
        this.input.handle(gc);
    }

    public void render(GameContainer gc, Graphics g) throws SlickException {
        this.ui.renderBackground(gc, g);
        this.tiles.render(g);
        this.ui.renderScore(g, gc.isShowingFPS());
        if (!this.tiles.canMove()) {
            this.ui.renderGameOverText(g);
        }
    }

    public void reset() {
        if (this.score > this.bestScore) {
            this.bestScore = this.score;
        }
        this.setScore(0);
        this.getTiles().populate();
        this.getTiles().insertRandomTile();
    }

    public TileSet getTiles() {
        return this.tiles;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public void addScore(int score) {
        this.score += score;
    }

    public int getBestScore() {
        return this.bestScore;
    }
}

