/*
 * Decompiled with CFR 0.152.
 */
package net.pure2.game2048;

import net.pure2.game2048.Game;
import net.pure2.game2048.tile.TileSet;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Input;

public final class InputHandler {
    private static final long INPUT_DELAY = 100L;
    private final Game game;
    private long lastInput = System.currentTimeMillis();

    public InputHandler(Game game) {
        this.game = game;
    }

    public void handle(GameContainer gc) {
        if (System.currentTimeMillis() - this.lastInput < 100L) {
            return;
        }
        Input input = gc.getInput();
        if (input.isKeyDown(19)) {
            this.game.reset();
        }
        if (input.isKeyDown(33)) {
            gc.setShowFPS(!gc.isShowingFPS());
        }
        if (this.game.getTiles().canMove()) {
            if (input.isKeyDown(200)) {
                this.game.getTiles().process(TileSet.Direction.UP);
                this.insertRandomTile();
            }
            if (input.isKeyDown(208)) {
                this.game.getTiles().process(TileSet.Direction.DOWN);
                this.insertRandomTile();
            }
            if (input.isKeyDown(203)) {
                this.game.getTiles().process(TileSet.Direction.LEFT);
                this.insertRandomTile();
            }
            if (input.isKeyDown(205)) {
                this.game.getTiles().process(TileSet.Direction.RIGHT);
                this.insertRandomTile();
            }
        }
        this.lastInput = System.currentTimeMillis();
    }

    private boolean insertRandomTile() {
        if (this.game.getTiles().hasFreeSlot()) {
            this.game.getTiles().insertRandomTile();
            return true;
        }
        return false;
    }
}

