/*
 * Decompiled with CFR 0.152.
 */
package net.pure2.game2048;

import net.pure2.game2048.Game;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;

public final class UserInterface {
    private final Game game;

    public UserInterface(Game game) {
        this.game = game;
    }

    public void renderBackground(GameContainer gc, Graphics g) {
        g.setColor(new Color(209, 213, 255));
        g.fill((Shape)new Rectangle(0.0f, 0.0f, (float)gc.getWidth(), (float)gc.getHeight()));
    }

    public void renderScore(Graphics g, boolean showingFps) {
        int y = showingFps ? 30 : 5;
        g.setColor(Color.white);
        g.drawString("Score: " + this.game.getScore(), 8.0f, (float)y);
        g.drawString("Best Score: " + this.game.getBestScore(), 8.0f, (float)(y + 20));
    }

    public void renderGameOverText(Graphics g) {
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        g.fill((Shape)new Rectangle(128.0f, 100.0f, 300.0f, 40.0f));
        g.setColor(Color.white);
        g.drawString("Game over, your score is: " + this.game.getScore() + "!", 130.0f, 100.0f);
        g.drawString("Press r to play again!", 130.0f, 120.0f);
    }
}

