/*
 * Decompiled with CFR 0.152.
 */
package net.pure2.game2048.tile;

import net.pure2.game2048.tile.TileColours;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.RoundedRectangle;
import org.newdawn.slick.geom.Shape;

public final class Tile {
    private final int x;
    private final int y;
    private final int sizeY;
    private final int sizeX;
    private int valRenderPosX;
    private int valRenderPosY;
    private int value;
    private boolean combinedThisTurn;
    private Color[] colours;

    public Tile(int x, int y, int sizeX, int sizeY) {
        this(-1, x, y, sizeX, sizeY);
    }

    public Tile(int value, int x, int y, int sizeX, int sizeY) {
        this.value = value;
        this.x = x;
        this.y = y;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.fetchColours();
        this.calcValRenderPos();
    }

    public void increaseValue() {
        this.setValue(this.value * 2);
    }

    public void setValue(int value) {
        this.value = value;
        this.fetchColours();
        this.calcValRenderPos();
    }

    public int getValue() {
        return this.value;
    }

    public void setCombinedThisTurn(boolean combinedThisTurn) {
        this.combinedThisTurn = combinedThisTurn;
    }

    public boolean wasCombinedThisTurn() {
        return this.combinedThisTurn;
    }

    public boolean isValid() {
        return this.value != -1;
    }

    public void reset() {
        this.value = -1;
        this.fetchColours();
        this.calcValRenderPos();
    }

    public void render(Graphics g) {
        g.setColor(this.colours[TileColours.TILE_COLOUR_ID]);
        g.fill((Shape)new RoundedRectangle((float)(this.x + 1), (float)(this.y + 1), (float)this.sizeX, (float)this.sizeY, 8.0f));
        if (this.value != -1) {
            g.setColor(this.colours[TileColours.TEXT_COLOUR_ID]);
            g.drawString(Integer.toString(this.value), (float)this.valRenderPosX, (float)this.valRenderPosY);
        }
    }

    private void fetchColours() {
        this.colours = TileColours.getColourScheme(this.value);
    }

    private void calcValRenderPos() {
        this.valRenderPosX = this.x + this.sizeX / 2 - Integer.toString(this.value).length() * 3;
        this.valRenderPosY = this.y + this.sizeY / 2 - 8;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tile) {
            Tile tile = (Tile)obj;
            return tile.getValue() == this.value && tile.wasCombinedThisTurn() == this.combinedThisTurn;
        }
        return false;
    }

    public static boolean canCombine(Tile tile1, Tile tile2) {
        return tile1.isValid() && tile1.getValue() != 1024 && tile1.equals(tile2);
    }
}

