/*
 * Decompiled with CFR 0.152.
 */
package net.pure2.game2048.tile;

import java.util.Random;
import net.pure2.game2048.Game;
import net.pure2.game2048.tile.Tile;
import org.newdawn.slick.Graphics;

public final class TileSet {
    private final Random rand = new Random();
    private final Game game;
    private final Tile[][] tiles;
    private final int width;
    private final int height;
    private int tileWidth = 128;
    private int tileHeight = 128;

    public TileSet(Game game, int width, int height) {
        this.game = game;
        this.width = width;
        this.height = height;
        this.tiles = new Tile[height][width];
    }

    public void setTileSize(int width, int height) {
        this.tileWidth = width;
        this.tileHeight = height;
    }

    public void process(Direction dir) {
        this.shiftTiles(dir);
        this.combineTiles(dir);
    }

    private void combineTiles(Direction dir) {
        boolean swapped = true;
        switch (dir) {
            case UP: {
                while (swapped) {
                    swapped = false;
                    for (int x = this.width - 1; x > 0; --x) {
                        for (int y = 0; y < this.height; ++y) {
                            if (!Tile.canCombine(this.tiles[y][x - 1], this.tiles[y][x])) continue;
                            this.tiles[y][x - 1].increaseValue();
                            this.tiles[y][x].reset();
                            this.tiles[y][x - 1].setCombinedThisTurn(true);
                            this.tiles[y][x].setCombinedThisTurn(true);
                            this.game.addScore(this.tiles[y][x - 1].getValue());
                            swapped = true;
                        }
                    }
                }
                break;
            }
            case DOWN: {
                while (swapped) {
                    swapped = false;
                    for (int x = 0; x < this.width - 1; ++x) {
                        for (int y = 0; y < this.height; ++y) {
                            if (!Tile.canCombine(this.tiles[y][x + 1], this.tiles[y][x])) continue;
                            this.tiles[y][x + 1].increaseValue();
                            this.tiles[y][x].reset();
                            this.tiles[y][x + 1].setCombinedThisTurn(true);
                            this.tiles[y][x].setCombinedThisTurn(true);
                            this.game.addScore(this.tiles[y][x + 1].getValue());
                            swapped = true;
                        }
                    }
                }
                break;
            }
            case RIGHT: {
                while (swapped) {
                    swapped = false;
                    for (int y = 0; y < this.height - 1; ++y) {
                        for (int x = 0; x < this.width; ++x) {
                            if (!Tile.canCombine(this.tiles[y + 1][x], this.tiles[y][x])) continue;
                            this.tiles[y + 1][x].increaseValue();
                            this.tiles[y][x].reset();
                            this.tiles[y + 1][x].setCombinedThisTurn(true);
                            this.tiles[y][x].setCombinedThisTurn(true);
                            this.game.addScore(this.tiles[y + 1][x].getValue());
                            swapped = true;
                        }
                    }
                }
                break;
            }
            case LEFT: {
                while (swapped) {
                    swapped = false;
                    for (int y = this.height - 1; y > 0; --y) {
                        for (int x = 0; x < this.width; ++x) {
                            if (!Tile.canCombine(this.tiles[y - 1][x], this.tiles[y][x])) continue;
                            this.tiles[y - 1][x].increaseValue();
                            this.tiles[y][x].reset();
                            this.tiles[y - 1][x].setCombinedThisTurn(true);
                            this.tiles[y][x].setCombinedThisTurn(true);
                            this.game.addScore(this.tiles[y - 1][x].getValue());
                            swapped = true;
                        }
                    }
                }
                break;
            }
        }
        this.resetCombineFlags();
    }

    private void shiftTiles(Direction dir) {
        boolean swapped = true;
        switch (dir) {
            case UP: {
                while (swapped) {
                    swapped = false;
                    for (int x = this.width - 1; x > 0; --x) {
                        for (int y = 0; y < this.height; ++y) {
                            if (this.tiles[y][x - 1].isValid() || !this.tiles[y][x].isValid()) continue;
                            this.tiles[y][x - 1].setValue(this.tiles[y][x].getValue());
                            this.tiles[y][x].setValue(-1);
                            swapped = true;
                        }
                    }
                }
                break;
            }
            case DOWN: {
                while (swapped) {
                    swapped = false;
                    for (int x = 0; x < this.width - 1; ++x) {
                        for (int y = 0; y < this.height; ++y) {
                            if (this.tiles[y][x + 1].isValid() || !this.tiles[y][x].isValid()) continue;
                            this.tiles[y][x + 1].setValue(this.tiles[y][x].getValue());
                            this.tiles[y][x].setValue(-1);
                            swapped = true;
                        }
                    }
                }
                break;
            }
            case RIGHT: {
                while (swapped) {
                    swapped = false;
                    for (int y = 0; y < this.height - 1; ++y) {
                        for (int x = 0; x < this.width; ++x) {
                            if (this.tiles[y + 1][x].isValid() || !this.tiles[y][x].isValid()) continue;
                            this.tiles[y + 1][x].setValue(this.tiles[y][x].getValue());
                            this.tiles[y][x].setValue(-1);
                            swapped = true;
                        }
                    }
                }
                break;
            }
            case LEFT: {
                while (swapped) {
                    swapped = false;
                    for (int y = this.height - 1; y > 0; --y) {
                        for (int x = 0; x < this.width; ++x) {
                            if (this.tiles[y - 1][x].isValid() || !this.tiles[y][x].isValid()) continue;
                            this.tiles[y - 1][x].setValue(this.tiles[y][x].getValue());
                            this.tiles[y][x].setValue(-1);
                            swapped = true;
                        }
                    }
                }
                break;
            }
        }
    }

    public boolean canMove() {
        int x;
        int y;
        int y2;
        int x2;
        if (this.hasFreeSlot()) {
            return true;
        }
        for (x2 = this.width - 1; x2 > 0; --x2) {
            for (y2 = 0; y2 < this.height; ++y2) {
                if (!Tile.canCombine(this.tiles[y2][x2 - 1], this.tiles[y2][x2])) continue;
                return true;
            }
        }
        for (x2 = 0; x2 < this.width - 1; ++x2) {
            for (y2 = 0; y2 < this.height; ++y2) {
                if (!Tile.canCombine(this.tiles[y2][x2 + 1], this.tiles[y2][x2])) continue;
                return true;
            }
        }
        for (y = 0; y < this.height - 1; ++y) {
            for (x = 0; x < this.width; ++x) {
                if (!Tile.canCombine(this.tiles[y + 1][x], this.tiles[y][x])) continue;
                return true;
            }
        }
        for (y = this.height - 1; y > 0; --y) {
            for (x = 0; x < this.width; ++x) {
                if (!Tile.canCombine(this.tiles[y - 1][x], this.tiles[y][x])) continue;
                return true;
            }
        }
        return false;
    }

    public void render(Graphics g) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.tiles[y][x].render(g);
            }
        }
    }

    public void populate() {
        int offsetY = 0;
        int offsetX = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.tiles[y][x] = new Tile(offsetY, offsetX, this.tileWidth, this.tileHeight);
                offsetX += this.tileWidth;
            }
            offsetX = 0;
            offsetY += this.tileHeight;
        }
    }

    private void resetCombineFlags() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.tiles[y][x].setCombinedThisTurn(false);
            }
        }
    }

    public boolean hasTile(int value) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.tiles[y][x].getValue() != value) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasFreeSlot() {
        return this.freeSlots() > 0;
    }

    public int freeSlots() {
        int count = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.tiles[y][x].getValue() != -1) continue;
                ++count;
            }
        }
        return count;
    }

    public Tile[] getFreeTiles() {
        Tile[] freeTiles = new Tile[this.freeSlots()];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.tiles[y][x].getValue() != -1) continue;
                freeTiles[index] = this.tiles[y][x];
                ++index;
            }
        }
        return freeTiles;
    }

    public void insertRandomTile() {
        Tile[] tiles = this.getFreeTiles();
        tiles[this.rand.nextInt(tiles.length)].setValue(this.getRandomTileValue());
    }

    private int getRandomTileValue() {
        return this.rand.nextInt(100) > 30 ? 2 : 4;
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

