/*
 * Decompiled with CFR 0.152.
 */
public class Record
implements Runnable {
    static final int EVENTO_PULSAR = 0;
    static final int EVENTO_SOLTAR = 1;
    static final int EVENTO_ARRASTRAR = 2;
    static final int MODO_NORMAL = 0;
    static final int MODO_SONIDO = 1;
    static boolean ALGUN_RECORD_ACTUALIZADO = false;
    private Piano piano;
    private String titulo;
    private int dim;
    private int instrumento;
    private int numTeclados;
    private int zoom;
    private int offset;
    private int longitud;
    private int instrumentoAnterior;
    private int numTecladosAnterior;
    private int zoomAnterior;
    private int offsetAnterior;
    private int longitudAnterior;
    private int indice;
    private int[] espaciado;
    private int[] evento;
    private int[] dato;
    private boolean grabando;
    private boolean reproduciendo;
    private long tiempo;

    public Record(int dim, Piano piano) {
        this.piano = piano;
        this.dim = dim;
        this.titulo = "";
        this.longitud = 0;
        this.espaciado = new int[dim];
        this.evento = new int[dim];
        this.dato = new int[dim];
        this.grabando = false;
        this.reproduciendo = false;
    }

    public void init(String data) {
        int iPos2;
        int idato = -5;
        int iPos = 0;
        int indice = 0;
        while ((iPos2 = data.indexOf("|", iPos)) > -1) {
            switch (idato) {
                case -5: {
                    this.titulo = data.substring(iPos, iPos2);
                    break;
                }
                case -4: {
                    this.instrumento = Integer.parseInt(data.substring(iPos, iPos2));
                    break;
                }
                case -3: {
                    this.numTeclados = Integer.parseInt(data.substring(iPos, iPos2));
                    break;
                }
                case -2: {
                    this.zoom = Integer.parseInt(data.substring(iPos, iPos2));
                    break;
                }
                case -1: {
                    this.offset = Integer.parseInt(data.substring(iPos, iPos2));
                    break;
                }
                case 0: {
                    this.espaciado[indice] = Integer.parseInt(data.substring(iPos, iPos2));
                    break;
                }
                case 1: {
                    this.evento[indice] = Integer.parseInt(data.substring(iPos, iPos2));
                    break;
                }
                case 2: {
                    this.dato[indice] = Integer.parseInt(data.substring(iPos, iPos2));
                    ++indice;
                }
            }
            if (++idato > 2) {
                idato = 0;
            }
            iPos = iPos2 + 1;
        }
        this.longitud = indice;
        indice = 0;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
        ALGUN_RECORD_ACTUALIZADO = true;
    }

    public String getDescripcion() {
        return String.valueOf(new String(this.titulo.length() > 0 ? this.titulo : Idioma.texto_sin_titulo[this.piano.getIdioma()])) + new String(this.longitud > 0 ? " - " + this.piano.getInstrumento(this.instrumento).getNombre(this.piano.getIdioma()) + " (" + String.valueOf(this.getNotas()) + " " + Idioma.texto_notas[this.piano.getIdioma()] + ")" : " (" + Idioma.texto_vacio[this.piano.getIdioma()] + ")");
    }

    public int getLongitud() {
        return this.longitud;
    }

    public int getNotas() {
        int notas = 0;
        int i = 0;
        while (i < this.longitud) {
            if (this.evento[i] == 0) {
                ++notas;
            }
            ++i;
        }
        return notas;
    }

    public boolean reproduciendo() {
        return this.reproduciendo;
    }

    public boolean grabando() {
        return this.grabando;
    }

    public boolean enPausa() {
        return !this.reproduciendo && !this.grabando;
    }

    public void grabar(int instrumento, int numTeclados, int zoom, int offset) {
        this.instrumentoAnterior = this.instrumento;
        this.numTecladosAnterior = this.numTeclados;
        this.zoomAnterior = this.zoom;
        this.offsetAnterior = this.offset;
        this.longitudAnterior = this.longitud;
        this.instrumento = instrumento;
        this.numTeclados = numTeclados;
        this.zoom = zoom;
        this.offset = offset;
        this.longitud = 0;
        this.indice = 0;
        this.grabando = true;
        this.reproduciendo = false;
        this.piano.getTeclado().crearImagenBarra();
        this.piano.getTeclado().repaint();
        this.tiempo = System.currentTimeMillis();
    }

    public void reproducir() {
        this.indice = 0;
        this.reproduciendo = true;
        this.grabando = false;
        if (this.piano.getModo() != 1) {
            this.piano.setZoom(this.zoom);
            this.piano.setDobleTeclado(this.numTeclados == 2);
        }
        this.piano.setInstrumento(this.instrumento);
        this.piano.getTeclado().crearTeclado();
        if (this.piano.getModo() != 1) {
            this.piano.getTeclado().setOffset(this.offset);
        }
        this.piano.getTeclado().showNotify();
        new Thread(this).start();
    }

    public void parar() {
        if (this.grabando) {
            if (this.longitud > 0) {
                this.piano.crearListaTracks(this.piano.getCodigoRecord());
                ALGUN_RECORD_ACTUALIZADO = true;
            } else {
                this.instrumento = this.instrumentoAnterior;
                this.numTeclados = this.numTecladosAnterior;
                this.zoom = this.zoomAnterior;
                this.offset = this.offsetAnterior;
                this.longitud = this.longitudAnterior;
            }
        }
        this.piano.getTeclado().desactivarTeclas();
        this.reproduciendo = false;
        this.grabando = false;
        this.piano.getTeclado().crearImagenBarra();
        this.piano.getTeclado().repaint();
    }

    public void borrar() {
        this.titulo = "";
        this.longitud = 0;
        ALGUN_RECORD_ACTUALIZADO = true;
    }

    public void restaurar(int melodia) {
        switch (melodia) {
            case 0: {
                this.init("Jesu, Joy of Man's Desiring|0|1|1|-665|922|0|24|119|1|24|201|0|26|96|1|26|203|0|28|107|1|28|223|0|31|109|1|31|200|0|29|114|1|29|199|0|29|107|1|29|222|0|33|123|1|33|209|0|31|120|1|31|200|0|31|109|1|31|211|0|36|132|1|36|179|0|35|131|1|35|182|0|36|118|1|36|222|0|31|120|1|31|191|0|28|108|1|28|202|0|24|119|1|24|233|0|26|99|1|26|200|0|28|118|1|28|182|0|29|120|1|29|222|0|31|131|1|31|179|0|33|120|1|33|211|0|31|120|1|31|180|0|29|137|1|29|205|0|28|119|1|28|180|0|26|131|1|26|201|0|28|114|1|28|196|0|24|130|1|24|192|0|23|119|1|23|200|0|24|121|1|24|211|0|26|88|1|26|244|0|19|109|1|19|201|0|23|116|1|23|205|0|26|120|1|26|211|0|29|113|1|29|186|0|28|121|1|28|222|0|26|111|1|26|188|0|28|121|1|28|210|0|24|116|1|24|184|0|26|109|1|26|200|0|28|110|1|28|222|0|31|131|1|31|190|0|29|110|1|29|201|0|29|109|1|29|233|0|33|109|1|33|190|0|31|109|1|31|222|0|31|89|1|31|243|0|36|116|1|36|194|0|35|109|1|35|201|0|36|99|1|36|244|0|31|98|1|31|201|0|28|98|1|28|246|0|24|108|1|24|211|0|26|88|1|26|222|0|28|88|1|28|222|0|21|88|1|21|267|0|31|119|1|31|188|0|29|123|1|29|201|0|28|109|1|28|220|0|26|110|1|26|200|0|24|99|1|24|213|0|19|108|1|19|211|0|24|131|1|24|200|0|23|110|1|23|190|0|24|98|1|24|233|0|28|110|1|28|201|0|31|116|1|31|194|0|36|131|1|36|211|0|31|114|1|31|207|0|28|98|1|28|239|0|24|339|1|24|");
                break;
            }
            case 1: {
                this.init("F\u00fcr Elise|1|1|1|-425|494|0|28|88|1|28|158|0|27|80|1|27|169|0|28|70|1|28|193|0|27|63|1|27|176|0|28|72|1|28|185|0|23|62|1|23|194|0|26|71|1|26|176|0|24|63|1|24|203|0|21|70|1|21|348|0|12|54|1|12|202|0|16|54|1|16|202|0|21|62|1|21|159|0|23|80|1|23|315|0|16|52|1|16|195|0|20|44|1|20|211|0|23|71|1|23|176|0|24|72|1|24|348|0|28|63|1|28|211|0|27|57|1|27|172|0|28|64|1|28|210|0|27|62|1|27|186|0|28|52|1|28|203|0|23|64|1|23|175|0|26|63|1|26|185|0|24|62|1|24|203|0|21|79|1|21|304|0|12|53|1|12|176|0|16|72|1|16|186|0|21|70|1|21|176|0|23|89|1|23|287|0|16|55|1|16|210|0|24|54|1|24|179|0|23|68|1|23|211|0|21|96|1|21|391|0|23|62|1|23|159|0|24|72|1|24|176|0|26|63|1|26|211|0|28|66|1|28|292|0|19|54|1|19|276|0|29|65|1|29|193|0|28|62|1|28|176|0|26|81|1|26|339|0|17|54|1|17|261|0|28|96|1|28|192|0|26|80|1|26|150|0|24|72|1|24|331|0|16|80|1|16|262|0|26|96|1|26|176|0|24|81|1|24|140|0|23|106|1|23|276|0|16|117|1|16|141|0|16|89|1|16|");
                break;
            }
            case 2: {
                this.init("My Way|1|1|1|-362|1078|0|12|86|1|12|503|0|21|128|1|21|494|0|12|84|1|12|255|0|21|66|1|21|245|0|19|76|1|19|254|0|21|99|1|21|504|0|12|94|1|12|255|0|21|77|1|21|243|0|19|77|1|19|246|0|21|119|1|21|523|0|19|86|1|19|223|0|21|77|1|21|245|0|19|65|1|19|243|0|19|67|1|19|254|0|18|99|1|18|375|0|14|105|1|14|424|0|22|154|1|22|459|0|21|76|1|21|256|0|22|55|1|22|254|0|21|67|1|21|243|0|22|67|1|22|502|0|14|75|1|14|277|0|22|65|1|22|234|0|21|66|1|21|279|0|22|46|1|22|487|0|19|65|1|19|277|0|24|54|1|24|266|0|19|75|1|19|257|0|22|70|1|22|262|0|21|65|1|21|515|0|17|62|1|17|534|0|24|118|1|24|491|0|23|76|1|23|223|0|24|65|1|24|268|0|23|76|1|23|255|0|24|87|1|24|480|0|26|65|1|26|267|0|21|55|1|21|243|0|24|56|1|24|355|0|22|82|1|22|573|0|21|59|1|21|235|0|22|65|1|22|277|0|21|55|1|21|284|0|24|51|1|24|503|0|22|82|1|22|536|0|12|53|1|12|425|0|21|109|1|21|480|0|12|55|1|12|265|0|22|65|1|22|249|0|21|84|1|21|290|0|19|62|1|19|537|0|16|84|1|16|222|0|17|87|1|17|236|0|19|107|1|19|233|0|19|66|1|19|441|0|21|99|1|21|228|0|19|56|1|19|244|0|17|50|1|17|702|0|21|91|1|21|192|0|22|96|1|22|260|0|24|83|1|24|226|0|24|97|1|24|360|0|26|77|1|26|239|0|24|81|1|24|226|0|23|74|1|23|257|0|24|106|1|24|458|0|22|77|1|22|234|0|24|76|1|24|240|0|26|73|1|26|267|0|26|62|1|26|329|0|27|77|1|27|270|0|26|61|1|26|224|0|24|65|1|24|257|0|26|72|2|-3|38|2|-7|5|2|-10|0|2|-11|53|2|-20|4|2|-21|0|2|-15|46|2|-18|6|2|-9|0|2|-21|47|2|-20|5|2|-11|0|2|-21|47|2|-22|4|2|-10|1|2|-11|44|2|-9|4|2|-13|0|2|-5|0|2|-5|61|2|-4|0|2|-8|0|2|-3|0|2|-3|54|1|26|202|0|26|96|1|26|194|0|28|75|1|28|234|0|29|96|1|29|214|0|29|85|1|29|366|0|26|73|1|26|246|0|29|76|1|29|223|0|26|87|1|26|233|0|28|130|1|28|430|0|28|94|1|28|203|0|29|85|1|29|230|0|31|102|1|31|235|0|31|96|1|31|391|0|33|71|1|33|281|0|28|70|1|28|227|0|31|105|1|31|250|0|29|188|1|29|441|0|26|115|1|26|182|0|28|107|1|28|225|0|29|128|1|29|208|0|29|134|1|29|390|0|26|91|1|26|225|0|29|86|1|29|225|0|26|97|1|26|234|0|28|128|1|28|465|0|28|104|1|28|178|0|29|97|1|29|235|0|31|87|1|31|247|0|31|84|1|31|377|0|33|72|1|33|227|0|31|67|1|31|199|0|29|84|1|29|");
                break;
            }
            default: {
                this.borrar();
            }
        }
    }

    public void grabarEvento(int evento, int dato) {
        if (this.indice < this.dim) {
            this.espaciado[this.indice] = (int)(System.currentTimeMillis() - this.tiempo);
            this.evento[this.indice] = evento;
            this.dato[this.indice] = dato;
            ++this.indice;
            this.longitud = this.indice;
        } else {
            this.parar();
        }
        this.tiempo = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.longitud > 0) {
            sb.append(this.titulo.replace('|', ' ')).append("|");
            sb.append(this.instrumento).append("|");
            sb.append(this.numTeclados).append("|");
            sb.append(this.zoom).append("|");
            sb.append(this.offset).append("|");
            int i = 0;
            while (i < this.longitud) {
                sb.append(this.espaciado[i]).append("|");
                sb.append(this.evento[i]).append("|");
                sb.append(this.dato[i]).append("|");
                ++i;
            }
        } else {
            sb.append(this.titulo.replace('|', ' '));
        }
        return sb.toString();
    }

    public void run() {
        this.tiempo = System.currentTimeMillis();
        long tiempo_repaint = 0L;
        while (this.indice < this.longitud && this.reproduciendo) {
            while (System.currentTimeMillis() - this.tiempo < (long)(this.espaciado[this.indice] * 4 / (this.piano.getVelocidad() + 1)) && this.reproduciendo) {
            }
            if (this.reproduciendo) {
                this.tiempo = System.currentTimeMillis();
                switch (this.evento[this.indice]) {
                    case 0: {
                        this.piano.getTeclado().activarTecla(this.dato[this.indice]);
                        break;
                    }
                    case 1: {
                        this.piano.getTeclado().desactivarTecla(this.dato[this.indice]);
                        break;
                    }
                    case 2: {
                        if (this.piano.getModo() == 1) break;
                        this.piano.getTeclado().setOffset(this.piano.getTeclado().getOffset() + this.dato[this.indice]);
                        break;
                    }
                }
                if (this.piano.getModo() != 1 && ((tiempo_repaint += (long)this.espaciado[this.indice]) > 100L || this.indice + 1 < this.longitud && tiempo_repaint + (long)this.espaciado[this.indice + 1] > 100L)) {
                    this.piano.getTeclado().repaint();
                    this.piano.getTeclado().serviceRepaints();
                    tiempo_repaint = 0L;
                }
            }
            ++this.indice;
            if (this.indice != this.longitud || !this.piano.repeticion()) continue;
            this.indice = 0;
            if (this.piano.getModo() == 1) continue;
            this.piano.getTeclado().setOffset(this.offset);
        }
        this.parar();
    }
}

