/*
 * Decompiled with CFR 0.152.
 */
package multipacman;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import multipacman.PacmanMIDlet;
import multipacman.network.ChoosePlayer;
import multipacman.util.Observable;
import multipacman.util.Observer;

public class ChoosePlayerCanvas
extends Canvas
implements Observer {
    private Vector maps = new Vector();
    private int currentMap = 1;
    private int selected = 0;
    private boolean server = false;
    private int menuElements = 5;
    private int[] menuElement = new int[8];
    private static final int TEXT_VSPACE = 15;
    private static final int IMAGE_VSPACE = 20;
    private ChoosePlayer choosePlayer;
    private Image[] imageList = new Image[7];
    private static final String[] NAMES = new String[]{"Pacman", "Blinky", "Pinky", "Inky", "Clyde"};
    private static int[] actorMapping = new int[]{4, 1, 2, 3, 0};
    private static final int IMAGE_DISABLED = 6;
    private int selectedActor = -1;
    private static final int MENU_MAP = 0;
    private static final int MENU_START = 1;
    private static final int MENU_CANCEL = 2;
    private static final int MENU_PACMAN = 3;
    private static final int MENU_BLINKY = 4;
    private static final int MENU_PINKY = 5;
    private static final int MENU_INKY = 6;
    private static final int MENU_CLYDE = 7;

    public ChoosePlayerCanvas(ChoosePlayer choosePlayer) {
        this.choosePlayer = choosePlayer;
        this.setFullScreenMode(true);
        for (int i = 0; i < 7; ++i) {
            this.imageList[i] = Image.createImage((Image)PacmanMIDlet.createImage("/res/bigghost.png"), (int)(i * 14), (int)0, (int)14, (int)14, (int)0);
        }
        this.server = choosePlayer.isServer();
        InputStream is = null;
        int nr = 1;
        do {
            String fullPath = "/map/" + nr + ".map";
            is = this.getClass().getResourceAsStream(fullPath);
            DataInputStream dis = new DataInputStream(is);
            if (is != null) {
                StringBuffer sb = new StringBuffer();
                try {
                    int ch;
                    while ((ch = is.read()) != 10) {
                        sb.append((char)ch);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.maps.addElement(sb.toString());
            }
            ++nr;
        } while (is != null);
    }

    protected void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(0);
        g.fillRect(0, 0, width, height);
        g.setColor(0xFFFFFF);
        g.setFont(Font.getFont((int)64, (int)1, (int)0));
        g.drawString("Multiplayer", width / 2, 0, 17);
        g.setFont(null);
        int currentHeight = 25;
        int currentItem = 0;
        this.currentMap = this.choosePlayer.getSelectedMap();
        if (this.server) {
            this.menuElement[currentItem] = 0;
            if (this.selected == currentItem++) {
                g.setColor(0xAAAAAA);
                g.fillRect(0, currentHeight, width, 18);
                g.setColor(0);
                g.setFont(Font.getFont((int)64, (int)1, (int)0));
                g.drawString((this.currentMap == 1 ? "" : "<<< ") + this.maps.elementAt(this.currentMap - 1) + (this.currentMap == this.maps.size() ? "" : " >>>"), width / 2, currentHeight, 17);
                g.setFont(null);
            } else {
                g.drawString((String)this.maps.elementAt(this.currentMap - 1), width / 2, currentHeight, 17);
            }
        } else {
            g.drawString((String)this.maps.elementAt(this.currentMap - 1), width / 2, currentHeight, 17);
        }
        currentHeight += 15;
        currentHeight += 15;
        int[] actorList = this.choosePlayer.getActorList();
        for (int i = 0; i < 5; ++i) {
            this.menuElement[currentItem] = 3 + i;
            if (this.selected == currentItem++) {
                g.setColor(0xAAAAAA);
                g.fillRect(0, currentHeight - 2, width, 18);
                g.setFont(Font.getFont((int)64, (int)1, (int)0));
                g.setColor(0);
            } else {
                g.setColor(0xFFFFFF);
            }
            g.drawString(NAMES[i], 30, currentHeight, 20);
            g.setFont(null);
            if (actorList[actorMapping[i]] != -1) {
                if (this.selectedActor == actorMapping[i]) {
                    g.setColor(0xFFFFFF);
                    g.drawRect(0, currentHeight - 2, width - 1, 18);
                    g.drawImage(this.imageList[i], 10, currentHeight, 20);
                } else {
                    g.drawImage(i == 0 ? this.imageList[6] : this.imageList[5], 10, currentHeight, 20);
                }
                g.setColor(0x707070);
            } else {
                g.drawImage(this.imageList[i], 10, currentHeight, 20);
            }
            currentHeight += 20;
            g.setColor(0xFFFFFF);
        }
        if (this.server) {
            currentHeight = height - 30;
            this.menuElement[currentItem] = 1;
            if (this.selected == currentItem++) {
                g.setColor(0xAAAAAA);
                g.fillRect(0, currentHeight, width, 18);
                g.setFont(Font.getFont((int)64, (int)1, (int)0));
                g.setColor(0);
            }
            g.drawString("Start", width / 2, currentHeight, 17);
            g.setFont(null);
            g.setColor(0xFFFFFF);
        }
        currentHeight = height - 15;
        this.menuElement[currentItem] = 2;
        if (this.selected == currentItem++) {
            g.setColor(0xAAAAAA);
            g.fillRect(0, currentHeight, width, 18);
            g.setFont(Font.getFont((int)64, (int)1, (int)0));
            g.setColor(0);
        }
        g.drawString("Cancel", width / 2, currentHeight, 17);
        g.setFont(null);
        g.setColor(0xFFFFFF);
        this.menuElements = currentItem;
    }

    public boolean isEnable(int type) {
        int[] actorList = this.choosePlayer.getActorList();
        return actorList[type] == -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void keyPressed(int keyCode) {
        int g = this.getGameAction(keyCode);
        block0 : switch (g) {
            case 1: {
                if (this.selected <= 0) break;
                --this.selected;
                break;
            }
            case 6: {
                if (this.selected >= this.menuElements - 1) break;
                ++this.selected;
                break;
            }
            case 2: {
                switch (this.menuElement[this.selected]) {
                    case 0: {
                        if (this.server && this.currentMap > 1) {
                            this.choosePlayer.selectMap(--this.currentMap);
                            break;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (this.menuElement[this.selected]) {
                    case 0: {
                        if (this.server && this.currentMap < this.maps.size()) {
                            this.choosePlayer.selectMap(++this.currentMap);
                            break;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (this.menuElement[this.selected]) {
                    case 1: {
                        this.choosePlayer.startGame();
                        break;
                    }
                    case 2: {
                        this.choosePlayer.cancel();
                        break;
                    }
                    case 3: {
                        if (this.isEnable(4)) {
                            this.selectedActor = 4;
                            this.choosePlayer.choose(4);
                            break;
                        }
                        if (this.selectedActor != 4) break;
                        this.selectedActor = -1;
                        this.choosePlayer.dechoose();
                        break;
                    }
                    case 4: {
                        if (this.isEnable(1)) {
                            this.selectedActor = 1;
                            this.choosePlayer.choose(1);
                            break;
                        }
                        if (this.selectedActor != 1) break;
                        this.selectedActor = -1;
                        this.choosePlayer.dechoose();
                        break;
                    }
                    case 5: {
                        if (this.isEnable(2)) {
                            this.selectedActor = 2;
                            this.choosePlayer.choose(2);
                            break;
                        }
                        if (this.selectedActor != 2) break;
                        this.selectedActor = -1;
                        this.choosePlayer.dechoose();
                        break;
                    }
                    case 6: {
                        if (this.isEnable(3)) {
                            this.selectedActor = 3;
                            this.choosePlayer.choose(3);
                            break;
                        }
                        if (this.selectedActor != 3) break;
                        this.selectedActor = -1;
                        this.choosePlayer.dechoose();
                        break;
                    }
                    case 7: {
                        if (this.isEnable(0)) {
                            this.selectedActor = 0;
                            this.choosePlayer.choose(0);
                            break;
                        }
                        if (this.selectedActor != 0) break;
                        this.selectedActor = -1;
                        this.choosePlayer.dechoose();
                    }
                }
                break;
            }
        }
        this.repaint();
    }

    public void doUpdate(Observable o, Object arg) {
        this.repaint();
    }
}

