/*
 * Decompiled with CFR 0.152.
 */
package multipacman;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import multipacman.PacmanMIDlet;

class PacmanGameOver
extends Canvas {
    private final PacmanMIDlet midlet;
    private boolean wasHighScore;
    private int score;
    private int highScore;

    PacmanGameOver(PacmanMIDlet midlet, int score) {
        this.midlet = midlet;
        this.score = score;
        this.setFullScreenMode(true);
        if (midlet.checkHighScore(this.score)) {
            this.wasHighScore = true;
            this.highScore = this.score;
        } else {
            this.wasHighScore = false;
            this.highScore = midlet.getHighScore();
        }
        midlet.flashBacklight(1000);
    }

    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(0);
        g.fillRect(0, 0, width, height);
        g.setFont(Font.getFont((int)64, (int)1, (int)16));
        int centerX = width / 2;
        int centerY = height / 2;
        g.setColor(0xFFFF00);
        this.drawText(g, centerX, centerY - 1);
        this.drawText(g, centerX, centerY + 1);
        this.drawText(g, centerX - 1, centerY);
        this.drawText(g, centerX + 1, centerY);
        g.setColor(0);
        this.drawText(g, centerX, centerY);
    }

    private void drawText(Graphics g, int centerX, int centerY) {
        int fontHeight = g.getFont().getHeight();
        int textHeight = 3 * fontHeight;
        int topY = centerY - textHeight / 2;
        g.drawString("GAME OVER", centerX, topY, 17);
        g.drawString("Score: " + Integer.toString(this.score), centerX, topY + fontHeight, 17);
        g.drawString(this.wasHighScore ? "New High Score" : "Best Score: " + this.highScore, centerX, topY + 2 * fontHeight, 17);
    }

    public void keyPressed(int keyCode) {
        this.midlet.pacmanGameOverDone();
    }
}

