/*
 * Decompiled with CFR 0.152.
 */
package multipacman;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.bluetooth.ServiceRecord;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import multipacman.ChooseLevelMenu;
import multipacman.ChoosePlayerCanvas;
import multipacman.PacmanDevotement;
import multipacman.PacmanGameOver;
import multipacman.PacmanInstructions;
import multipacman.PacmanMenu;
import multipacman.PacmanScreen;
import multipacman.PacmanSetup;
import multipacman.ServerMenu;
import multipacman.game.Accelerometer;
import multipacman.game.World;
import multipacman.network.ChoosePlayer;
import multipacman.network.MultiplayerLayer;
import multipacman.network.NetworkManager;
import multipacman.network.PacketFactory;
import multipacman.network.bluetooth.BluetoothClient;
import multipacman.network.bluetooth.BluetoothDiscovery;
import multipacman.network.bluetooth.BluetoothServer;

public class PacmanMIDlet
extends MIDlet {
    private static final String RS_NAME = "HIGHSCORE";
    private final int RS_ID;
    public static boolean vibrationEnabled = true;
    private Display display;
    private ChoosePlayer choosePlayer;
    private ChoosePlayerCanvas choosePlayerMenu;
    private ChooseLevelMenu chooseLevelMenu;
    private PacmanMenu pacmanMenu;
    private World world;
    private static final Random random = new Random();
    private boolean hasHighScore = false;
    private int highScore;
    private MultiplayerLayer multiplayerLayer = null;
    private NetworkManager networkManager = null;
    private PacketFactory packetFactory = null;
    private boolean multiplayerMode = false;
    private Accelerometer a;
    private PacmanSetup pacmanSetup;

    public PacmanMIDlet() {
        this.RS_ID = 1;
    }

    public void startApp() {
        if (this.display == null) {
            this.a = new Accelerometer();
            this.world = new World(this, this.a);
            this.display = Display.getDisplay((MIDlet)this);
            this.readHighScore();
            this.display.setCurrent((Displayable)new PacmanScreen(this));
            this.chooseLevelMenu = new ChooseLevelMenu(this);
            this.init();
        }
        if (this.display.getCurrent() == this.world) {
            this.world.start();
        }
    }

    public void pauseApp() {
        if (this.display.getCurrent() == this.world) {
            this.world.stop();
        }
    }

    public void destroyApp(boolean unconditional) {
        if (this.world != null) {
            this.world.stop();
            this.a.disconnect();
        }
        this.checkHighScore(this.getScore());
    }

    private void quit() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    private void init() {
        this.pacmanMenu = new PacmanMenu(this);
        this.pacmanSetup = new PacmanSetup(this);
        this.pacmanSetup.loadConfig();
    }

    void pacmanDevotement() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)new PacmanDevotement(this));
    }

    void pacmanScreenDone() {
        this.init();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pacmanMenu);
    }

    void pacmanMenuContinue() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.world);
        this.world.start();
    }

    void pacmanMenuNewGame() {
        this.world.init();
        this.display.setCurrent((Displayable)this.chooseLevelMenu);
    }

    void startNewGame() {
        this.world.setActor(4);
        this.multiplayerMode = false;
        this.display.setCurrent((Displayable)this.world);
        this.world.start();
    }

    public void pacmanMultiplayerClient(int player, int[] selectedPlayer, int map) {
        this.multiplayerMode = true;
        this.world.init();
        this.world.loadMap(map + ".map");
        this.world.setActor(player);
        this.display.setCurrent((Displayable)this.world);
        this.multiplayerLayer.startClient(player, selectedPlayer);
        System.gc();
        this.world.start();
    }

    public void pacmanMultiplayerServer(int player, int[] selectedPlayer, int map) {
        this.multiplayerMode = true;
        this.world.init();
        this.world.loadMap(map + ".map");
        this.world.setActor(player);
        this.display.setCurrent((Displayable)this.world);
        this.multiplayerLayer.startServer(player, selectedPlayer);
        System.gc();
        this.world.start();
    }

    public void pacmanMenuInstructions() {
        this.display.setCurrent((Displayable)new PacmanInstructions(this));
    }

    public void pacmanMenuHighScore() {
        this.display.setCurrent((Displayable)new PacmanScreen(this));
    }

    public void pacmanMenuQuit() {
        this.quit();
    }

    public void pacmanCanvasMenu() {
        this.world.stop();
        this.pacmanMenu.showContinueOption(false);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pacmanMenu);
    }

    public void pacmanCanvasGameOver(int score) {
        this.world.stop();
        if (this.multiplayerMode) {
            this.multiplayerLayer.stop();
            this.display.setCurrent((Displayable)this.choosePlayerMenu);
        } else {
            this.pacmanMenu.showContinueOption(false);
            this.display.setCurrent((Displayable)new PacmanGameOver(this, score));
        }
    }

    public void pacmanGameOverDone() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pacmanMenu);
    }

    public void pacmanMenuBack() {
        this.display.setCurrent((Displayable)this.pacmanMenu);
    }

    public void pacmanMenuNewServer() {
        this.packetFactory = new PacketFactory();
        this.networkManager = new BluetoothServer();
        this.multiplayerLayer = new MultiplayerLayer(this, this.networkManager, this.world);
        this.packetFactory.setControllerList(this.world.getController());
        this.packetFactory.setField(this.world.getField());
        this.choosePlayer = new ChoosePlayer(this, this.networkManager, true);
        this.choosePlayerMenu = new ChoosePlayerCanvas(this.choosePlayer);
        this.networkManager.setNextListener(this.multiplayerLayer);
        this.multiplayerLayer.setNextListener(this.choosePlayer);
        this.networkManager.addConnectionListener(this.choosePlayer);
        this.networkManager.addConnectionListener(this.multiplayerLayer);
        this.choosePlayer.addObserver(this.choosePlayerMenu);
        this.display.setCurrent((Displayable)this.choosePlayerMenu);
    }

    public void pacmanMenuJoinServer() {
        this.packetFactory = new PacketFactory();
        BluetoothDiscovery discovery = new BluetoothDiscovery(this);
        ServerMenu serverMenu = new ServerMenu(this, discovery);
        this.display.setCurrent((Displayable)serverMenu);
        discovery.addObserver(serverMenu);
        discovery.start();
    }

    void pacmanNewMultiplayerClient(ServiceRecord sr) {
        this.networkManager = new BluetoothClient(sr);
        this.multiplayerLayer = new MultiplayerLayer(this, this.networkManager, this.world);
        this.packetFactory.setControllerList(this.world.getController());
        this.packetFactory.setField(this.world.getField());
        this.choosePlayer = new ChoosePlayer(this, this.networkManager, false);
        this.choosePlayerMenu = new ChoosePlayerCanvas(this.choosePlayer);
        this.networkManager.setNextListener(this.multiplayerLayer);
        this.multiplayerLayer.setNextListener(this.choosePlayer);
        this.networkManager.addConnectionListener(this.choosePlayer);
        this.networkManager.addConnectionListener(this.multiplayerLayer);
        this.choosePlayer.addObserver(this.choosePlayerMenu);
        this.display.setCurrent((Displayable)this.choosePlayerMenu);
    }

    void loadLevel(String filename) {
        this.world.loadMap(filename);
    }

    public static Image createImage(String filename) {
        Image image = null;
        try {
            image = Image.createImage((String)filename);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    public static int random(int size) {
        return (random.nextInt() & Integer.MAX_VALUE) % size;
    }

    public void flashBacklight(int millis) {
        Display.getDisplay((MIDlet)this).flashBacklight(millis);
    }

    public void vibrate(int millis) {
        Display.getDisplay((MIDlet)this).vibrate(millis);
    }

    int getScore() {
        if (this.world != null) {
            return this.world.getScore();
        }
        return -1;
    }

    public int getHighScore() {
        return this.hasHighScore ? this.highScore : -1;
    }

    public boolean checkHighScore(int score) {
        if (!this.hasHighScore || score > this.highScore) {
            this.hasHighScore = true;
            this.highScore = score;
            this.writeHighScore();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHighScore() {
        this.hasHighScore = false;
        RecordStore rs = null;
        ByteArrayInputStream bais = null;
        FilterInputStream dis = null;
        try {
            rs = RecordStore.openRecordStore((String)RS_NAME, (boolean)false);
            byte[] data = rs.getRecord(1);
            bais = new ByteArrayInputStream(data);
            dis = new DataInputStream(bais);
            this.highScore = ((DataInputStream)dis).readInt();
            this.hasHighScore = true;
        }
        catch (IOException ex) {
        }
        catch (RecordStoreException ex) {
            this.highScore = 0;
            this.writeHighScore();
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ex) {}
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException ex) {}
            }
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (RecordStoreException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHighScore() {
        RecordStore rs = null;
        ByteArrayOutputStream baos = null;
        FilterOutputStream dos = null;
        try {
            rs = RecordStore.openRecordStore((String)RS_NAME, (boolean)true);
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            ((DataOutputStream)dos).writeInt(this.highScore);
            byte[] data = baos.toByteArray();
            if (rs.getNumRecords() == 0) {
                rs.addRecord(data, 0, data.length);
            } else {
                rs.setRecord(1, data, 0, data.length);
            }
        }
        catch (IOException ex) {
        }
        catch (RecordStoreException ex) {
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException ex) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException ex) {}
            }
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (RecordStoreException ex) {}
            }
        }
    }

    public void pacmanMenuSetup() {
        this.display.setCurrent((Displayable)this.pacmanSetup);
    }

    public void connectionError() {
        if (this.world != null) {
            this.world.stop();
            this.multiplayerLayer.stop();
        }
        this.networkManager.stop();
        Alert alert = new Alert("Info", "Connection has been lost", null, null);
        this.pacmanMenu.showContinueOption(false);
        this.display.setCurrent(alert, (Displayable)this.pacmanMenu);
    }
}

