/*
 * Decompiled with CFR 0.152.
 */
package multipacman;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import multipacman.PacmanMIDlet;
import multipacman.game.Sound;

class PacmanSetup
extends Form
implements CommandListener {
    private final PacmanMIDlet midlet;
    private final Command backCommand;
    private final Command okCommand;
    private ChoiceGroup group;
    private final String MUSIC;
    private final String FX;
    private final String VIBRA;
    private final String[] entrys = new String[]{"Music", "Sound FX", "Vibration"};
    private final String RS_NAME;
    private final int RS_ID;

    PacmanSetup(PacmanMIDlet midlet) {
        super("Setup");
        this.MUSIC = "Music";
        this.FX = "Sound FX";
        this.VIBRA = "Vibration";
        this.RS_NAME = "SETUP";
        this.RS_ID = 1;
        this.midlet = midlet;
        this.group = new ChoiceGroup("Setup", 2);
        for (int i = 0; i < this.entrys.length; ++i) {
            this.group.append(this.entrys[i], null);
        }
        this.append((Item)this.group);
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.okCommand = new Command("OK", 4, 1);
        this.addCommand(this.okCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            this.midlet.pacmanMenuBack();
        } else if (c == this.okCommand) {
            this.activateSettings();
            this.saveConfig();
            this.midlet.pacmanMenuBack();
        }
    }

    private void activateSettings() {
        for (int i = 0; i < this.entrys.length; ++i) {
            if (this.entrys[i].equals("Music")) {
                Sound.musicEnabled = this.group.isSelected(i);
            }
            if (this.entrys[i].equals("Sound FX")) {
                Sound.fxEnabled = this.group.isSelected(i);
            }
            if (!this.entrys[i].equals("Vibration")) continue;
            PacmanMIDlet.vibrationEnabled = this.group.isSelected(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig() {
        RecordStore rs = null;
        ByteArrayInputStream bais = null;
        FilterInputStream dis = null;
        try {
            rs = RecordStore.openRecordStore((String)"SETUP", (boolean)false);
            byte[] data = rs.getRecord(1);
            bais = new ByteArrayInputStream(data);
            dis = new DataInputStream(bais);
            for (int i = 0; i < this.entrys.length; ++i) {
                boolean b = ((DataInputStream)dis).readBoolean();
                this.group.setSelectedIndex(i, b);
            }
            this.activateSettings();
        }
        catch (IOException ex) {
        }
        catch (RecordStoreException ex) {
            this.saveConfig();
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ex) {}
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException ex) {}
            }
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (RecordStoreException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() {
        ByteArrayOutputStream baos = null;
        FilterOutputStream dos = null;
        byte[] data = new byte[]{};
        try {
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            for (int i = 0; i < this.entrys.length; ++i) {
                ((DataOutputStream)dos).writeBoolean(this.group.isSelected(i));
            }
            baos.flush();
            data = baos.toByteArray();
        }
        catch (IOException ex) {
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException ex) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException ex) {}
            }
        }
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)"SETUP", (boolean)true);
            if (rs.getNumRecords() == 0) {
                rs.addRecord(data, 0, data.length);
            } else {
                rs.setRecord(1, data, 0, data.length);
            }
        }
        catch (RecordStoreException e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (RecordStoreException e) {}
            }
        }
    }
}

