/*
 * Decompiled with CFR 0.152.
 */
package multipacman.game;

import multipacman.PacmanMIDlet;
import multipacman.game.Actor;
import multipacman.game.ControllerPacman;
import multipacman.game.Field;
import multipacman.game.World;

class ActorPacman
extends Actor {
    static final int VIBRATION_MILLIS = 200;
    private final Field field;
    private int[][] animations = new int[][]{{0}, {1, 2, 3, 4, 3, 2}, {4, 4, 3, 3, 2, 2, 1, 1, 5, 5, 6, 6, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8}};
    private static final int STAND = 0;
    private static final int RUN = 1;
    private static final int DIE = 2;
    private int currentDirection = 1;
    int eaten;
    private boolean isMoving = true;
    private boolean animatingDeath = false;
    private boolean animatingRunning = true;
    public int mapX = 0;
    public int mapY = 0;

    ActorPacman(World canvas, ControllerPacman controller) {
        super(controller, PacmanMIDlet.createImage("/res/pacman.png"), 8, 8);
        this.defineCollisionRectangle(2, 2, 4, 4);
        this.defineReferencePixel(4, 4);
        this.field = canvas.getField();
        this.canvas = canvas;
        this.reset();
        controller.setActor(this);
    }

    protected void handleJump() {
        int refPixelX = this.getRefPixelX();
        int refPixelY = this.getRefPixelY();
        if (refPixelX <= 7) {
            this.setRefPixelPosition(this.field.getWidth() - 9, refPixelY);
        }
        if (refPixelX >= this.field.getWidth() - 7) {
            this.setRefPixelPosition(9, refPixelY);
        }
    }

    public int[] getPosition() {
        int[] pos = new int[]{this.getX(), this.getY()};
        return pos;
    }

    public void setDirection(int direction) {
        this.currentDirection = direction;
    }

    public int getDirection() {
        return this.currentDirection;
    }

    private void animateDeath() {
        if (!this.animatingDeath) {
            this.setFrameSequence(this.animations[2]);
            this.animatingDeath = true;
        }
        if (this.getFrame() < this.getFrameSequenceLength() - 2) {
            this.nextFrame();
        } else {
            ((ControllerPacman)this.controller).setAlive(true);
            this.animatingDeath = false;
            this.setRefPixelPosition(94, 124);
            this.setFrameSequence(this.animations[1]);
        }
    }

    public void animate() {
        if (!this.isAlive()) {
            this.animateDeath();
        } else if (this.isMoving()) {
            this.advanceRunningAnimation();
        } else {
            this.setStandingAnimation();
        }
    }

    protected void advanceRunningAnimation() {
        this.rotatePacman();
        if (!this.animatingRunning) {
            this.animatingRunning = true;
            this.setFrameSequence(this.animations[1]);
        }
        this.nextFrame();
    }

    protected void setStandingAnimation() {
        this.rotatePacman();
        this.setFrame(this.animations[0][0]);
        this.animatingRunning = false;
    }

    private void rotatePacman() {
        if (this.currentDirection == 0) {
            this.setTransform(5);
        } else if (this.currentDirection == 3) {
            this.setTransform(3);
        } else if (this.currentDirection == 2) {
            this.setTransform(6);
        } else {
            this.setTransform(0);
        }
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public void setMoving(boolean isMoving) {
        this.isMoving = isMoving;
    }

    protected void reset() {
        this.controller.setNextDirection(1);
        this.setAlive(true);
        this.isMoving = true;
        this.eaten = 1;
        this.setFrameSequence(this.animations[1]);
    }
}

