/*
 * Decompiled with CFR 0.152.
 */
package multipacman.game;

import multipacman.game.Actor;
import multipacman.game.Field;
import multipacman.util.Observable;

public abstract class Controller
extends Observable {
    public static final int MODE_AI = 0;
    public static final int MODE_USER = 1;
    public static final int MODE_REMOTE = 2;
    protected Field field;
    protected int mode = 0;
    protected final int STEP;
    protected int currentDirection = 1;

    Controller(Field field) {
        this.STEP = 2;
        this.field = field;
    }

    public abstract void setActor(Actor var1);

    public void setAIMode(int mode) {
        this.mode = mode;
    }

    public int getAIMode() {
        return this.mode;
    }

    public abstract void makeMove();

    public abstract void setPosition(int[] var1);

    public abstract void setNextDirection(int var1);

    public abstract int[] getPosition();

    public abstract int getDirection();

    public abstract int getNextDirection();

    public abstract byte getId();

    public abstract boolean isAlive();

    public abstract void onCollision(Controller var1);

    public abstract void setAlive(boolean var1);

    public int[] getPredictedPosition(int[] position, int[] referencePixel, int steps) {
        if (steps == 0 || !this.canWalk(this.currentDirection, position, referencePixel)) {
            return position;
        }
        switch (this.currentDirection) {
            case 0: {
                position[1] = position[1] - 2;
                referencePixel[1] = referencePixel[1] - 2;
                break;
            }
            case 1: {
                position[0] = position[0] - 2;
                referencePixel[0] = referencePixel[0] - 2;
                break;
            }
            case 2: {
                position[1] = position[1] + 2;
                referencePixel[1] = referencePixel[1] + 2;
                break;
            }
            case 3: {
                position[0] = position[0] + 2;
                referencePixel[0] = referencePixel[0] + 2;
            }
        }
        return this.getPredictedPosition(position, referencePixel, steps - 1);
    }

    protected abstract boolean canWalk(int var1, int[] var2, int[] var3);
}

