/*
 * Decompiled with CFR 0.152.
 */
package multipacman.game;

import multipacman.PacmanMIDlet;
import multipacman.game.Actor;
import multipacman.game.ActorGhost;
import multipacman.game.Controller;
import multipacman.game.Field;
import multipacman.game.World;

public class ControllerGhost
extends Controller {
    private int nextDirection = 1;
    private int[] inputPosition = new int[2];
    private boolean jumpToPosition = false;
    private World world;
    private ActorGhost ghost;
    private int magicStep = 2;

    ControllerGhost(Field field) {
        super(field);
    }

    public void setActor(Actor actor) {
        if (actor instanceof ActorGhost) {
            this.setGhost((ActorGhost)actor);
        }
    }

    public void setGhost(ActorGhost actor) {
        this.ghost = actor;
        this.world = this.ghost.getCanvas();
        this.inputPosition[0] = actor.getX();
        this.inputPosition[1] = actor.getY();
    }

    public void setPosition(int[] pos) {
        this.inputPosition = pos;
        this.jumpToPosition = true;
    }

    public int[] getPosition() {
        return this.ghost.getPosition();
    }

    public int getNextDirection() {
        return this.nextDirection;
    }

    public int getDirection() {
        return this.currentDirection;
    }

    public void setNextDirection(int direction) {
        this.nextDirection = direction;
        this.setChanged();
        this.notifyObservers();
    }

    public byte getId() {
        return this.ghost.getId();
    }

    public boolean isAlive() {
        return this.ghost.isAlive();
    }

    public void setAlive(boolean isAlive) {
        this.ghost.setAlive(isAlive);
    }

    public void makeMove() {
        if (this.world.isInMagicMode() && this.magicStep == 2) {
            this.magicStep = 1;
        } else if (this.magicStep == 1) {
            this.magicStep = 2;
        }
        if (!this.ghost.isAlive() && this.ghost.frameCount++ > 50 && !this.world.isInMagicMode()) {
            this.ghost.reset();
        }
        switch (this.mode) {
            case 0: {
                this.makeAIMove();
                break;
            }
            case 1: {
                if (this.jumpToPosition) {
                    this.ghost.setPosition(this.inputPosition);
                    this.jumpToPosition = false;
                    break;
                }
                this.tryAndSetDirection(this.nextDirection);
                break;
            }
            case 2: {
                if (this.jumpToPosition) {
                    this.ghost.setPosition(this.inputPosition);
                    this.jumpToPosition = false;
                    break;
                }
                this.tryAndSetDirection(this.nextDirection);
            }
        }
        this.ghost.animate();
    }

    private boolean tryDirection(int direction) {
        int[] possibleDirections;
        if ((direction + 2) % 4 == this.currentDirection && (this.tryDirection((possibleDirections = new int[]{this.currentDirection, (direction + 1) % 4, (direction + 3) % 4})[0]) || this.tryDirection(possibleDirections[1]) || this.tryDirection(possibleDirections[2]))) {
            return false;
        }
        int[] position = this.ghost.getPosition();
        int[] refPixel = new int[]{this.ghost.getRefPixelX(), this.ghost.getRefPixelY()};
        return this.canWalk(direction, position, refPixel);
    }

    private boolean tryAndSetDirection(int wantedDirection) {
        if (this.tryDirection(wantedDirection)) {
            this.setPositionForDirection(wantedDirection);
            return true;
        }
        if (this.tryDirection(this.ghost.getDirection())) {
            this.setPositionForDirection(this.ghost.getDirection());
            return true;
        }
        for (int d = wantedDirection; d < wantedDirection + 4; ++d) {
            int direction = d % 4;
            if (direction == wantedDirection || direction == this.ghost.getDirection() || !this.tryDirection(direction)) continue;
            this.setPositionForDirection(direction);
            return true;
        }
        return false;
    }

    private void setPositionForDirection(int direction) {
        int[] position = this.ghost.getPosition();
        switch (direction) {
            case 0: {
                this.currentDirection = direction;
                this.ghost.setDirection(this.currentDirection);
                position[1] = position[1] - this.magicStep;
                break;
            }
            case 1: {
                this.currentDirection = direction;
                this.ghost.setDirection(this.currentDirection);
                position[0] = position[0] - this.magicStep;
                break;
            }
            case 2: {
                this.currentDirection = direction;
                this.ghost.setDirection(this.currentDirection);
                position[1] = position[1] + this.magicStep;
                break;
            }
            case 3: {
                this.currentDirection = direction;
                this.ghost.setDirection(this.currentDirection);
                position[0] = position[0] + this.magicStep;
            }
        }
        this.ghost.setPosition(position);
    }

    protected boolean canWalk(int direction, int[] position, int[] referencePixel) {
        int distance = 2;
        int[] size = new int[]{this.ghost.getWidth() + distance, this.ghost.getHeight() + distance};
        switch (direction) {
            case 0: {
                if (position[1] <= 0 || this.field.containsGhostImpassableArea(referencePixel[0], referencePixel[1] - 2, size[0], size[1])) break;
                return true;
            }
            case 1: {
                if (position[0] <= 0 || this.field.containsGhostImpassableArea(referencePixel[0] - 2, referencePixel[1], size[0], size[1])) break;
                return true;
            }
            case 2: {
                if (position[1] >= this.field.getHeight() || this.field.containsGhostImpassableArea(referencePixel[0], referencePixel[1] + 2, size[0], size[1])) break;
                return true;
            }
            case 3: {
                if (position[0] >= this.field.getWidth() || this.field.containsGhostImpassableArea(referencePixel[0] + 2, referencePixel[1], size[0], size[1])) break;
                return true;
            }
        }
        return false;
    }

    public void makeAIMove() {
        int[] myPos = new int[]{this.ghost.getRefPixelX() / 10, this.ghost.getRefPixelY() / 10};
        boolean tracked = this.trackPackman(myPos);
        int newDirection = this.currentDirection;
        if (tracked) {
            newDirection = this.findTrackingDirection();
        }
        int x = this.ghost.getRefPixelX();
        int y = this.ghost.getRefPixelY();
        if (x > 94 && x < 115 && y == 104) {
            newDirection = 0;
        }
        int random = 0;
        while (!this.tryDirection(newDirection)) {
            random = PacmanMIDlet.random(4);
            newDirection = (this.currentDirection + random) % 4;
        }
        this.currentDirection = newDirection;
        this.ghost.setPosition(this.getNewPositionAI());
        if (this.nextDirection != this.currentDirection) {
            this.nextDirection = this.currentDirection;
            this.setChanged();
            this.notifyObservers();
        }
    }

    private boolean trackPackman(int[] myPos) {
        return this.field.seePacman(myPos[0], myPos[1], this.world.getPacmanX(), this.world.getPacmanY()) && !this.world.isPacmanDead();
    }

    private int findTrackingDirection() {
        int dx = this.world.getPacmanX() - this.ghost.getX();
        int dy = this.world.getPacmanY() - this.ghost.getY();
        int direction = Math.abs(dy) > Math.abs(dx) ? (dy > 0 ? 2 : 0) : (dx > 0 ? 3 : 1);
        if (this.world.isInMagicMode() || !this.ghost.isAlive()) {
            direction = (direction + 2) % 4;
        }
        return direction;
    }

    private int[] getNewPositionAI() {
        int[] pos = new int[]{this.ghost.getX(), this.ghost.getY()};
        switch (this.currentDirection) {
            case 0: {
                pos[1] = pos[1] - this.magicStep;
                break;
            }
            case 1: {
                pos[0] = pos[0] - this.magicStep;
                break;
            }
            case 2: {
                pos[1] = pos[1] + this.magicStep;
                break;
            }
            case 3: {
                pos[0] = pos[0] + this.magicStep;
            }
        }
        return pos;
    }

    public void onCollision(Controller collisionObject) {
        if (this.world.isInMagicMode()) {
            this.ghost.setAlive(false);
            this.ghost.frameCount = 0;
            this.setChanged();
            this.notifyObservers(new Integer(0));
        }
    }
}

