/*
 * Decompiled with CFR 0.152.
 */
package multipacman.game;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.game.TiledLayer;
import multipacman.PacmanMIDlet;
import multipacman.util.Observable;

public class Field
extends Observable {
    private int widthInTiles = 0;
    private int heightInTiles = 0;
    private static final int TILE_WIDTH = 10;
    private static final int TILE_HEIGHT = 10;
    private static final int PACMAN = 1;
    private static final int GHOST = 2;
    private static int[][] magicPill = new int[][]{{14, 15}};
    private TiledLayer tiledLayer;
    private int tickCount = 0;
    private int pills;
    private static int[][] cellTiles;
    private static String currentMap;

    Field() {
        this.loadMap(currentMap);
    }

    public void loadMap(String filename) {
        currentMap = filename;
        String fullPath = "/map/" + filename;
        InputStream is = null;
        DataInputStream dis = null;
        Vector<String> lines = new Vector<String>();
        StringBuffer buffer = new StringBuffer();
        try {
            is = this.getClass().getResourceAsStream(fullPath);
            if (is != null) {
                dis = new DataInputStream(is);
                while (dis.available() > 0) {
                    char c = (char)dis.read();
                    if (c == '\n') {
                        lines.addElement(buffer.toString());
                        buffer.delete(0, buffer.capacity());
                        continue;
                    }
                    buffer.append(c);
                }
                is.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            this.parseLines(lines);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        this.init();
    }

    private void parseLines(Vector lines) {
        Vector<Integer> numbers = new Vector<Integer>();
        this.heightInTiles = lines.size() - 1;
        int lastIndex = ((String)lines.elementAt(1)).lastIndexOf(44);
        this.widthInTiles = lastIndex / 3 + 2;
        int[][] newMap = new int[this.heightInTiles][this.widthInTiles];
        for (int l = 0; l < this.heightInTiles; ++l) {
            String number;
            int currentIdx;
            String row = (String)lines.elementAt(l + 1);
            row = row.replace(',', ' ').trim();
            int startIdx = 0;
            while ((currentIdx = row.indexOf(32, startIdx)) != -1) {
                number = row.substring(startIdx, currentIdx).trim();
                if (number.length() > 0) {
                    numbers.addElement(new Integer(Integer.parseInt(number)));
                }
                startIdx = currentIdx + 1;
            }
            number = row.substring(startIdx, row.length()).trim();
            if (number.length() > 0) {
                numbers.addElement(new Integer(Integer.parseInt(number)));
            }
            for (int col = 0; col < this.widthInTiles; ++col) {
                int n;
                newMap[l][col] = n = ((Integer)numbers.elementAt(col)).intValue();
            }
            numbers.removeAllElements();
        }
        cellTiles = newMap;
        this.tiledLayer = new TiledLayer(this.widthInTiles, this.heightInTiles, PacmanMIDlet.createImage("/res/field.png"), 10, 10);
    }

    void init() {
        this.pills = 0;
        this.tiledLayer.createAnimatedTile(magicPill[0][0]);
        for (int row = 0; row < this.heightInTiles; ++row) {
            for (int column = 0; column < this.widthInTiles; ++column) {
                if (cellTiles[row][column] == 13 || cellTiles[row][column] == -1) {
                    ++this.pills;
                }
                this.tiledLayer.setCell(column, row, cellTiles[row][column]);
            }
        }
    }

    void tick() {
        int tickState = this.tickCount++ >> 1;
        this.tiledLayer.setAnimatedTile(-1, magicPill[0][tickState % 2]);
    }

    boolean containsPacmanImpassableArea(int x, int y, int width, int height) {
        return this.containsImpassableArea(x, y, width, height, 1);
    }

    public boolean containsGhostImpassableArea(int x, int y, int width, int height) {
        return this.containsImpassableArea(x, y, width, height, 2);
    }

    private boolean containsImpassableArea(int x, int y, int width, int height, int type) {
        int rowMin = (y - height / 2 + 1) / 10;
        int rowMax = (y + height / 2 - 1) / 10;
        int columnMin = (x - width / 2 + 1) / 10;
        int columnMax = (x + width / 2 - 1) / 10;
        rowMin = rowMin > 0 ? rowMin : 0;
        rowMax = rowMax < this.heightInTiles ? rowMax : this.heightInTiles - 1;
        columnMin = columnMin > 0 ? columnMin : 0;
        columnMax = columnMax < this.widthInTiles ? columnMax : this.widthInTiles - 1;
        int cellNumber = 1 == type ? 13 : 12;
        for (int row = rowMin; row <= rowMax; ++row) {
            for (int column = columnMin; column <= columnMax; ++column) {
                int cell = this.tiledLayer.getCell(column, row);
                if (cell >= cellNumber && cell <= 15 || cell <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean eatPill(int column, int row) {
        int cell = this.tiledLayer.getCell(column, row);
        if (cell == 13) {
            this.tiledLayer.setCell(column, row, 15);
            --this.pills;
            int[] pill = new int[]{column, row};
            this.setChanged();
            this.notifyObservers(pill);
            return true;
        }
        return false;
    }

    public boolean eatMagicPill(int column, int row) {
        int cell = this.tiledLayer.getCell(column, row);
        if (cell == -1) {
            this.tiledLayer.setCell(column, row, 15);
            --this.pills;
            int[] pill = new int[]{column, row};
            this.setChanged();
            this.notifyObservers(pill);
            return true;
        }
        return false;
    }

    int getPills() {
        return this.pills;
    }

    boolean seePacman(int x, int y, int x2, int y2) {
        int column = x;
        int row = y;
        int column2 = x2 / 10;
        int row2 = y2 / 10;
        if (row == row2) {
            int i;
            if (column2 < column) {
                i = column2;
                column2 = column;
                column = i;
            }
            if (column2 - column <= 1) {
                return true;
            }
            for (i = 1; i < column2 - column; ++i) {
                int cell = this.tiledLayer.getCell(column + i, row);
                if (cell >= 13 && cell <= 15 || cell <= 0) continue;
                return false;
            }
            return true;
        }
        if (column == column2) {
            int i;
            if (row2 < row) {
                i = row2;
                row2 = row;
                row = i;
            }
            if (row2 - row <= 1) {
                return true;
            }
            for (i = 1; i < row2 - row; ++i) {
                int cell = this.tiledLayer.getCell(column, row + i);
                if (cell >= 13 && cell <= 15 || cell <= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getWidth() {
        return this.tiledLayer.getWidth();
    }

    public int getHeight() {
        return this.tiledLayer.getHeight();
    }

    public TiledLayer getTiledLayer() {
        return this.tiledLayer;
    }

    static {
        currentMap = "1.map";
    }
}

