/*
 * Decompiled with CFR 0.152.
 */
package multipacman.network;

import java.util.Vector;
import multipacman.PacmanMIDlet;
import multipacman.network.CommandPacket;
import multipacman.network.ConnectionListener;
import multipacman.network.NetworkListener;
import multipacman.network.NetworkManager;
import multipacman.network.Packet;
import multipacman.network.PacketFactory;
import multipacman.network.bluetooth.BluetoothServer;
import multipacman.util.Observable;

public class ChoosePlayer
extends Observable
implements NetworkListener,
ConnectionListener {
    private final String COMMAND_START;
    private final String COMMAND_REQUEST;
    private final String COMMAND_ACK;
    private final String COMMAND_DISCONNECT;
    private final String COMMAND_LEVEL;
    private int selected = -1;
    private PacmanMIDlet midlet;
    private Vector observerList = new Vector();
    private PacketFactory packetFactory;
    private NetworkManager networkManager;
    private NetworkListener listener = null;
    private boolean server = false;
    private int map = 1;
    private int[] selectedPlayer = new int[]{-1, -1, -1, -1, -1};
    private int[] selectedActor = new int[]{-1, -1, -1, -1, -1};

    public ChoosePlayer(PacmanMIDlet midlet, NetworkManager networkManager, boolean server) {
        this.COMMAND_START = "START";
        this.COMMAND_REQUEST = "REQUEST";
        this.COMMAND_ACK = "ACK";
        this.COMMAND_DISCONNECT = "DISCONNECT";
        this.COMMAND_LEVEL = "LEVEL";
        this.midlet = midlet;
        this.networkManager = networkManager;
        this.server = server;
        this.packetFactory = PacketFactory.getPacketFactory();
    }

    public synchronized void receive(Packet packet) {
        int selPlayer;
        if (packet.getType() != 1) {
            if (this.listener != null) {
                this.listener.receive(packet);
            } else {
                this.packetFactory.releasePacket(packet);
            }
            return;
        }
        String command = null;
        String commandString = ((CommandPacket)packet).getCommand();
        int[] arg = new int[2];
        int argn = 0;
        int x = commandString.indexOf(32);
        if (x == -1) {
            command = commandString;
        } else {
            command = commandString.substring(0, x);
            do {
                int end;
                arg[argn++] = (end = commandString.indexOf(32, x + 1)) == -1 ? Integer.parseInt(commandString.substring(x + 1)) : Integer.parseInt(commandString.substring(x + 1, end));
            } while ((x = commandString.indexOf(32, x + 1)) != -1);
        }
        if (command.equals("REQUEST")) {
            selPlayer = arg[0];
            if (selPlayer == -1 || this.selectedActor[selPlayer] == -1) {
                if (this.selectedPlayer[packet.getSourceID()] != -1) {
                    this.selectedActor[this.selectedPlayer[packet.getSourceID()]] = -1;
                }
                this.selectedPlayer[packet.getSourceID()] = selPlayer;
                if (selPlayer != -1) {
                    this.selectedActor[selPlayer] = packet.getSourceID();
                }
                CommandPacket commandPacket = (CommandPacket)this.packetFactory.getPacket(1);
                commandPacket.setCommand("ACK " + selPlayer + " " + packet.getSourceID());
                this.networkManager.sendAll(commandPacket);
                this.setChanged();
            }
        } else if (command.equals("ACK")) {
            selPlayer = arg[0];
            int source = arg[1];
            if (this.selectedPlayer[source] != -1) {
                this.selectedActor[this.selectedPlayer[source]] = -1;
            }
            if (source == this.networkManager.getNetworkID()) {
                this.selected = selPlayer;
            }
            this.selectedPlayer[source] = selPlayer;
            if (selPlayer != -1) {
                this.selectedActor[selPlayer] = source;
            }
            this.setChanged();
        } else if (command.equals("DISCONNECT")) {
            int networkID = arg[0];
            if (this.selectedPlayer[networkID] != -1) {
                this.selectedActor[this.selectedPlayer[networkID]] = -1;
                this.selectedPlayer[networkID] = -1;
            }
            this.setChanged();
        } else if (command.equals("LEVEL")) {
            this.map = arg[0];
            this.setChanged();
        } else if (command.equals("START")) {
            int[] list = new int[5];
            for (int i = 0; i < 5; ++i) {
                list[i] = this.selectedActor[i] == -1 ? 0 : this.selectedActor[i];
            }
            if (this.server) {
                this.midlet.pacmanMultiplayerServer(this.selected, list, this.map);
            } else {
                this.midlet.pacmanMultiplayerClient(this.selected, list, this.map);
            }
        } else {
            if (this.listener != null) {
                this.listener.receive(packet);
            }
            return;
        }
        this.notifyObservers();
        if (packet.decreaseReferences() == 0) {
            this.packetFactory.releasePacket(packet);
        }
    }

    public void newConnection(int networkID) {
        if (this.server) {
            for (int i = 0; i < 5; ++i) {
                if (this.selectedPlayer[i] == -1) continue;
                CommandPacket commandPacket = (CommandPacket)this.packetFactory.getPacket(1);
                commandPacket.setCommand("ACK " + this.selectedPlayer[i] + " " + i);
                this.networkManager.send(networkID, commandPacket);
            }
            CommandPacket packet = (CommandPacket)this.packetFactory.getPacket(1);
            packet.setCommand("LEVEL " + this.map);
            this.networkManager.send(networkID, packet);
        }
    }

    public void closedConnection(int networkID) {
        if (this.server) {
            CommandPacket commandPacket = (CommandPacket)this.packetFactory.getPacket(1);
            commandPacket.setCommand("DISCONNECT " + networkID);
            ((BluetoothServer)this.networkManager).sendAll(commandPacket);
        } else {
            this.midlet.connectionError();
        }
    }

    public int[] getPlayerList() {
        return this.selectedPlayer;
    }

    public int[] getActorList() {
        return this.selectedActor;
    }

    public int getSelected() {
        return this.selected;
    }

    public void startGame() {
        if (this.selected != -1) {
            CommandPacket packet = (CommandPacket)this.packetFactory.getPacket(1);
            packet.setCommand("START");
            this.networkManager.sendAll(packet);
        }
    }

    public void cancel() {
        this.networkManager.stop();
        this.midlet.pacmanMenuBack();
    }

    public void choose(int player) {
        CommandPacket packet = (CommandPacket)this.packetFactory.getPacket(1);
        packet.setCommand("REQUEST " + player);
        this.networkManager.send(0, packet);
    }

    public void dechoose() {
        CommandPacket packet = (CommandPacket)this.packetFactory.getPacket(1);
        packet.setCommand("REQUEST -1");
        this.networkManager.send(0, packet);
    }

    public void selectMap(int map) {
        CommandPacket packet = (CommandPacket)this.packetFactory.getPacket(1);
        packet.setCommand("LEVEL " + map);
        this.networkManager.sendAll(packet);
    }

    public boolean isServer() {
        return this.server;
    }

    public int getSelectedMap() {
        return this.map;
    }

    public void setNextListener(NetworkListener listener) {
        this.listener = listener;
    }
}

