/*
 * Decompiled with CFR 0.152.
 */
package multipacman.network;

import java.util.Enumeration;
import java.util.Vector;
import multipacman.PacmanMIDlet;
import multipacman.game.Controller;
import multipacman.game.World;
import multipacman.network.ConnectionListener;
import multipacman.network.FieldObserver;
import multipacman.network.NetworkListener;
import multipacman.network.NetworkManager;
import multipacman.network.Packet;
import multipacman.network.PacketFactory;
import multipacman.network.PositionObserver;
import multipacman.network.PositionPacket;
import multipacman.network.StatusObserver;
import multipacman.util.Executable;

public class MultiplayerLayer
implements NetworkListener,
ConnectionListener,
Runnable {
    private Vector controllerList = new Vector();
    private StatusObserver statusObserver;
    private PositionObserver positionObserver;
    private FieldObserver fieldObserver;
    private NetworkManager networkManager;
    private NetworkListener nextListener = null;
    private PacketFactory packetFactory;
    private Thread t;
    private boolean isRunning = false;
    private int[] selectedPlayer;
    private World world;
    private PacmanMIDlet midlet;
    private static final int NETWORK_REFRESH = 500;

    public MultiplayerLayer(PacmanMIDlet midlet, NetworkManager networkManager, World world) {
        this.midlet = midlet;
        this.networkManager = networkManager;
        this.world = world;
        this.packetFactory = PacketFactory.getPacketFactory();
        this.statusObserver = new StatusObserver(networkManager);
        this.positionObserver = new PositionObserver(networkManager);
        this.fieldObserver = new FieldObserver(networkManager);
    }

    public void run() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        while (this.isRunning) {
            Enumeration enumeration = this.controllerList.elements();
            while (enumeration.hasMoreElements()) {
                Controller controller = (Controller)enumeration.nextElement();
                PositionPacket packet = (PositionPacket)this.packetFactory.getPacket(0);
                packet.createPacket(controller);
                this.networkManager.sendAll(packet);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
    }

    public boolean handlePacket(Packet packet) {
        if (this.isRunning && packet.getType() != 1) {
            if (packet.getSourceID() != this.networkManager.getNetworkID()) {
                ((Executable)((Object)packet)).execute();
            }
            return true;
        }
        return false;
    }

    public void receive(Packet packet) {
        if (!this.handlePacket(packet) && this.nextListener != null) {
            this.nextListener.receive(packet);
        } else {
            this.packetFactory.releasePacket(packet);
        }
    }

    public void startServer(int player, int[] selectedPlayer) {
        int i;
        this.controllerList = new Vector();
        this.selectedPlayer = selectedPlayer;
        boolean handlePacman = selectedPlayer[4] == 0;
        Controller[] controller = this.world.getController();
        for (i = 0; i < 5; ++i) {
            if (selectedPlayer[i] != 0) {
                controller[i].setAIMode(2);
            }
            controller[i].deleteObservers();
        }
        if (handlePacman) {
            this.world.getField().addObserver(this.fieldObserver);
        } else {
            this.world.getField().deleteObservers();
        }
        for (i = 0; i < 5; ++i) {
            if (selectedPlayer[i] == 0) {
                this.controllerList.addElement(controller[i]);
                controller[i].addObserver(this.positionObserver);
            }
            if (!handlePacman) continue;
            controller[i].addObserver(this.statusObserver);
        }
        this.isRunning = true;
        this.t = new Thread(this);
        this.t.start();
    }

    public void startClient(int player, int[] selectedPlayer) {
        this.controllerList = new Vector();
        this.selectedPlayer = selectedPlayer;
        Controller[] controller = this.world.getController();
        for (int i = 0; i < 5; ++i) {
            if (selectedPlayer[i] != -1 && selectedPlayer[i] != this.networkManager.getNetworkID()) {
                controller[i].setAIMode(2);
            }
            controller[i].deleteObservers();
            if (player != 4) continue;
            controller[i].addObserver(this.statusObserver);
        }
        if (player == 4) {
            this.world.getField().addObserver(this.fieldObserver);
        } else {
            this.world.getField().deleteObservers();
        }
        this.controllerList.addElement(controller[player]);
        controller[player].addObserver(this.positionObserver);
        this.isRunning = true;
        this.t = new Thread(this);
        this.t.start();
    }

    public void newConnection(int networkID) {
    }

    public void closedConnection(int networkID) {
        if (networkID == 0) {
            this.midlet.connectionError();
        } else if (this.isRunning) {
            Controller[] c = this.world.getController();
            for (int i = 0; i < 5; ++i) {
                if (this.selectedPlayer[i] != networkID) continue;
                c[i].setAIMode(0);
                this.controllerList.addElement(c[i]);
                c[i].addObserver(this.positionObserver);
                if (i != 4) continue;
                for (int j = 0; j < 5; ++j) {
                    c[j].addObserver(this.statusObserver);
                    this.world.getField().addObserver(this.fieldObserver);
                }
            }
        }
    }

    public void stop() {
        this.isRunning = false;
    }

    public void setNextListener(NetworkListener nextListener) {
        this.nextListener = nextListener;
    }
}

