/*
 * Decompiled with CFR 0.152.
 */
package multipacman.network;

import multipacman.game.Controller;
import multipacman.network.Packet;
import multipacman.util.Executable;

public class PositionPacket
extends Packet
implements Executable {
    private byte[] byteArray = new byte[6];
    private Controller controller;

    public PositionPacket() {
    }

    public PositionPacket(byte[] data, int length, Controller controller) {
        this.parseByteArray(data, length);
        this.controller = controller;
    }

    public PositionPacket(Controller controller) {
        this.controller = controller;
        this.createPacket(controller);
    }

    public byte[] getByteArray() {
        return this.byteArray;
    }

    public void parseByteArray(byte[] data, int length) {
        System.arraycopy(data, 0, this.byteArray, 0, length);
    }

    public void createPacket(Controller controller) {
        this.controller = controller;
        int[] pos = controller.getPosition();
        this.byteArray[2] = controller.getId();
        this.byteArray[3] = (byte)pos[0];
        this.byteArray[4] = (byte)pos[1];
        this.byteArray[5] = (byte)controller.getNextDirection();
    }

    public void execute() {
        int[] pos = new int[]{this.byteArray[3] & 0xFF, this.byteArray[4] & 0xFF};
        byte id = this.controller.getId();
        this.controller.setPosition(pos);
        this.controller.setNextDirection(this.byteArray[5]);
    }

    public int getType() {
        return 0;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public int getActorID() {
        return this.byteArray[2] & 0xFF;
    }

    public void setActorID(int actorID) {
        this.byteArray[2] = (byte)actorID;
    }

    public int getSourceID() {
        return this.byteArray[1] & 0xF;
    }

    public void setSourceID(int sourceID) {
        this.byteArray[1] = (byte)(this.byteArray[1] & 0xF0 | sourceID);
    }

    public int getDestID() {
        return (this.byteArray[1] & 0xFF) >> 4;
    }

    public void setDestID(int destID) {
        this.byteArray[1] = (byte)(destID << 4 | this.byteArray[1] & 0xF);
    }
}

