/*
 * Decompiled with CFR 0.152.
 */
package multipacman.network;

import multipacman.game.Controller;
import multipacman.game.ControllerPacman;
import multipacman.network.Packet;
import multipacman.util.Executable;

public class StatusPacket
extends Packet
implements Executable {
    private int actor;
    private boolean alive;
    private boolean superMode;
    private boolean blinkingMode;
    private Controller controller;
    private byte[] byteArray = new byte[4];

    public StatusPacket() {
    }

    public StatusPacket(byte[] data, int length, Controller controller) {
        this.parseByteArray(data, length);
        this.controller = controller;
    }

    public byte[] getByteArray() {
        this.byteArray[0] = 2;
        this.byteArray[1] = (byte)(this.sourceID | this.destID << 4);
        this.byteArray[2] = (byte)this.actor;
        this.byteArray[3] = (byte)((this.alive ? 1 : 0) | (this.superMode ? 2 : 0) | (this.blinkingMode ? 4 : 0));
        return this.byteArray;
    }

    public void parseByteArray(byte[] data, int length) {
        this.sourceID = data[1] & 0xF;
        this.destID = (data[1] & 0xFF) >> 4;
        this.actor = data[2] & 0xFF;
        this.alive = (data[3] & 1) == 1;
        this.superMode = (data[3] & 2) == 2;
        this.blinkingMode = (data[3] & 4) == 4;
    }

    public void createPacket(Controller controller) {
        this.actor = controller.getId();
        this.alive = controller.isAlive();
        if (this.actor == 4) {
            this.superMode = ((ControllerPacman)controller).isInMagicMode();
            this.blinkingMode = ((ControllerPacman)controller).isInBlinkingMode();
        }
    }

    public void execute() {
        this.controller.setAlive(this.alive);
        if (this.actor == 4) {
            ((ControllerPacman)this.controller).setMagicMode(this.superMode);
            ((ControllerPacman)this.controller).setBlinkingMode(this.blinkingMode);
        }
    }

    public int getType() {
        return 2;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public int getActorID() {
        return this.actor;
    }

    public void setActorID(int actorID) {
        this.actor = actorID;
    }
}

