/*
 * Decompiled with CFR 0.152.
 */
package multipacman.network.bluetooth;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.Connector;
import multipacman.network.CommandPacket;
import multipacman.network.ConnectionErrorHandler;
import multipacman.network.ConnectionListener;
import multipacman.network.NetworkListener;
import multipacman.network.NetworkManager;
import multipacman.network.Packet;
import multipacman.network.bluetooth.ReceiveThread;
import multipacman.network.bluetooth.SendThread;

public class BluetoothServer
implements NetworkListener,
NetworkManager,
ConnectionErrorHandler {
    public static final int MODE_ACCEPT = 0;
    public static final int MODE_DECLINE = 1;
    private LocalDevice local;
    private int currentClients = 0;
    private int maxClients;
    private Thread t;
    private boolean hasStarted;
    private Hashtable receiveThreads = new Hashtable();
    private Hashtable sendThreads = new Hashtable();
    private NetworkListener listener;
    private Vector connectionListeners = new Vector();
    private Vector networkIDs = new Vector();
    private int mode = 0;
    private L2CAPConnectionNotifier service;

    public BluetoothServer() {
        try {
            this.local = LocalDevice.getLocalDevice();
            this.maxClients = Integer.parseInt(LocalDevice.getProperty((String)"bluetooth.connected.devices.max"));
        }
        catch (BluetoothStateException e1) {
            // empty catch block
        }
        if (this.maxClients > 4) {
            this.maxClients = 4;
        }
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            this.networkIDs.addElement(new Integer(i));
        }
        this.t = new Thread(this);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.local.setDiscoverable(10390323);
            this.service = (L2CAPConnectionNotifier)Connector.open((String)"btl2cap://localhost:2D26618601FB47C28D9F10B8EC891363");
        }
        catch (SecurityException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        while (this.currentClients < this.maxClients && this.mode == 0) {
            try {
                L2CAPConnection connection = this.service.acceptAndOpen();
                if (this.mode == 0) {
                    Integer networkID = null;
                    Vector vector = this.networkIDs;
                    synchronized (vector) {
                        networkID = (Integer)this.networkIDs.firstElement();
                        this.networkIDs.removeElementAt(0);
                    }
                    SendThread sendThread = new SendThread(connection);
                    sendThread.setConnectionErrorHandler(this);
                    sendThread.start();
                    this.sendThreads.put(networkID, sendThread);
                    sendThread.send(new CommandPacket(networkID.toString()));
                    ReceiveThread receiveThread = new ReceiveThread(connection, this);
                    receiveThread.setConnectionErrorHandler(this);
                    receiveThread.start();
                    this.receiveThreads.put(networkID, receiveThread);
                    Enumeration enumeration = this.connectionListeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((ConnectionListener)enumeration.nextElement()).newConnection(networkID);
                    }
                    ++this.currentClients;
                    continue;
                }
                connection.close();
            }
            catch (IOException e) {
            }
            catch (SecurityException e) {}
        }
        try {
            this.service.close();
            this.local.setDiscoverable(0);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void stop() {
        try {
            this.mode = 1;
            this.service.close();
            Enumeration enumeration = this.receiveThreads.elements();
            while (enumeration.hasMoreElements()) {
                ((ReceiveThread)enumeration.nextElement()).stop();
            }
            enumeration = this.sendThreads.elements();
            while (enumeration.hasMoreElements()) {
                ((SendThread)enumeration.nextElement()).stop();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void receive(Packet packet) {
        switch (packet.getDestID()) {
            case 15: {
                packet.setReferences(this.currentClients + 1);
                this.resend(packet);
                this.listener.receive(packet);
                break;
            }
            default: {
                this.send(packet.getSourceID(), packet.getDestID(), packet);
            }
        }
    }

    public void send(int destID, Packet packet) {
        this.send(0, destID, packet);
    }

    public void send(int sourceID, int destID, Packet packet) {
        packet.setSourceID(sourceID);
        packet.setReferences(1);
        if (destID == this.getNetworkID()) {
            this.listener.receive(packet);
        } else {
            ((SendThread)this.sendThreads.get(new Integer(destID))).send(packet);
        }
    }

    public void sendAll(Packet packet) {
        packet.setSourceID(0);
        packet.setDestID(15);
        Enumeration enumeration = this.sendThreads.elements();
        packet.setReferences(this.currentClients + 1);
        while (enumeration.hasMoreElements()) {
            ((SendThread)enumeration.nextElement()).send(packet);
        }
        this.listener.receive(packet);
    }

    public void resend(Packet packet) {
        Enumeration enumeration = this.sendThreads.elements();
        while (enumeration.hasMoreElements()) {
            ((SendThread)enumeration.nextElement()).send(packet);
        }
    }

    public void setNextListener(NetworkListener listener) {
        this.listener = listener;
    }

    public int getNetworkID() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connectionError(Object o) {
        Integer key;
        Enumeration keys;
        Integer networkID = null;
        if (this.receiveThreads.contains(o)) {
            keys = this.receiveThreads.keys();
            while (keys.hasMoreElements()) {
                key = (Integer)keys.nextElement();
                if (!this.receiveThreads.get(key).equals(o)) continue;
                networkID = key;
            }
        } else if (this.sendThreads.contains(o)) {
            keys = this.sendThreads.keys();
            while (keys.hasMoreElements()) {
                key = (Integer)keys.nextElement();
                if (!this.sendThreads.get(key).equals(o)) continue;
                networkID = key;
            }
        }
        if (networkID != null) {
            Vector vector = this.networkIDs;
            synchronized (vector) {
                this.sendThreads.remove(networkID);
                this.receiveThreads.remove(networkID);
                Enumeration enumeration = this.connectionListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((ConnectionListener)enumeration.nextElement()).closedConnection(networkID);
                }
                this.networkIDs.addElement(networkID);
            }
            --this.currentClients;
            if (!this.t.isAlive() && this.mode == 0) {
                this.t = new Thread(this);
                this.t.start();
            }
        }
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.addElement(connectionListener);
    }

    public void removeAllConnectionListener() {
        this.connectionListeners.removeAllElements();
    }
}

