/*
 * Decompiled with CFR 0.152.
 */
package multipacman.network.bluetooth;

import java.io.IOException;
import javax.bluetooth.L2CAPConnection;
import multipacman.network.ConnectionErrorHandler;
import multipacman.network.NetworkListener;
import multipacman.network.Packet;
import multipacman.network.PacketFactory;

public class ReceiveThread
extends Thread {
    private L2CAPConnection connection;
    private boolean isRunning = true;
    private PacketFactory packetFactory;
    private NetworkListener listener;
    private ConnectionErrorHandler connectionErrorHandler;

    public ReceiveThread(L2CAPConnection connection, NetworkListener listener) {
        this.connection = connection;
        this.listener = listener;
        this.packetFactory = PacketFactory.getPacketFactory();
    }

    public void run() {
        block3: {
            try {
                int length = this.connection.getReceiveMTU();
                byte[] data = new byte[length];
                while (this.isRunning) {
                    length = this.connection.receive(data);
                    Packet packet = this.packetFactory.getPacket(data, length);
                    this.listener.receive(packet);
                }
            }
            catch (IOException e) {
                if (this.connectionErrorHandler == null) break block3;
                this.connectionErrorHandler.connectionError(this);
            }
        }
    }

    public void setConnectionErrorHandler(ConnectionErrorHandler connectionErrorHandler) {
        this.connectionErrorHandler = connectionErrorHandler;
    }

    public void stop() {
        this.isRunning = false;
        this.connectionErrorHandler = null;
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

