/*
 * Decompiled with CFR 0.152.
 */
package multipacman.network.bluetooth;

import java.io.IOException;
import javax.bluetooth.L2CAPConnection;
import multipacman.network.ConnectionErrorHandler;
import multipacman.network.Packet;
import multipacman.network.PacketFactory;

public class SendThread
extends Thread {
    private static final int BUFFERSIZE = 20;
    private L2CAPConnection connection;
    private PacketFactory packetFactory;
    private ConnectionErrorHandler connectionErrorHandler;
    private boolean isRunning = true;
    private Packet[] queue = new Packet[20];
    private int position1 = 0;
    private int position2 = 0;

    public SendThread(L2CAPConnection connection) {
        this.connection = connection;
        this.packetFactory = PacketFactory.getPacketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            while (this.isRunning) {
                Packet[] packetArray = this.queue;
                // MONITORENTER : this.queue
                if (this.position1 == this.position2) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.position1 = (this.position1 + 1) % 20;
                Packet packet = this.queue[this.position1];
                // MONITOREXIT : packetArray
                this.connection.send(packet.getByteArray());
                if (packet.decreaseReferences() != 0) continue;
                this.packetFactory.releasePacket(packet);
            }
            return;
        }
        catch (IOException e) {
            if (this.connectionErrorHandler == null) return;
            this.connectionErrorHandler.connectionError(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Packet packet) {
        Packet[] packetArray = this.queue;
        synchronized (this.queue) {
            this.position2 = (this.position2 + 1) % 20;
            this.queue[this.position2] = packet;
            this.queue.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setConnectionErrorHandler(ConnectionErrorHandler connectionErrorHandler) {
        this.connectionErrorHandler = connectionErrorHandler;
    }

    public void stop() {
        this.isRunning = false;
        this.connectionErrorHandler = null;
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

