/*
 * Decompiled with CFR 0.152.
 */
package multipacman.util;

import java.util.Enumeration;
import java.util.Vector;
import multipacman.util.Observer;

public abstract class Observable {
    private Vector observerList = new Vector();
    private boolean changed = false;

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public void notifyObservers(Object arg) {
        if (this.hasChanged()) {
            Enumeration enumeration = this.observerList.elements();
            while (enumeration.hasMoreElements()) {
                ((Observer)enumeration.nextElement()).doUpdate(this, arg);
            }
            this.clearChanged();
        }
    }

    public void addObserver(Observer o) {
        this.observerList.addElement(o);
    }

    public void deleteObserver(Observer o) {
        this.observerList.removeElement(o);
    }

    public void deleteObservers() {
        this.observerList.removeAllElements();
    }

    public void setChanged() {
        this.changed = true;
    }

    public void clearChanged() {
        this.changed = false;
    }

    public boolean hasChanged() {
        return this.changed;
    }
}

