/*
 * Decompiled with CFR 0.152.
 */
package com.chess;

import com.chess.ChesscomMIDlet;
import com.chess.input.Keys;
import com.chess.input.Pointer;
import com.chess.screens.AnalysisScreen;
import com.chess.screens.BoardScreen;
import com.chess.screens.CreateGameScreen;
import com.chess.screens.GamesListScreen;
import com.chess.screens.IScreen;
import com.chess.screens.LoginScreen;
import com.chess.screens.MessageScreen;
import com.chess.screens.SeekGameScreen;
import com.chess.screens.SettingsScreen;
import java.io.IOException;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class ChesscomCanvas
extends GameCanvas {
    public ChesscomMIDlet midlet;
    private Keys keys;
    private Pointer pointer;
    private Graphics screenGfx;
    public int width;
    public int height;
    private IScreen screen;
    private long displayTimeCounter = 0L;
    private boolean init = false;
    public GamesListScreen gamesListScreen;
    public BoardScreen boardScreen;
    public AnalysisScreen analysisScreen;
    public LoginScreen loginScreen;
    public SettingsScreen settingsScreen;
    public MessageScreen messageScreen;
    public CreateGameScreen createGameScreen;
    public SeekGameScreen seekGameScreen;
    private int customLeftCounter = 0;
    private int customLeftTemp = -6;
    public int customLeftKey = -6;
    private boolean customLeftKeySet = false;
    private int customRightCounter = 0;
    public int customRightKey = -7;
    private int customRightTemp = -6;
    private boolean customRightKeySet = true;

    public ChesscomCanvas(ChesscomMIDlet chesscomMIDlet) throws IOException {
        super(false);
        this.midlet = chesscomMIDlet;
        this.setFullScreenMode(true);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.keys = new Keys();
        this.pointer = new Pointer();
        this.screenGfx = this.getGraphics();
        this.loginScreen = new LoginScreen(this);
        this.screen = this.loginScreen;
        this.displayTimeCounter = System.currentTimeMillis();
    }

    public void draw() {
        if (!this.init) {
            this.screen.init(this.screenGfx);
            this.init = true;
        }
        this.screen.draw(this.screenGfx, System.currentTimeMillis() - this.displayTimeCounter);
        this.repaint();
        this.serviceRepaints();
        this.flushGraphics();
    }

    protected void keyPressed(int n) {
        this.translateKeys(n, true);
    }

    protected void keyRepeated(int n) {
        this.translateKeys(n, true);
    }

    protected void pointerPressed(int n, int n2) {
        this.pointer.x = n;
        this.pointer.y = n2;
        this.pointer.fire = true;
    }

    private void translateKeys(int n, boolean bl) {
        boolean bl2 = false;
        try {
            switch (this.getGameAction(n)) {
                case 1: {
                    this.keys.up = bl;
                    bl2 = true;
                    break;
                }
                case 6: {
                    this.keys.down = bl;
                    bl2 = true;
                    break;
                }
                case 2: {
                    this.keys.left = bl;
                    bl2 = true;
                    break;
                }
                case 5: {
                    this.keys.right = bl;
                    bl2 = true;
                    break;
                }
                case 8: {
                    this.keys.fire = bl;
                    bl2 = true;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (n == -6 || n == -21 || n == this.customLeftKey || n == 113) {
            this.keys.menuLeft = bl;
            bl2 = true;
        } else if (n == -7 || n == -22 || n == this.customRightKey || n == 111) {
            this.keys.menuRight = bl;
            bl2 = true;
        }
        if (!bl2 && 53 == n) {
            this.keys.fire = bl;
            bl2 = true;
        }
        if (!bl2 && this.customRightKey == -7 && this.screen.equals(this.loginScreen)) {
            this.setCustomKey(n);
        }
    }

    private void setCustomKey(int n) {
        if (this.customRightKeySet) {
            if (this.customLeftCounter == 0) {
                if (n != this.customRightKey) {
                    this.customLeftTemp = n;
                    ++this.customLeftCounter;
                }
            } else if (this.customLeftCounter > 0 && n == this.customLeftTemp) {
                ++this.customLeftCounter;
                if (this.customLeftCounter >= 3) {
                    this.customLeftKey = this.customLeftTemp;
                    this.customLeftKeySet = true;
                    this.customRightKeySet = false;
                    System.out.println("Left key set to " + n);
                }
            } else {
                this.customLeftCounter = 0;
            }
        } else if (this.customLeftKeySet) {
            if (this.customRightCounter == 0) {
                if (n != this.customLeftKey) {
                    this.customRightTemp = n;
                    ++this.customRightCounter;
                }
            } else if (this.customRightCounter > 0 && n == this.customRightTemp) {
                ++this.customRightCounter;
                if (this.customRightCounter >= 3) {
                    this.customRightKey = this.customRightTemp;
                    this.customRightKeySet = true;
                    this.customLeftKeySet = false;
                    System.out.println("Right key set to " + n);
                }
            } else {
                this.customRightCounter = 0;
            }
        }
    }

    public void setScreen(IScreen iScreen) {
        this.resetTime();
        this.screen = iScreen;
        this.init = false;
        this.midlet.setDisplayable((Displayable)this.midlet.canvas);
    }

    public void setUserNameDisplayable(String string) {
        this.midlet.textBox.textUserName.setString(string);
        this.midlet.setDisplayable((Displayable)this.midlet.textBox.textUserName);
    }

    public void setPasswordDisplayable() {
        this.midlet.setDisplayable((Displayable)this.midlet.textBox.textPassword);
    }

    public void setMessageDisplayable(String string) {
        this.midlet.textBox.textMessage.setString(string);
        this.midlet.setDisplayable((Displayable)this.midlet.textBox.textMessage);
    }

    public void setOpponentDisplayable(String string) {
        this.midlet.textBox.textOpponentName.setString(string);
        this.midlet.setDisplayable((Displayable)this.midlet.textBox.textOpponentName);
    }

    public void setMinDisplayable(String string) {
        this.midlet.textBox.textMin.setString(string);
        this.midlet.setDisplayable((Displayable)this.midlet.textBox.textMin);
    }

    public void setMaxDisplayable(String string) {
        this.midlet.textBox.textMax.setString(string);
        this.midlet.setDisplayable((Displayable)this.midlet.textBox.textMax);
    }

    public void resetTime() {
        this.displayTimeCounter = System.currentTimeMillis();
    }

    public Keys getKeys() {
        Keys keys = this.keys.copy();
        this.keys.reset();
        return keys;
    }

    public Pointer getPointer() {
        Pointer pointer = this.pointer.copy();
        this.pointer.reset();
        return pointer;
    }

    public void destroy() {
        this.gamesListScreen = null;
        this.boardScreen = null;
        this.loginScreen = null;
        this.midlet = null;
    }

    protected void showNotify() {
        this.screenGfx = this.getGraphics();
        this.screenGfx.setClip(0, 0, this.width, this.height);
        if (this.midlet != null) {
            this.midlet.paused = false;
        }
    }

    protected void hideNotify() {
        if (this.midlet != null) {
            this.midlet.paused = true;
        }
    }
}

