/*
 * Decompiled with CFR 0.152.
 */
package com.chess;

import com.chess.ChesscomCanvas;
import com.chess.internet.Internet;
import com.chess.internet.SecurityCheckThread;
import com.chess.rms.PersistentStore;
import com.chess.screens.ChesscomTextBox;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class ChesscomMIDlet
extends MIDlet
implements Runnable {
    public static final String VERSION = "2.7";
    public static String version = "";
    public boolean running = false;
    public boolean paused = false;
    public boolean destroy = false;
    public Thread thread;
    public Display display;
    public Displayable displayable;
    public ChesscomCanvas canvas;
    public ChesscomTextBox textBox;
    public PersistentStore store;
    public Internet internet;
    public String securityMessage = null;
    public boolean requestSecurityCheck = false;
    public boolean securityChecked = false;

    private void initialize() throws MIDletStateChangeException {
        try {
            this.store = new PersistentStore();
            this.internet = new Internet();
            this.canvas = new ChesscomCanvas(this);
            this.textBox = new ChesscomTextBox(this);
            this.displayable = this.canvas;
            this.thread = new Thread(this);
            this.paused = false;
            this.running = true;
        }
        catch (IOException iOException) {
            System.out.println("Got IOException " + iOException);
            iOException.printStackTrace();
            throw new MIDletStateChangeException();
        }
    }

    protected void startApp() throws MIDletStateChangeException {
        if (this.paused) {
            System.out.println("Returning from paused...");
            this.paused = false;
            this.display = Display.getDisplay((MIDlet)this);
            this.display.setCurrent(this.displayable);
            this.canvas.repaint();
        } else {
            System.out.println("Starting up...");
            this.initialize();
            this.display = Display.getDisplay((MIDlet)this);
            this.display.setCurrent(this.displayable);
            this.thread.start();
        }
    }

    public void run() {
        while (this.running) {
            while (this.paused) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.requestSecurityCheck) {
                this.checkSecurity();
                this.requestSecurityCheck = false;
            }
            if (this.canvas != null && ((Object)((Object)this.canvas)).equals(this.displayable)) {
                this.canvas.draw();
            }
            this.sleep();
        }
        if (this.destroy) {
            try {
                this.destroyApp(true);
            }
            catch (MIDletStateChangeException mIDletStateChangeException) {
                // empty catch block
            }
        }
    }

    public void setDisplayable(Displayable displayable) {
        this.displayable = displayable;
        this.display.setCurrent(this.displayable);
    }

    public void destroy() {
        this.destroy = true;
        this.running = false;
    }

    protected void pauseApp() {
        this.paused = true;
        this.notifyPaused();
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
        System.out.println("Shutting down...");
        this.canvas.destroy();
        this.canvas = null;
        this.textBox = null;
        this.displayable = null;
        this.store = null;
        this.internet = null;
        this.notifyDestroyed();
    }

    public void checkSecurity() {
        if (!this.securityChecked) {
            SecurityCheckThread securityCheckThread = new SecurityCheckThread(this);
            securityCheckThread.start();
            while (securityCheckThread.running) {
                this.sleep();
            }
            this.securityMessage = securityCheckThread.message;
            securityCheckThread = null;
            this.display = Display.getDisplay((MIDlet)this);
            this.displayable = this.canvas;
            this.display.setCurrent(this.displayable);
            this.securityChecked = true;
        }
    }

    private void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

