/*
 * Decompiled with CFR 0.152.
 */
package com.chess.chessboard;

import com.chess.chessboard.Piece;

public class ChessGame {
    public String id;
    public boolean playAsWhite;
    public boolean chess960;
    public String opponent;
    public String timeLeft;
    public Piece[] pieces;
    public String castling;
    public String enPassant;
    public int lastFromX;
    public int lastFromY;
    public int lastToX;
    public int lastToY;
    public int rookCastlingX = -1;
    public int rookCastlingId = -1;
    public int kingCastlingX = -1;
    public int kingCastlingXE = -1;
    public int kingCastlingId = -1;
    public int takenPieceId = -1;
    public Piece takenPiece;
    public int promotedId = -1;
    public int fullMove = 0;
    public String lastDesc;
    public boolean pendingDrawOffer;
    public String timeStamp;
    public boolean online;
    public boolean myMove;

    public ChessGame getAnalysisCopy() {
        ChessGame chessGame = new ChessGame();
        chessGame.playAsWhite = this.playAsWhite;
        chessGame.opponent = this.opponent;
        chessGame.timeLeft = this.timeLeft;
        chessGame.chess960 = this.chess960;
        Piece[] pieceArray = new Piece[this.pieces.length];
        for (int i = 0; i < this.pieces.length; ++i) {
            pieceArray[i] = this.pieces[i].copy();
        }
        chessGame.pieces = pieceArray;
        chessGame.castling = this.castling;
        chessGame.enPassant = this.enPassant;
        chessGame.lastFromX = this.lastFromX;
        chessGame.lastFromY = this.lastFromY;
        chessGame.lastToX = this.lastToX;
        chessGame.lastToY = this.lastToY;
        chessGame.myMove = this.myMove;
        return chessGame;
    }

    public void setFEN(String string) throws Exception {
        int n = string.indexOf(" ");
        this.pieces = this.parseFENPieces(string.substring(0, n));
        int n2 = string.indexOf(" ", n + 3);
        this.castling = string.substring(n + 3, n2).trim();
        this.enPassant = string.substring(n2 + 1, n2 + 3).trim();
        int n3 = string.indexOf(" ", n2 + 4);
        this.fullMove = Integer.parseInt(string.substring(n3 + 1, string.length()));
        if (this.playAsWhite && this.fullMove > 0) {
            --this.fullMove;
        }
    }

    private Piece[] parseFENPieces(String string) throws Exception {
        int n = this.countPieces(string);
        this.pieces = new Piece[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 8; ++i) {
            int n4;
            String string2 = null;
            if (i == 7) {
                string2 = string.substring(n3);
            } else {
                n4 = string.indexOf("/", n3);
                string2 = string.substring(n3, n4);
                n3 = n4 + 1;
            }
            n4 = 0;
            for (int j = 0; j < string2.length(); ++j) {
                char c = string2.charAt(j);
                if (Character.isDigit(c)) {
                    n4 += Character.digit(c, 10) - 1;
                } else {
                    this.pieces[n2] = this.playAsWhite ? new Piece(c, n4, i) : new Piece(c, 7 - n4, 7 - i);
                    ++n2;
                }
                ++n4;
            }
        }
        return this.pieces;
    }

    private int countPieces(String string) throws Exception {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || c == '/') continue;
            ++n;
        }
        return n;
    }

    public boolean pieceIdBelongToPlayer(int n) {
        Piece piece = this.pieces[n];
        return Character.isUpperCase(piece.type) & this.playAsWhite || Character.isLowerCase(piece.type) & !this.playAsWhite;
    }

    public void promote(int n, char c) {
        this.pieces[n].type = c;
        this.promotedId = n;
    }

    public void resetMove() {
        this.resetCastling();
        this.resetTaken();
        this.resetPromotion();
    }

    private void resetPromotion() {
        if (this.promotedId != -1) {
            this.pieces[this.promotedId].type = (char)(this.playAsWhite ? 80 : 112);
            this.promotedId = -1;
        }
    }

    private void resetTaken() {
        if (this.takenPieceId != -1) {
            this.pieces[this.takenPieceId] = this.takenPiece.copy();
            this.takenPiece = null;
            this.takenPieceId = -1;
        }
    }

    private void resetCastling() {
        if (this.rookCastlingId != -1) {
            this.pieces[this.rookCastlingId].x = this.rookCastlingX;
            this.rookCastlingId = -1;
            this.pieces[this.kingCastlingId].x = this.kingCastlingX;
        }
    }

    public void removePiece(int n) {
        this.takenPieceId = n;
        this.takenPiece = this.pieces[n].copy();
        this.pieces[n] = null;
    }

    public int getPieceIdAt(int n, int n2) {
        int n3 = -1;
        for (int i = 0; i < this.pieces.length; ++i) {
            if (this.pieces[i] == null || this.pieces[i].x != n || this.pieces[i].y != n2) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    public boolean castlingAllowed(String string) {
        System.out.println("Castling='" + this.castling + "'  Type=" + string);
        return this.castling.indexOf(string) != -1;
    }

    public int getX(String string) {
        int n = -1;
        if ("a".equals(string)) {
            n = this.playAsWhite ? 0 : 7;
        } else if ("b".equals(string)) {
            n = this.playAsWhite ? 1 : 6;
        } else if ("c".equals(string)) {
            n = this.playAsWhite ? 2 : 5;
        } else if ("d".equals(string)) {
            n = this.playAsWhite ? 3 : 4;
        } else if ("e".equals(string)) {
            n = this.playAsWhite ? 4 : 3;
        } else if ("f".equals(string)) {
            n = this.playAsWhite ? 5 : 2;
        } else if ("g".equals(string)) {
            n = this.playAsWhite ? 6 : 1;
        } else if ("h".equals(string)) {
            n = this.playAsWhite ? 7 : 0;
        }
        return n;
    }

    public int getY(int n) {
        return this.playAsWhite ? 8 - n : 7 - (8 - n);
    }

    public int getNewMoveY(int n) {
        return this.playAsWhite ? 8 - n : 1 + n;
    }

    public String getLetterX(int n) {
        String string = "a";
        switch (n) {
            case 0: {
                string = this.playAsWhite ? "a" : "h";
                break;
            }
            case 1: {
                string = this.playAsWhite ? "b" : "g";
                break;
            }
            case 2: {
                string = this.playAsWhite ? "c" : "f";
                break;
            }
            case 3: {
                string = this.playAsWhite ? "d" : "e";
                break;
            }
            case 4: {
                string = this.playAsWhite ? "e" : "d";
                break;
            }
            case 5: {
                string = this.playAsWhite ? "f" : "c";
                break;
            }
            case 6: {
                string = this.playAsWhite ? "g" : "b";
                break;
            }
            case 7: {
                string = this.playAsWhite ? "h" : "a";
            }
        }
        return string;
    }
}

